/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.utilities;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.core.transition.Tween;
import com.ibm.rave.ext.position.RavePosition;
import com.ibm.rave.ext.position.drop.DropOverlap;

public class BundleLabelDropper
implements RunFunction<Selection<?>> {
    @InlineStringConstant
    private static final String POSITION_EXTENSION = "position";
    private static final double OVERLAP_GAP = 4.0;
    private final DropOverlap _dropOverlap = ((RavePosition)Rave.capabilities.extension("position")).drop().remove(false);
    private int labelCount = 0;

    public BundleLabelDropper() {
        this._dropOverlap.setOverlapGap(4.0);
    }

    public Object run(Selection<?> context, Object ... args) {
        this.drop((Selection)args[0], ObjectConverter.toBoolean((Object)args[1]));
        return null;
    }

    public void drop(final Selection<?> labels, final boolean removeOverlap) {
        if (!labels.isTransition()) {
            this.applyLabelDrop(labels, removeOverlap);
        } else {
            final ArrayEx steps = new ArrayEx((Object[])new Integer[]{0, 25, 75});
            final BundleLabelDropper self = this;
            ((Transition)labels).tween("__pointLabelDrop__", (ValueFunction)new ValueFunction<SceneNode, Tween<SceneNode>>(){

                public Tween<SceneNode> getValue(SceneNode node, Object data, int index, int groupIndex) {
                    if (index == 0) {
                        return new Tween<SceneNode>(){

                            public void tween(SceneNode _node, double t) {
                                double currentStep = Math.floor(t * 100.0);
                                if (steps.size() > 0 && currentStep < 100.0 && currentStep >= (double)((Integer)steps.get(0)).intValue()) {
                                    steps.remove(0);
                                    self.applyLabelDrop(labels, removeOverlap);
                                }
                            }
                        };
                    }
                    return null;
                }
            });
            this.labelCount = 0;
            ((Transition)labels).each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    ++self.labelCount;
                }
            }).each("end", (RunFunction)new RunFunction<SceneNode>(){

                public Object run(SceneNode context, Object ... args) {
                    if (--self.labelCount == 0) {
                        self.applyLabelDrop(labels, removeOverlap);
                    }
                    return null;
                }
            });
        }
    }

    private final void applyLabelDrop(Selection<?> labels, boolean removeOverlap) {
        if (removeOverlap) {
            labels.call((RunFunction)this._dropOverlap, new Object[0]);
        } else {
            this._dropOverlap.reset(labels);
        }
    }

    public final void configureForDataLabels(RectStruct rect) {
        if (rect != null) {
            Point[] ex = new Point[]{new Point(rect.x, rect.y), new Point(rect.x + rect.width, rect.y + rect.height)};
            this._dropOverlap.extent(ex);
        }
        this._dropOverlap.noClipping();
    }
}

