/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.utilities;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.Symbol;
import com.ibm.rave.library.property.CommonPropertyConstants;

public class BundleSymbolComponent
implements RunFunction<Selection<?>> {
    private String _symbolType = "circle";
    private double DEFAULT_STROKE_WIDTH = 0.0;
    private ValueFunction<Object, Object> _useFill = DEFAULT_FILL;
    private ValueFunction<Object, Object> _symbolSize = DEFAULT_SIZE;
    private ValueFunction<SceneNode, Object> _color = DEFAULT_COLOR;
    private double _strokeWidth = this.DEFAULT_STROKE_WIDTH;
    private final Symbol _symbolGenerator = this.buildSymbolGenerator();
    private final OMap<String, ValueFunction<Object, Object[]>> _symbolDataFunctionMap = this.buildSymbolDataMap();
    @InlineStringConstant
    private static final String SYMBOL_SHAPE_CLASS = "symbolShape";
    @InlineStringConstant
    private static final String SYMBOL_SHAPE_CLASS_SELECTOR = ".symbolShape";
    @InlineStringConstant
    private static final String DEFAULT_SYMBOL_DATA_KEY = "__default";
    private static final ValueFunction<Object, Object> DEFAULT_SIZE = new ValueFunction<Object, Object>(){

        @SwiftMethodOverload(skipParameters={1})
        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return 64;
        }
    };
    private static final ValueFunction<Object, Object> DEFAULT_FILL = new ValueFunction<Object, Object>(){

        @SwiftMethodOverload(skipParameters={1})
        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return true;
        }
    };
    private static final ValueFunction<SceneNode, Object> DEFAULT_COLOR = new ValueFunction<SceneNode, Object>(){

        @SwiftMethodOverload(skipParameters={1})
        public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
            return null;
        }
    };

    public BundleSymbolComponent() {
        if (!Rave.svg.symbolTypes.contains("donut-thin")) {
            Rave.svg.symbolCreator("donut-thin", CommonPropertyConstants.DONUT_THIN);
        }
    }

    public BundleSymbolComponent symbolType(String s) {
        this._symbolType = s;
        return this;
    }

    public BundleSymbolComponent size(ValueFunction<Object, Object> s) {
        this._symbolSize = s != null ? s : DEFAULT_SIZE;
        return this;
    }

    public BundleSymbolComponent strokeWidth(double w) {
        this._strokeWidth = w;
        return this;
    }

    public BundleSymbolComponent useFill(ValueFunction<Object, Object> f) {
        this._useFill = f;
        return this;
    }

    public BundleSymbolComponent color(ValueFunction<SceneNode, Object> v) {
        this._color = v;
        return this;
    }

    public Object run(Selection<?> context, Object ... args) {
        final BundleSymbolComponent self = this;
        final ValueFunction<Object, Object[]> symbolDataFunction = this.getSymbolDataFunction(this._symbolType);
        ValueFunction<SceneNode, Object> classes = new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                return "symbolShape symbol_" + index;
            }
        };
        ValueFunction<SceneNode, Object> stroke = new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                return ((BundleSymbolDatum)((Object)data)).fill();
            }
        };
        ValueFunction<SceneNode, Object> fill = new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                BundleSymbolDatum d = (BundleSymbolDatum)((Object)data);
                if (((Boolean)self._useFill.getValue((Object)context, d.data(), index, groupIndex)).booleanValue()) {
                    return ((BundleSymbolDatum)((Object)data)).fill();
                }
                return "rgba(0,0,0,0)";
            }
        };
        ValueFunction<SceneNode, Object> strokeWidth = new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                BundleSymbolDatum d = (BundleSymbolDatum)((Object)data);
                if (Math.abs(ObjectConverter.toDouble((Object)self._symbolSize.getValue((Object)context, d.data(), index, groupIndex))) < 70.0) {
                    return "1px";
                }
                return self._strokeWidth + "px";
            }
        };
        ValueFunction<SceneNode, Object> pointerEvents = new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                return ((BundleSymbolDatum)((Object)data)).pointerEvents();
            }
        };
        context.each((CallbackFunction)new CallbackFunction<SceneNode>((ValueFunction)classes, self, (ValueFunction)fill, (ValueFunction)stroke, (ValueFunction)strokeWidth, (ValueFunction)pointerEvents){
            final /* synthetic */ ValueFunction val$classes;
            final /* synthetic */ BundleSymbolComponent val$self;
            final /* synthetic */ ValueFunction val$fill;
            final /* synthetic */ ValueFunction val$stroke;
            final /* synthetic */ ValueFunction val$strokeWidth;
            final /* synthetic */ ValueFunction val$pointerEvents;
            {
                this.val$classes = valueFunction2;
                this.val$self = bundleSymbolComponent;
                this.val$fill = valueFunction3;
                this.val$stroke = valueFunction4;
                this.val$strokeWidth = valueFunction5;
                this.val$pointerEvents = valueFunction6;
            }

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                Selector symbolShapes = Rave.select((SceneNode)context).selectAll(BundleSymbolComponent.SYMBOL_SHAPE_CLASS_SELECTOR).data(symbolDataFunction);
                symbolShapes.enter().append("path").attr("class", this.val$classes).attr("d", (ValueFunction)this.val$self._symbolGenerator).style("fill", this.val$fill).style("stroke", this.val$stroke).style("stroke-width", this.val$strokeWidth).style("pointer-events", this.val$pointerEvents);
                symbolShapes.exit().remove();
                Rave.transition((Selection)symbolShapes.attr("d", (ValueFunction)this.val$self._symbolGenerator)).style("fill", this.val$fill).style("stroke", this.val$stroke).style("stroke-width", this.val$strokeWidth);
            }
        });
        return null;
    }

    private ValueFunction<Object, Object[]> getSymbolDataFunction(String symbolType) {
        ValueFunction f = (ValueFunction)this._symbolDataFunctionMap.get((Object)symbolType);
        if (f == null) {
            f = (ValueFunction)this._symbolDataFunctionMap.get((Object)DEFAULT_SYMBOL_DATA_KEY);
        }
        return f;
    }

    private Symbol buildSymbolGenerator() {
        final BundleSymbolComponent self = this;
        return Rave.svg.symbol().type((ValueFunction)new ValueFunction<Object, String>(){

            @SwiftMethodOverload(skipParameters={1})
            public String getValue(Object context, Object data, int index, int groupIndex) {
                return ObjectConverter.toString((Object)((BundleSymbolDatum)((Object)data)).type());
            }
        }).size((ValueFunction)new ValueFunction<Object, Number>(){

            @SwiftMethodOverload(skipParameters={1})
            public Number getValue(Object context, Object data, int index, int groupIndex) {
                BundleSymbolDatum d = (BundleSymbolDatum)((Object)data);
                return ObjectConverter.toDouble((Object)d.sizeRatio()) * Math.abs(ObjectConverter.toDouble((Object)self._symbolSize.getValue(context, d.data(), index, groupIndex)));
            }
        });
    }

    private OMap<String, ValueFunction<Object, Object[]>> buildSymbolDataMap() {
        final BundleSymbolComponent self = this;
        OMap map = new OMap();
        map.put((Object)DEFAULT_SYMBOL_DATA_KEY, (Object)new ValueFunction<Object, Object[]>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object[] getValue(Object context, Object data, int index, int groupIndex) {
                BundleSymbolDatum d = BundleSymbolDatum.create().data(data).type(self._symbolType).sizeRatio(1.0).fill(self._color.getValue(null, data, 0, 0));
                return new Object[]{d};
            }
        });
        map.put((Object)"donutPlus", (Object)new ValueFunction<Object, Object[]>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object[] getValue(Object context, Object data, int index, int groupIndex) {
                BundleSymbolDatum d = BundleSymbolDatum.create().data(data).type("circle").sizeRatio(1.0).fill(self._color.getValue(null, data, 0, 0));
                BundleSymbolDatum d2 = BundleSymbolDatum.create().data(data).type("donut-thin").sizeRatio(0.6).fill("white").pointerEvents("none");
                return new Object[]{d, d2};
            }
        });
        return map;
    }

    private static class BundleSymbolDatum
    extends OMap<String, Object> {
        private Object _data;
        public String _type;
        public Double _sizeRatio;
        public Object _fill;
        public String _pointerEvents;

        public static BundleSymbolDatum create() {
            return new BundleSymbolDatum();
        }

        private BundleSymbolDatum() {
        }

        public Object data() {
            return this._data;
        }

        public BundleSymbolDatum data(Object d) {
            this._data = d;
            return this;
        }

        public String type() {
            return this._type;
        }

        public BundleSymbolDatum type(String t) {
            this._type = t;
            return this;
        }

        public Double sizeRatio() {
            return this._sizeRatio;
        }

        public BundleSymbolDatum sizeRatio(Double d) {
            this._sizeRatio = d;
            return this;
        }

        public Object fill() {
            return this._fill;
        }

        public BundleSymbolDatum fill(Object f) {
            this._fill = f;
            return this;
        }

        public String pointerEvents() {
            return this._pointerEvents;
        }

        public BundleSymbolDatum pointerEvents(String p) {
            this._pointerEvents = p;
            return this;
        }
    }
}

