/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.utilities;

import com.ibm.rave.core.Rave;
import com.ibm.rave.core.color.HSL;
import com.ibm.rave.core.color.RGB;

public class ColorUtil {
    public static Object getContrastColor(Object bg, Object fg) {
        double contrastRatio = ColorUtil.getContrastRatio(bg, fg);
        if (contrastRatio < 4.5) {
            HSL bgHSL = Rave.hsl((Object)bg);
            HSL fgHSL = Rave.hsl((Object)fg);
            double brightness = 0.33 * (double)((float)Rave.rgb((Object)bg).getR() / 255.0f) + 0.5 * (double)((float)Rave.rgb((Object)bg).getG() / 255.0f) + 0.16 * (double)((float)Rave.rgb((Object)bg).getB() / 255.0f);
            if (brightness > 0.5) {
                if (bgHSL.getL() > 0.5) {
                    return Rave.hsl((double)fgHSL.getH(), (double)fgHSL.getS(), (double)Math.min(fgHSL.getL(), bgHSL.getL() - 0.4));
                }
                return Rave.hsl((double)fgHSL.getH(), (double)fgHSL.getS(), (double)Math.min(fgHSL.getL(), 0.1));
            }
            if (bgHSL.getL() < 0.5) {
                return Rave.hsl((double)fgHSL.getH(), (double)fgHSL.getS(), (double)Math.max(fgHSL.getL(), bgHSL.getL() + 0.4));
            }
            return Rave.hsl((double)fgHSL.getH(), (double)fgHSL.getS(), (double)Math.max(fgHSL.getL(), 0.9));
        }
        return fg;
    }

    public static Object getContrastColor(Object labelColor) {
        RGB labelRGB = Rave.rgb((Object)labelColor);
        return labelRGB.contrastShift(21.0);
    }

    public static double getContrastRatio(Object colorA, Object colorB) {
        double backgroundLuminance;
        double foregroundLuminance = Rave.rgb((Object)colorA).getLuminance();
        double contrastRatio = foregroundLuminance >= (backgroundLuminance = Rave.rgb((Object)colorB).getLuminance()) ? (foregroundLuminance + 0.05) / (backgroundLuminance + 0.05) : (backgroundLuminance + 0.05) / (foregroundLuminance + 0.05);
        return contrastRatio;
    }
}

