/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.utilities;

import com.ibm.rave.bundles.components.FilterComponentImpl;
import com.ibm.rave.bundles.utilities.ColorUtil;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.ValueFunction;

public class LabelStyleUtil
implements RunFunction<Selection<?>> {
    private OMap<String, Object> _labelFontStyle = null;
    private FilterComponentImpl _contrastLabelColorfilter;
    private FilterComponentImpl _sameLabelColorfilter;
    private ValueFunction<SceneNode, String> _labelFillColor = null;
    private ValueFunction<SceneNode, String> _labelFontSize = null;
    private boolean _labelShadow = false;

    public Object run(Selection<?> context, Object ... args) {
        Selection<?> labels;
        if (this._labelFontStyle != null) {
            for (String stylenName : this._labelFontStyle.keySet()) {
                if (stylenName.equals("fill") || stylenName.equals("color") && this._labelFillColor != null || stylenName.equals("font-size") && this._labelFontSize != null || stylenName.equals("text-shadow") && this._labelShadow) continue;
                context.style(stylenName, this._labelFontStyle.get((Object)stylenName));
            }
        }
        if (this._labelFillColor != null) {
            context.style("fill", this._labelFillColor);
        }
        if (this._labelFontSize != null) {
            context.style("font-size", this._labelFontSize);
        }
        if ((labels = context.selectAll("*")).size() == 0) {
            labels = context;
        }
        if (this._labelShadow) {
            final LabelStyleUtil self = this;
            final String defaultLabelFill = this.getDefaultLabelColor(this._labelFontStyle);
            this._contrastLabelColorfilter = new FilterComponentImpl("contrast_label_drop_shadow");
            this._contrastLabelColorfilter.setDropshadow("1px", "1px", "0px", Rave.rgb((Object)ColorUtil.getContrastColor(defaultLabelFill)));
            this._sameLabelColorfilter = new FilterComponentImpl("same_label_drop_shadow");
            this._sameLabelColorfilter.setDropshadow("1px", "1px", "0px", Rave.rgb((Object)defaultLabelFill));
            SceneNode owner = context.node().getOwner();
            Rave.select((SceneNode)owner).select((Object)"defs").call((RunFunction)this._contrastLabelColorfilter, new Object[0]);
            Rave.select((SceneNode)owner).select((Object)"defs").call((RunFunction)this._sameLabelColorfilter, new Object[0]);
            context.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context1, Object data, int index, int groupIndex) {
                    if (self._labelFillColor != null) {
                        double contrastRatio = ColorUtil.getContrastRatio(Rave.rgb((Object)self._labelFillColor.getValue((Object)context1, data, index, groupIndex)), defaultLabelFill);
                        if (contrastRatio < 4.5) {
                            context1.setAttribute("filter", (Object)("url(#" + self._contrastLabelColorfilter.getId() + ")"));
                        } else {
                            context1.setAttribute("filter", (Object)("url(#" + self._sameLabelColorfilter.getId() + ")"));
                        }
                    } else {
                        context1.setAttribute("filter", (Object)("url(#" + self._contrastLabelColorfilter.getId() + ")"));
                    }
                }
            });
            labels.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context1, Object data, int index, int groupIndex) {
                    if (self._labelFillColor != null) {
                        context1.setProperty("_rave_drop_shadow", (Object)("1px 1px 0px " + ColorUtil.getContrastColor(self._labelFillColor.getValue((Object)context1, data, index, groupIndex)).toString()));
                    } else {
                        context1.setProperty("_rave_drop_shadow", (Object)("1px 1px 0px " + ColorUtil.getContrastColor(defaultLabelFill).toString()));
                    }
                }
            });
        } else {
            labels.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context1, Object data, int index, int groupIndex) {
                    context1.setProperty("_rave_drop_shadow", null);
                }
            });
            context.attr("filter", null);
        }
        return null;
    }

    public LabelStyleUtil labelFont(OMap<String, Object> labelFontStyle) {
        this._labelFontStyle = labelFontStyle;
        return this;
    }

    public LabelStyleUtil labelFillColor(ValueFunction<SceneNode, String> _labelFillColor) {
        this._labelFillColor = _labelFillColor;
        return this;
    }

    public LabelStyleUtil labelFontSize(ValueFunction<SceneNode, String> _labelFontSize) {
        this._labelFontSize = _labelFontSize;
        return this;
    }

    public LabelStyleUtil labelShadow(boolean labelShadow) {
        this._labelShadow = labelShadow;
        return this;
    }

    public String getDefaultLabelColor(OMap<String, Object> _labelStyle) {
        if (_labelStyle == null) {
            return "#000000";
        }
        Object defaultFillColor = null;
        if (_labelStyle != null && (defaultFillColor = _labelStyle.get((Object)"fill")) == null) {
            defaultFillColor = _labelStyle.get((Object)"color");
        }
        if (defaultFillColor == null) {
            defaultFillColor = "#000000";
        }
        return defaultFillColor.toString();
    }
}

