/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.utilities;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.interpolate.Interpolator;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.core.transition.TransitionInterpolatorFactory;
import java.util.List;

public class PathUtils {
    @InlineStringConstant
    private static final String OPACITY = "opacity";
    @InlineStringConstant
    private static final String ORIGINAL_OPACITY = "__rave_originalOpacity__";
    @InlineStringConstant
    private static final String PATH_DATA = "d";
    @InlineStringConstant
    private static final String EASE_LINEAR = "linear";

    public static void fadeOutIn(Selection<?> selection, final ValueFunction<Object, String> pathFunction) {
        if (selection.isTransition()) {
            Transition transition = (Transition)selection;
            transition.ease(EASE_LINEAR, new Object[0]).styleTween(OPACITY, (TransitionInterpolatorFactory)new TransitionInterpolatorFactory<SceneNode>(){

                public Interpolator<?> create(SceneNode context, Object data, int index, Object value) {
                    Object styleOpacity;
                    final Selector path = Rave.select((SceneNode)context);
                    if (!context.hasProperty(PathUtils.ORIGINAL_OPACITY)) {
                        context.setProperty(PathUtils.ORIGINAL_OPACITY, path.style(PathUtils.OPACITY));
                    }
                    Double opacity = (styleOpacity = context.getProperty(PathUtils.ORIGINAL_OPACITY)) != null ? Lang.parseNumber((String)ObjectConverter.toString((Object)styleOpacity)) : 1.0;
                    double mid1 = 0.45;
                    double mid2 = 0.55;
                    final LinearScale s = Rave.scale.linear().domain((List)new ArrayEx(new Object[]{0.0, 0.45, 0.55, 1.0})).range((List)new ArrayEx(new Object[]{opacity, 0.0, 0.0, opacity}));
                    final boolean[] setPath = new boolean[]{false};
                    return new Interpolator<Double>(){

                        public Double interpolate(double t) {
                            if (t > 0.45 && !setPath[0]) {
                                path.attr(PathUtils.PATH_DATA, pathFunction);
                                setPath[0] = true;
                            }
                            return ObjectConverter.toDouble((Object)s.getValue(null, (Object)t, 0, 0));
                        }
                    };
                }
            });
            transition.each("end", (RunFunction)new RunFunction<SceneNode>(){

                public Object run(SceneNode context, Object ... args) {
                    context.removeProperty(PathUtils.ORIGINAL_OPACITY);
                    return null;
                }
            });
        } else {
            selection.attr(PATH_DATA, pathFunction);
        }
    }
}

