/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.utilities;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.core.transition.Tween;

public class TextCrossfader {
    public static Selection<?> textCrossFade(Selection<?> selection, final String oldText, final String newText, final Object fillOpacity, double delay) {
        if (!selection.isTransition()) {
            return selection.text((Object)newText);
        }
        Transition _t = ((Transition)selection).tween("text", (ValueFunction)new ValueFunction<SceneNode, Tween<SceneNode>>(){

            @SwiftMethodOverload(skipParameters={1})
            public Tween<SceneNode> getValue(SceneNode context, Object data, int index, int groupIndex) {
                return new Tween<SceneNode>(){

                    public void tween(SceneNode node, double t) {
                        node.setText(t < 0.5 ? oldText : newText);
                    }
                };
            }
        });
        final double t0 = Math.max(0.0, Math.min(0.5, delay));
        if (t0 == 0.5 || oldText == null && newText == null || oldText != null && oldText.equals(newText)) {
            return selection;
        }
        final double opacity = fillOpacity == null ? 1.0 : ObjectConverter.toDouble((Object)fillOpacity);
        final double tf = 1.0 / (0.5 - t0);
        return _t.tween("fill-opacity", (ValueFunction)new ValueFunction<SceneNode, Tween<SceneNode>>(){

            @SwiftMethodOverload(skipParameters={1})
            public Tween<SceneNode> getValue(SceneNode context, Object data, int index, int groupIndex) {
                return new Tween<SceneNode>(){

                    public void tween(SceneNode context, double t) {
                        if (t <= t0 || t >= 1.0 - t0) {
                            context.setStyle("fill-opacity", fillOpacity);
                        } else {
                            context.setStyle("fill-opacity", (Object)(opacity * Math.abs(t - 0.5) * tf));
                        }
                    }
                };
            }
        });
    }
}

