/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.views;

import com.ibm.rave.bundles.components.IntervalComponentImpl;
import com.ibm.rave.bundles.components.IntervalDataUtilities;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.datamodel.DataModel;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlot;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.internal.BundleContext;

public abstract class AbstractColumnView
extends BundleView {
    @InlineStringConstant
    protected static final String DATAMODEL_TABULAR = "tabular";
    @InlineStringConstant
    protected static final String DATASET_DATA = "data";
    @InlineStringConstant
    protected static final String DATASLOT_X = "x";
    @InlineStringConstant
    protected static final String DATASLOT_Y = "y";
    @InlineStringConstant
    protected static final String DATASLOT_Y_START = "yStart";
    @InlineStringConstant
    protected static final String DATASLOT_COLOR = "color";
    @InlineStringConstant
    protected static final String DATASLOT_LABEL = "label";
    protected String datasetId = "data";
    protected IntervalComponentImpl _intervalComponent;

    protected AbstractColumnView(BundleContext context) {
        super(context);
    }

    @Override
    public void setup() {
        super.setup();
        this._intervalComponent = new IntervalComponentImpl();
        this._intervalComponent.keyAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).key;
            }
        }).independent1Accessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).ind1;
            }
        }).independent2Accessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).ind2;
            }
        }).dependent1Accessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).dep1;
            }
        }).dependent2Accessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).dep2;
            }
        }).valueAccessor(IntervalDataUtilities.VALUE_ACCESSOR);
    }

    @Override
    protected boolean dataValid() {
        DataSlotEntry yStartAccessor;
        if (!this.dataModel.validate()) {
            return false;
        }
        String dataHandling = this.getStringProperty("data.handling");
        DataSet dataSet = this.dataModel.dataset(this.datasetId);
        DataSlotEntry yAccessor = dataSet.slot(DATASLOT_Y).entry();
        DataSlot yStart = dataSet.slot(DATASLOT_Y_START);
        DataSlotEntry dataSlotEntry = yStartAccessor = yStart != null ? yStart.entry() : null;
        if ((dataHandling.equals("Stacked") || dataHandling.equals("Stacked100")) && (yStartAccessor != null || yAccessor.type().equals("date"))) {
            Library.logError((int)408, (String)"Column chart isn't stackable when ystart is defined or y is date");
            return false;
        }
        if (yStartAccessor != null && !yStartAccessor.type().equals(yAccessor.type())) {
            Library.logError((int)409, (String)"y and ystart slot must have the same data type in Column data");
            return false;
        }
        return true;
    }

    protected ArrayEx<IntervalDataUtilities.IntervalData> makeData(DataModel dataModel, ArrayEx<Object> _data) {
        if (_data == null || _data.size() == 0) {
            return new ArrayEx();
        }
        DataSet dataSet = dataModel.dataset(this.datasetId);
        DataSlotEntry xAccessor = dataSet.slot(DATASLOT_X).entry();
        DataSlotEntry yAccessor = dataSet.slot(DATASLOT_Y).entry();
        DataSlotEntry colorAccessor = dataSet.slot(DATASLOT_COLOR).entry();
        DataSlotEntry labelAccessor = dataSet.slot(DATASLOT_LABEL).entry();
        DataSlot yStart = dataSet.slot(DATASLOT_Y_START);
        DataSlotEntry yStartAccessor = yStart != null ? yStart.entry() : null;
        String dataHandling = this.getStringProperty("data.handling");
        if ("Clustered".equals(dataHandling) && colorAccessor != null) {
            return IntervalDataUtilities.clusteredBars(_data, (ArrayEx<SingleValueFunction<Object, Object>>)new ArrayEx((Object[])new SingleValueFunction[]{xAccessor, colorAccessor}), (ArrayEx<SingleValueFunction<Object, Object>>)new ArrayEx((Object[])new SingleValueFunction[]{AbstractColumnView.domainCheckerOf(_data, (DataSlotEntry)xAccessor), AbstractColumnView.domainCheckerOf(_data, (DataSlotEntry)colorAccessor)}), (SingleValueFunction<Object, Object>)yAccessor, (SingleValueFunction<Object, Object>)yStartAccessor, (SingleValueFunction<Object, Object>)colorAccessor, (SingleValueFunction<Object, Object>)labelAccessor);
        }
        if ("Stacked".equals(dataHandling)) {
            return IntervalDataUtilities.stackedBars(_data, (SingleValueFunction<Object, Object>)xAccessor, (SingleValueFunction<Object, Object>)AbstractColumnView.domainCheckerOf(_data, (DataSlotEntry)xAccessor), (SingleValueFunction<Object, Object>)yAccessor, (SingleValueFunction<Object, Object>)colorAccessor, (SingleValueFunction<Object, Object>)labelAccessor, false);
        }
        if ("Stacked100".equals(dataHandling)) {
            return IntervalDataUtilities.stackedBars(_data, (SingleValueFunction<Object, Object>)xAccessor, (SingleValueFunction<Object, Object>)AbstractColumnView.domainCheckerOf(_data, (DataSlotEntry)xAccessor), (SingleValueFunction<Object, Object>)yAccessor, (SingleValueFunction<Object, Object>)colorAccessor, (SingleValueFunction<Object, Object>)labelAccessor, true);
        }
        return IntervalDataUtilities.simpleBars(_data, (SingleValueFunction<Object, Object>)xAccessor, (SingleValueFunction<Object, Object>)AbstractColumnView.domainCheckerOf(_data, (DataSlotEntry)xAccessor), (SingleValueFunction<Object, Object>)yAccessor, (SingleValueFunction<Object, Object>)yStartAccessor, (SingleValueFunction<Object, Object>)colorAccessor, (SingleValueFunction<Object, Object>)labelAccessor);
    }

    protected void configureDataLabels(DataSet dataSet, DataSlotEntry colorDataSlotEntry) {
        if (!this.isShowDataLabels()) {
            this._intervalComponent.itemLabel(false);
            this._intervalComponent.itemLabelPosition(null);
            this._intervalComponent.labelFont(null);
            this._intervalComponent.labelAccessor(null);
            this._intervalComponent.labelFormatter(null);
            return;
        }
        String dataHandling = this.getStringProperty("data.handling");
        final boolean isStacked = colorDataSlotEntry != null && ("Stacked".equals(dataHandling) || "Stacked100".equals(dataHandling));
        ValueFunction<Object, Integer> dataLabelPosition = new ValueFunction<Object, Integer>(){

            public Integer getValue(Object context, Object data, int index, int groupIndex) {
                if (isStacked) {
                    return 1;
                }
                IntervalDataUtilities.IntervalData iData = (IntervalDataUtilities.IntervalData)data;
                double value = ObjectConverter.toDouble((Object)iData.value);
                return value >= 0.0 ? 0 : 2;
            }
        };
        SingleValueFunction<Object, Object> labelAccessor = this.getlDataLabelAccessor(dataSet, DATASLOT_LABEL, true);
        DataSlotEntry labelEntry = this.getEntryForDataLabelFormatter(dataSet, DATASLOT_LABEL, DATASLOT_Y);
        this._intervalComponent.itemLabel(true);
        this._intervalComponent.itemOverlap(true);
        this._intervalComponent.itemLabelPosition(dataLabelPosition);
        OMap<String, Object> labelFontStyle = FontPropertyParser.parseCSSFont(this.getStringProperty("labelstyle.font"));
        if (!isStacked) {
            labelFontStyle = this.getBackgroundConstrastLabelStyle();
        }
        this._intervalComponent.labelFont(labelFontStyle);
        this._intervalComponent.labelAccessor(labelAccessor);
        this._intervalComponent.labelContrast(this.getBooleanProperty("contrast.label.color"));
        this._intervalComponent.labelFormatter((ValueFunction<Object, String>)this.context.getCustomFormatterForElementLabels(labelEntry, dataSet.slot(DATASLOT_LABEL).entry() != null ? "ROLE_NONE" : "ROLE_Y1"));
        this._intervalComponent.labelContrast(this.getBooleanProperty("contrast.label.color"));
        this._intervalComponent.labelShadow(this.getBooleanProperty("label.shadow"));
    }
}

