/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.views;

import com.ibm.rave.bundles.components.AxesManager;
import com.ibm.rave.bundles.components.BackgroundComponentImpl;
import com.ibm.rave.bundles.components.ChartLayoutComponentImpl;
import com.ibm.rave.bundles.components.ClipPathComponentImpl;
import com.ibm.rave.bundles.components.IntervalDataUtilities;
import com.ibm.rave.bundles.components.LegendsManager;
import com.ibm.rave.bundles.data.PointDataUtilities;
import com.ibm.rave.bundles.utilities.ColorUtil;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.datamodel.DataModel;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.internal.AbstractView;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CSSConverter;
import com.ibm.rave.library.palette.Palette;

public abstract class BundleView
extends AbstractView {
    protected BackgroundComponentImpl _backgroundComponent = null;
    protected ChartLayoutComponentImpl _layoutComponent = null;
    protected ClipPathComponentImpl _clip = null;
    protected AxesManager _axes = null;
    protected LegendsManager _legends = null;
    private String[] _groupStructure = null;
    protected Selector _chart = null;
    protected DataModel dataModel = null;
    protected double[] _zoomP = null;
    protected double[] _zoomS = null;

    protected BundleView(BundleContext context) {
        super(context);
    }

    protected abstract String[] getGroupStructure();

    public void setup() {
        super.setup();
        this._backgroundComponent = new BackgroundComponentImpl();
        this._layoutComponent = new ChartLayoutComponentImpl();
        this._clip = new ClipPathComponentImpl(this.context.instanceId() + "clipViewport");
        if (this.isZoomSupported()) {
            this.resetZoom();
        }
        this._legends = new LegendsManager(this.context, this.getLegendCount());
        if (this.isAxesManagerRequired()) {
            this._axes = new AxesManager(this.context);
        }
        this._groupStructure = this.getGroupStructure();
    }

    protected final void preDraw(String chartId) {
        this.cancelTransitions();
        BundleView.createGroupStructure((Selector)this.context.node, (String[])this._groupStructure);
        this._chart = this.context.node.selectAll(chartId);
    }

    protected void resetZoom() {
        this._zoomP = new double[]{0.0, 0.0, 0.0, 0.0};
        this._zoomS = new double[]{1.0, 1.0, 1.0, 1.0};
    }

    protected final boolean validateDataModel(String ... elementsToRemove) {
        this.dataModel = this.context.dataModel();
        if (!this.dataValid()) {
            for (String e : elementsToRemove) {
                this._chart.selectAll(e).selectAll("*").remove();
            }
            this._legends.visible(false).draw();
            return false;
        }
        return true;
    }

    protected boolean dataValid() {
        return this.dataModel.validate();
    }

    protected int getLegendCount() {
        return 1;
    }

    protected boolean isAxesManagerRequired() {
        return false;
    }

    protected boolean isZoomSupported() {
        return true;
    }

    protected final Object getProperty(String s) {
        return this.context.getPropertyValue(s);
    }

    protected final Object getPropertyDefault(String s) {
        return this.context.getPropertyDefault(s);
    }

    protected final boolean getBooleanProperty(String s) {
        Object obj = this.getProperty(s);
        return ObjectConverter.toBoolean((Object)obj);
    }

    protected final double getDoubleProperty(String s) {
        Object obj = this.getProperty(s);
        return ObjectConverter.toDouble((Object)obj);
    }

    protected final int getIntProperty(String s) {
        Object obj = this.getProperty(s);
        return ObjectConverter.toInt((Object)obj);
    }

    protected final String getStringProperty(String id) {
        Object obj = this.getProperty(id);
        return obj == null ? null : ObjectConverter.toString((Object)obj);
    }

    protected final String getStringPropertyEmptyAsNull(String id) {
        String s = this.getStringProperty(id);
        return s == null || s.length() == 0 ? null : s;
    }

    protected final Double getCSSSizeToPixelNumber(String id) {
        Double cssSize = CSSConverter.convertCSSSizeToPixelNumber((Object)this.context.getPropertyValue(id), (double)100.0, (double)10.0);
        return cssSize == null ? 0.0 : cssSize;
    }

    protected final int getEffectDuration(String effect) {
        int duration = this.getIntProperty("effect.duration");
        if (duration < 0 || effect == null || "none".equals(effect)) {
            duration = 0;
        }
        return duration;
    }

    protected final Object getTopPadding() {
        return this.getProperty("layout.chart.padding.top");
    }

    protected final Object getLeftPadding() {
        return this.getProperty("layout.chart.padding.left");
    }

    protected final Object getBottomPadding() {
        return this.getProperty("layout.chart.padding.bottom");
    }

    protected final Object getRightPadding() {
        return this.getProperty("layout.chart.padding.right");
    }

    protected final Object getLayoutPadding() {
        return this.getProperty("layout.padding");
    }

    protected final Object getLegendChartGap() {
        return this.getProperty("layout.legendchart.gap");
    }

    protected final Boolean getLegendChartAlign() {
        return this.getBooleanProperty("layout.legendchart.align");
    }

    protected final String getLegendPosition() {
        return this.getStringProperty("legend.position");
    }

    protected Palette getPalette() {
        return this.getPalette("color.palette");
    }

    protected Palette getPalette(String paletteID) {
        String id = this.getStringProperty(paletteID);
        Palette colorPalette = Library.palettes.getPalette(id);
        return colorPalette == null ? Library.palettes.getDefaultPalette() : colorPalette;
    }

    protected Palette getDynamicPalette() {
        return this.getDynamicPalette("color.palette", "color.dynamicPalette.min", "color.dynamicPalette.mid", "color.dynamicPalette.max");
    }

    protected Palette getDynamicPalette(String paletteID, String minId, String midId, String maxId) {
        String max;
        String mid;
        Palette colorPalette = null;
        String min = this.getStringProperty(minId);
        if (min != null && (mid = this.getStringProperty(midId)) != null && (max = this.getStringProperty(maxId)) != null) {
            ArrayEx fills = new ArrayEx((Object[])new String[]{min, mid, max});
            colorPalette = BundleView.getFillPalette((ArrayEx)fills);
        }
        return colorPalette == null ? this.getPalette(paletteID) : colorPalette;
    }

    protected void prepareLayoutComponent() {
        ((ChartLayoutComponentImpl)this._layoutComponent.setPreExecute(this.context.getPreExecute())).overall(new RectStruct(0.0, 0.0, this.context.size.w, this.context.size.h)).legendPosition(this.getLegendPosition()).padding(this.getLayoutPadding()).chartPadding(this.getTopPadding(), this.getLeftPadding(), this.getBottomPadding(), this.getRightPadding()).legendChartGap(this.getLegendChartGap()).legendChartAlign(this.getLegendChartAlign());
    }

    protected void prepareLayoutSizables(ChartLayoutComponentImpl layoutComponent, boolean useX2, boolean useY1, boolean useX1, boolean useY2, boolean useLegend) {
        layoutComponent.removeAxisSizables();
        if (useX1) {
            layoutComponent.addAxisSizable(this._axes.axisComponent(0));
        }
        if (useY1) {
            layoutComponent.addAxisSizable(this._axes.axisComponent(2));
        }
        if (useX2) {
            layoutComponent.addAxisSizable(this._axes.axisComponent(1));
        }
        if (useY2) {
            layoutComponent.addAxisSizable(this._axes.axisComponent(3));
        }
        layoutComponent.legendSize(useLegend ? this._legends : null);
    }

    protected final void resetUpdate() {
        this.updateType = 4;
    }

    protected final boolean isUpdateNothing() {
        return this.updateType == 4;
    }

    protected final boolean isShowLegend() {
        return this.getBooleanProperty("legend.display");
    }

    private final void cancelTransitions() {
        this.context.node.selectAll("*").interrupt();
    }

    protected final void setBackgroundProperties(RectStruct elementRect, int duration) {
        ((BackgroundComponentImpl)this._backgroundComponent.setPreExecute(this.context.getPreExecute())).size(this.context.size).backgroundColor(this.getStringProperty("background.chart.color"));
        this.context.node.selectAll("rect.background.chart").transition().duration((Object)duration).call((RunFunction)this._backgroundComponent, new Object[0]);
        ((BackgroundComponentImpl)this._backgroundComponent.setPreExecute(this.context.getPreExecute())).rect(elementRect).backgroundColor(this.getStringProperty("background.elements.color"));
        this.context.node.selectAll("rect.background.elements").transition().duration((Object)duration).call((RunFunction)this._backgroundComponent, new Object[0]);
    }

    protected final boolean isShowDataLabels() {
        return this.getBooleanProperty("data.label.display");
    }

    protected final boolean isShowDataLabelsAsPercentageOfColor() {
        String dataLabel = this.getStringProperty("data.label.type");
        return "PercentOfColor".equals(dataLabel);
    }

    protected final boolean isShowDataLabelsAsPercentageOfCategory() {
        String dataLabel = this.getStringProperty("data.label.type");
        return "PercentOfCategory".equals(dataLabel);
    }

    protected SingleValueFunction<Object, Object> getlDataLabelAccessor(DataSet dataSet, String slot, boolean isInterval) {
        DataSlotEntry labelEntry = dataSet.slot(slot).entry();
        SingleValueFunction<Object, Object> labelAccessor = labelEntry == null ? (this.isShowDataLabelsAsPercentageOfCategory() ? (isInterval ? IntervalDataUtilities.PERCENT_OF_CATEGORY_ACCESSOR : PointDataUtilities.PERCENT_OF_CATEGORY_ACCESSOR) : (this.isShowDataLabelsAsPercentageOfColor() ? (isInterval ? IntervalDataUtilities.PERCENT_OF_COLOR_ACCESSOR : PointDataUtilities.PERCENT_OF_COLOR_ACCESSOR) : (isInterval ? IntervalDataUtilities.VALUE_ACCESSOR : PointDataUtilities.Y_ACCESSOR))) : BundleView.originalDatumAccessor((SingleValueFunction)BundleView.accessorOf((DataSlotEntry)labelEntry));
        return labelAccessor;
    }

    protected DataSlotEntry getEntryForDataLabelFormatter(DataSet dataSet, String labelSlot, String defaultSlot) {
        DataSlotEntry labelEntry = dataSet.slot(labelSlot).entry();
        return labelEntry != null ? labelEntry : dataSet.slot(defaultSlot).entry();
    }

    protected OMap<String, Object> getBackgroundConstrastLabelStyle() {
        OMap labelFontStyle = FontPropertyParser.parseCSSFont(this.getStringProperty("labelstyle.font"));
        if (!this.getBooleanProperty("contrast.label.color")) {
            return labelFontStyle;
        }
        Object defaultFillColor = null;
        if (labelFontStyle != null) {
            defaultFillColor = labelFontStyle.get((Object)"fill");
            if (defaultFillColor == null) {
                defaultFillColor = labelFontStyle.get((Object)"color");
            }
        } else {
            labelFontStyle = new OMap();
        }
        if (defaultFillColor == null) {
            defaultFillColor = "#000000";
        }
        labelFontStyle.put((Object)"fill", ColorUtil.getContrastColor(this.getStringProperty("background.elements.color"), defaultFillColor));
        return labelFontStyle;
    }
}

