/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.waterfallBundle;

import com.ibm.rave.bundles.components.BackgroundComponentImpl;
import com.ibm.rave.bundles.components.ComponentConfiguration;
import com.ibm.rave.bundles.components.WaterfallComponentImpl;
import com.ibm.rave.bundles.data.WaterfallDatum;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.EventQueue;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.OrdinalScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Runnable;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.OperationsUtil;
import com.ibm.rave.library.datamodel.DataModel;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.LinearCoordinateScale;
import com.ibm.rave.library.framework.internal.OrdinalCoordinateScale;
import com.ibm.rave.library.framework.internal.OrdinalCoordinateScaleDatum;
import java.util.List;

public class WaterfallView
extends BundleView {
    private WaterfallComponentImpl _waterfallComponent;
    private boolean _drawBarAtZero;
    private String _firstPositiveColor;
    private String _firstNegativeColor;
    private String _valuePositiveColor;
    private String _valueNegativeColor;
    private String _totalPositiveColor;
    private String _totalNegativeColor;
    private final String DEFAULT_BAR_POSITIVE_COLOR = "#8cd211";
    private final String DEFAULT_BAR_NEGATIVE_COLOR = "#ff5003";
    private final String DEFAULT_BAR_TOTAL_COLOR = "#4178be";
    private final String DEFAULT_TOTAL_LABEL = "Sum";
    private final String DEFAULT_POSITIVE_TOTAL_LABEL = "Positive Sum";
    private final String DEFAULT_NEGATIVE_TOTAL_LABEL = "Negative Sum";
    private final String DEFAULT_POSITIVE_LABEL = "Increase";
    private final String DEFAULT_NEGATIVE_LABEL = "Decrease";
    private final String DEFAULT_FIRST_LABEL = "First Value";
    private final double DEFAULT_ELEMENTS_TRANSITION_DURATION = 0.8;
    private final double DEFAULT_NONELEMENTS_TRANSITION_DURATION = 0.2;
    private ArrayEx<WaterfallDatum> dataSet;
    private ArrayEx<WaterfallLineData> linesData;
    private RectStruct chartRect;
    private CoordinateScaleImpl _independentScale;
    private CoordinateScaleImpl _dependentScale;
    private Object zoomendedTimer;
    private AbstractScale<?, ?> zoomXScale;
    private AbstractScale<?, ?> zoomYScale;

    protected WaterfallView(BundleContext context) {
        super(context);
        this._backgroundComponent = null;
        this._waterfallComponent = null;
        this._drawBarAtZero = false;
        this._firstPositiveColor = null;
        this._firstNegativeColor = null;
        this._valuePositiveColor = null;
        this._valueNegativeColor = null;
        this._totalPositiveColor = null;
        this._totalNegativeColor = null;
    }

    @Override
    protected boolean isAxesManagerRequired() {
        return true;
    }

    @Override
    public void setup() {
        super.setup();
        this._backgroundComponent = new BackgroundComponentImpl();
        this._waterfallComponent = new WaterfallComponentImpl();
        this._waterfallComponent.categoryAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WaterfallDatum)data).category();
            }
        }).valueAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WaterfallDatum)data).value();
            }
        }).baseAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WaterfallDatum)data).base();
            }
        }).heightAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WaterfallDatum)data).height();
            }
        }).colorAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WaterfallDatum)data).getColor();
            }
        }).idAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WaterfallDatum)data).id();
            }
        }).lineHeightAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WaterfallDatum)data).getConnectingLineHeight();
            }
        }).lineId1Accessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WaterfallLineData)data).id1;
            }
        }).lineId2Accessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WaterfallLineData)data).id2;
            }
        }).lineYAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WaterfallLineData)data).y;
            }
        }).lineColorAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WaterfallLineData)data).color;
            }
        });
        OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)"0px");
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart rect.element-shape", (OMap)style);
        this.context.actions.action("select").setOperation(OperationsUtil.select());
        this.context.actions.action("deselect").setOperation(OperationsUtil.deselect());
    }

    public void draw() {
        CoordinateScaleImpl yScale;
        CoordinateScaleImpl xScale;
        boolean legendVisibilityChanged;
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-waterfall");
        if (!this.validateDataModel("g.element-group", "g.grid", "g.axis")) {
            return;
        }
        this.setBorder("border.width", "border.color");
        ValueFunction fmt = this.context.getCustomFormatterWithFlag(new String[]{"legend", "all"}, BundleContext.makeCustomFormatInfo((String)"legend-label", (String)"ROLE_NONE", (String)"percent", null), null, false);
        String effect = this.getStringProperty("effect.name");
        int duration = this.getIntProperty("effect.duration");
        if (duration < 0 || effect == null || "none".equals(effect)) {
            duration = 0;
        }
        boolean transpose = this.getBooleanProperty("transpose");
        if (this.updateType == 0) {
            this.dataSet = this.makeData(this.dataModel);
            if (this.dataSet.size() == 0) {
                this._chart.remove();
                return;
            }
            this.linesData = this.makeConnectingLinesData(this.dataSet);
            this.dataSet = this.updateData(this.dataSet, this.linesData);
        }
        double elementDuration = ObjectConverter.toDouble((double)((double)duration * 0.8 / (double)(this.dataSet.size() + this.linesData.size())));
        double nonElementDuration = ObjectConverter.toDouble((double)((double)duration * 0.2));
        this._firstPositiveColor = ObjectConverter.asString((Object)this.context.getPropertyValue("firstBarPositive.color"));
        this._firstNegativeColor = ObjectConverter.asString((Object)this.context.getPropertyValue("firstBarNegative.color"));
        this._valuePositiveColor = ObjectConverter.asString((Object)this.context.getPropertyValue("valueBarPositive.color"));
        this._valueNegativeColor = ObjectConverter.asString((Object)this.context.getPropertyValue("valueBarNegative.color"));
        this._totalPositiveColor = ObjectConverter.asString((Object)this.context.getPropertyValue("totalBarPositive.color"));
        this._totalNegativeColor = ObjectConverter.asString((Object)this.context.getPropertyValue("totalBarNegative.color"));
        WaterfallColorScale waterfallScale = this.makeColorScale(this.dataSet);
        ArrayEx<Object> domain = waterfallScale.labels;
        OrdinalScale waterfallColorScale = Rave.scale.ordinal().domain(domain).range(waterfallScale.colors);
        boolean showLegend = this.isShowLegend();
        String legendPosition = this.getLegendPosition();
        boolean bl = legendVisibilityChanged = this._legends.anyVisible() != showLegend;
        if (legendVisibilityChanged) {
            this.updateType = 1;
        }
        this._legends.visible(showLegend).position(legendPosition).transition(false, 0).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).scale(0, (AbstractScale<?, ?>)waterfallColorScale).shape(0, "square").title(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.title"))).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).swatchSize(0, new ValueFunction<Object, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return 400;
            }
        }).formatterList(0, null, null, (ValueFunction<Object, String>)fmt);
        final WaterfallView self = this;
        ValueFunction<Object, String> customFormatter = new ValueFunction<Object, String>(){

            public String getValue(Object context, Object dataObject, int index, int groupIndex) {
                ArrayEx d = self.dataSet;
                return ((WaterfallDatum)d.get(ObjectConverter.toInt((Object)dataObject))).category();
            }
        };
        if (this.updateType <= 1) {
            boolean isLegendLeftOrRight;
            this._independentScale = this.makeIndependentScale(this.dataSet);
            this._dependentScale = this.makeDependentScale(this.dataSet);
            DataSlotEntry xDataSlotEntry = this.dataModel.dataset("data").slot("x").entry();
            DataSlotEntry yDataSlotEntry = this.dataModel.dataset("data").slot("y").entry();
            this._axes.visible(true).duration(0).transpose(transpose).scale(0, this._independentScale).scale(2, this._dependentScale).setDataSlot(0, xDataSlotEntry).setDataSlot(2, yDataSlotEntry).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).setTickFormatter(0, xDataSlotEntry).setTickFormatter(2, yDataSlotEntry);
            this._axes.axisComponent(0).tickFormat(customFormatter);
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, true, true, false, showLegend);
            legendPosition = this._layoutComponent.legendPosition();
            boolean bl2 = isLegendLeftOrRight = "left".equals(legendPosition) || "right".equals(legendPosition);
            if (isLegendLeftOrRight) {
                this._legends.preLayout(this._layoutComponent, false);
                this._axes.preLayout(this._layoutComponent, false, 0.1, 0.05, 0, 0.1, 0.05, 0);
            } else {
                this._axes.preLayout(this._layoutComponent, true, 0.1, 0.05, 0, 0.1, 0.05, 0);
                this._legends.preLayout(this._layoutComponent, true);
            }
            this._layoutComponent.layout();
            this._legends.position(legendPosition);
            this._axes.useBoundsFromLayout(this._layoutComponent).setScaleRanges(0.2, 0.05, 0);
            if (this._independentScale != null) {
                this._independentScale.expandZeroExtent(false);
                if (this.getBooleanProperty("axis.x.scale.nice")) {
                    this._independentScale.nice();
                }
                if (transpose) {
                    this.zoomYScale = this._independentScale.scale().copy();
                } else {
                    this.zoomXScale = this._independentScale.scale().copy();
                }
            }
            if (this._dependentScale != null) {
                this._dependentScale.expandZeroExtent(true);
                this._dependentScale.expandPixels(2.0, true);
                if (this.getBooleanProperty("axis.y.scale.nice")) {
                    this._dependentScale.nice();
                }
                if (this.getBooleanProperty("axis.y.scale.includeZero")) {
                    this._dependentScale.includeZero();
                }
                if (transpose) {
                    this.zoomXScale = this._dependentScale.scale().copy();
                } else {
                    this.zoomYScale = this._dependentScale.scale().copy();
                }
            }
            this.resetZoom();
        }
        this.chartRect = this._layoutComponent.elementRect();
        this._legends.rectangle(this._layoutComponent.legendRect());
        this._clip.clipRect(this.chartRect).applyTo(this._chart.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
        this._chart.select((Object)"rect.background.elements").attr("x", (Object)this.chartRect.x).attr("y", (Object)this.chartRect.y).attr("width", (Object)this.chartRect.width).attr("height", (Object)this.chartRect.height);
        if (transpose) {
            xScale = this._dependentScale;
            yScale = this._independentScale;
        } else {
            xScale = this._independentScale;
            yScale = this._dependentScale;
        }
        this.setBackgroundProperties(this.chartRect, duration);
        String borderWidth = this.context.convertCSSSizeToPixels(this.context.getPropertyValue("border.width"));
        double lineWidth = Math.max(0.0, this.getCSSSizeToPixelNumber("line.width"));
        this._waterfallComponent.data(this.dataSet.toArray()).lineData(this.linesData.toArray()).independentScale(xScale).dependentScale(yScale).transpose(transpose).linePattern(this.getStringProperty("line.pattern")).drawBarAtZero(this._drawBarAtZero).zerothLineColor(ObjectConverter.asString((Object)this.context.getPropertyValue("zerothLine.color"))).barDelay(this.calculateBarDelay(elementDuration)).lineDelay(this.calculateLineDelay(elementDuration)).specialTransition(true).borderWidth(borderWidth).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("border.color"))).lineWidth(lineWidth);
        for (int i = 0; i < this.dataSet.size(); ++i) {
            WaterfallDatum d = (WaterfallDatum)this.dataSet.get(i);
            d.setColor(this.determineBarColor(this.isDatumPositive(d, this.dataSet), d.total(), d.id() == 0));
            if (i >= this.dataSet.size() - 1) continue;
            ((WaterfallLineData)this.linesData.get((int)i)).color = d.getColor();
        }
        this._chart.selectAll("g.elements").transition().duration((Object)elementDuration).call((RunFunction)this._waterfallComponent, new Object[0]);
        Selector nonElements = this.context.node.selectAll("g.gridlines, g.axes, g.legends, line.element-divider");
        nonElements.transition().duration((Object)nonElementDuration).style("opacity", (Object)0);
        this._axes.axisComponent(0).tickFormat(customFormatter);
        this._axes.draw();
        this._legends.draw();
        EventQueue.setTimeout((Runnable)new Runnable((Selection)nonElements, nonElementDuration){
            final /* synthetic */ Selection val$nonElements;
            final /* synthetic */ double val$nonElementDuration;
            {
                this.val$nonElements = selection;
                this.val$nonElementDuration = d;
            }

            public void run() {
                this.val$nonElements.transition().duration((Object)this.val$nonElementDuration).style("opacity", (Object)1);
            }
        }, (int)ObjectConverter.toInt((Object)((double)duration * 0.8)));
        if (this.updateType <= 2) {
            String ops = this.getStringProperty("zoom");
            if (xScale != null && (ops.equals("all") || ops.equals("x"))) {
                xScale.scale().domain(this.zoomXScale.domain());
            }
            if (yScale != null && (ops.equals("all") || ops.equals("y"))) {
                yScale.scale().domain(this.zoomYScale.domain());
            }
            final Zoom zoom = (Zoom)this.context.actions.action("zoom").get("zoom");
            ComponentConfiguration.configureZoom(this._chart, zoom, xScale, yScale, null, null, null, this.chartRect, this._zoomP, this._zoomS, this.getStringProperty("zoom"), new RunFunction<SceneNode>(){

                public Object run(SceneNode context, Object ... args) {
                    self._waterfallComponent.specialTransition(false);
                    self._chart.selectAll("g.elements").call((RunFunction)self._waterfallComponent, new Object[0]);
                    self._axes.redraw(true);
                    zoom.on("zoomend.hideLabels", (RunFunction)new RunFunction<SceneNode>(){

                        public Object run(SceneNode context, Object ... args) {
                            if (self._axes.hideAnyPanZoom()) {
                                if (self.zoomendedTimer != null) {
                                    EventQueue.clearTimeout((Object)self.zoomendedTimer);
                                }
                                self.zoomendedTimer = EventQueue.setTimeout((Runnable)new Runnable(){

                                    public void run() {
                                        self.zoomendedTimer = null;
                                        self._axes.redraw(false);
                                    }
                                }, (int)300);
                            }
                            return null;
                        }
                    });
                    return self._chart;
                }
            });
        }
        this.resetUpdate();
    }

    public CoordinateScale getCoordinateScale(String role) {
        if ("ROLE_X1".equals(role)) {
            return this._independentScale;
        }
        if ("ROLE_Y1".equals(role)) {
            return this._dependentScale;
        }
        return null;
    }

    private ArrayEx<WaterfallDatum> makeData(DataModel dataModel) {
        DataSet dataSet = dataModel.dataset("data");
        DataSlotEntry labelDataAccessor = dataSet.slot("x").entry();
        DataSlotEntry valueDataAccessor = dataSet.slot("y").entry();
        ArrayEx data = ObjectConverter.listToArray((List)((List)dataSet.data()));
        ArrayEx dataObject = new ArrayEx();
        int i = 0;
        for (Object d : data) {
            double height;
            double base;
            String label = ObjectConverter.asString((Object)labelDataAccessor.accessor().getValue(d));
            double value = ObjectConverter.toDouble((Object)valueDataAccessor.accessor().getValue(d));
            if (i == 0) {
                if (value >= 0.0) {
                    base = 0.0;
                    height = value;
                } else {
                    base = value;
                    height = 0.0;
                }
            } else {
                ArrayEx<Double> baseAndHeight = this.determineBaseHeightValue((WaterfallDatum)dataObject.get(i - 1), value);
                base = (Double)baseAndHeight.get(0);
                height = (Double)baseAndHeight.get(1);
            }
            WaterfallDatum w = new WaterfallDatum();
            w.id(i);
            w.category(label);
            w.value(value);
            w.base(ObjectConverter.toDouble((double)base));
            w.height(ObjectConverter.toDouble((double)height));
            w.total(false);
            w.setData(d);
            dataObject.add((Object)w);
            ++i;
        }
        if (ObjectConverter.toBoolean((Object)this.context.getPropertyValue("totalColumn.show"))) {
            double sumOfAllValues = this.calculateTotal(0, 0.0, (ArrayEx<WaterfallDatum>)dataObject);
            WaterfallDatum w = new WaterfallDatum();
            w.id(i);
            w.category(ObjectConverter.asString((Object)this.context.getPropertyValue("totalColumn.label")));
            w.value(sumOfAllValues);
            w.total(true);
            ArrayEx<Double> res = this.determineTotalColumnsBaseAndHeight((WaterfallDatum)dataObject.get(dataObject.length() - 1), sumOfAllValues);
            w.base((Double)res.get(0));
            w.height((Double)res.get(1));
            w.setData(null);
            dataObject.add((Object)w);
        }
        return dataObject;
    }

    private ArrayEx<Double> determineBaseHeightValue(WaterfallDatum previousDatum, double value) {
        ArrayEx baseAndHeight = new ArrayEx(2);
        double previousBase = previousDatum.base();
        double previousHeight = previousDatum.height();
        double previousValue = previousDatum.value();
        if (value == 0.0) {
            double val = previousValue < 0.0 ? previousBase : previousHeight;
            baseAndHeight.set(1, (Object)val);
            baseAndHeight.set(0, (Object)val);
        } else if (value < 0.0) {
            if (previousValue < 0.0) {
                baseAndHeight.set(1, (Object)previousBase);
                baseAndHeight.set(0, (Object)((Double)baseAndHeight.get(1) + value));
            } else {
                baseAndHeight.set(0, (Object)(previousHeight + value));
                baseAndHeight.set(1, (Object)previousHeight);
            }
        } else if (previousValue < 0.0) {
            baseAndHeight.set(0, (Object)previousBase);
            baseAndHeight.set(1, (Object)((Double)baseAndHeight.get(0) + value));
        } else {
            baseAndHeight.set(0, (Object)previousHeight);
            baseAndHeight.set(1, (Object)((Double)baseAndHeight.get(0) + value));
        }
        return baseAndHeight;
    }

    private ArrayEx<Double> determineTotalColumnsBaseAndHeight(WaterfallDatum previousDatum, double value) {
        ArrayEx baseAndHeight = new ArrayEx(2);
        double previousHeight = previousDatum.height();
        double previousBase = previousDatum.base();
        if (value == 0.0) {
            if (previousDatum.value() < 0.0) {
                if (previousBase < 0.0 && previousHeight < 0.0) {
                    baseAndHeight.set(0, (Object)previousBase);
                    baseAndHeight.set(1, (Object)0.0);
                } else {
                    baseAndHeight.add(0, (Object)0.0);
                    baseAndHeight.add(1, (Object)previousBase);
                }
            } else if (previousBase < 0.0 && previousHeight < 0.0) {
                baseAndHeight.set(0, (Object)previousBase);
                baseAndHeight.set(1, (Object)0.0);
            } else {
                baseAndHeight.set(0, (Object)0.0);
                baseAndHeight.set(1, (Object)previousHeight);
            }
        } else if (value >= 0.0) {
            baseAndHeight.set(0, (Object)0.0);
            baseAndHeight.set(1, (Object)value);
        } else {
            baseAndHeight.set(0, (Object)value);
            baseAndHeight.set(1, (Object)0.0);
        }
        return baseAndHeight;
    }

    private CoordinateScaleImpl makeIndependentScale(ArrayEx<WaterfallDatum> data) {
        ArrayEx domain = new ArrayEx();
        ArrayEx originalDomain = new ArrayEx();
        for (int i = 0; i < data.size(); ++i) {
            domain.add((Object)i);
            OrdinalCoordinateScaleDatum d = new OrdinalCoordinateScaleDatum((Object)i);
            d.push(((WaterfallDatum)data.get(i)).originalData());
            originalDomain.add((Object)d);
        }
        OrdinalCoordinateScale s = OrdinalCoordinateScale.create((List)domain, (List)originalDomain);
        s.originalDomainLabelAccessor((ValueFunction)new ValueFunction<Object, String>(){

            @SwiftMethodOverload(skipParameters={1})
            public String getValue(Object context, Object data, int index, int groupIndex) {
                Object key = ((OrdinalCoordinateScaleDatum)data).key();
                return ObjectConverter.toString((Object)key);
            }
        });
        return s;
    }

    private ArrayEx<WaterfallLineData> makeConnectingLinesData(ArrayEx<WaterfallDatum> data) {
        ArrayEx result = new ArrayEx();
        int nextNonZeroIndex = this.findNotZeroValueIndex(0, 1, data);
        int previousNonZeroIndex = 0;
        ArrayEx id1CacheList = new ArrayEx();
        ArrayEx id2CacheList = new ArrayEx();
        for (int i = 0; i < data.size() - 1; ++i) {
            WaterfallLineData lineObject = new WaterfallLineData();
            if (((WaterfallDatum)data.get(i)).value() != 0.0) {
                lineObject.id1 = previousNonZeroIndex = i;
                lineObject.id2 = nextNonZeroIndex <= i ? this.findNotZeroValueIndex(i, 1, data) : nextNonZeroIndex;
            } else if (i > 0) {
                lineObject.id1 = previousNonZeroIndex;
                lineObject.id2 = i + 1;
            }
            lineObject.y = ((WaterfallDatum)data.get(i)).value() >= 0.0 ? ((WaterfallDatum)data.get(i)).height() : ((WaterfallDatum)data.get(i)).base();
            if (id1CacheList.contains((Object)lineObject.id1) || id2CacheList.contains((Object)lineObject.id2)) {
                lineObject.id1 = 0;
                lineObject.id2 = 0;
                lineObject.y = 0.0;
            } else {
                id1CacheList.push((Object[])new Integer[]{lineObject.id1});
                id2CacheList.push((Object[])new Integer[]{lineObject.id2});
            }
            lineObject.value = ((WaterfallDatum)data.get(i)).value();
            result.add((Object)lineObject);
        }
        return result;
    }

    private int findNotZeroValueIndex(int startIdx, int step, ArrayEx<WaterfallDatum> data) {
        int nextIdx = startIdx + step;
        if (nextIdx <= 0 || nextIdx >= data.length()) {
            return nextIdx <= 0 ? 0 : data.length() - 1;
        }
        if (((WaterfallDatum)data.get(nextIdx)).value() != 0.0) {
            return nextIdx;
        }
        return this.findNotZeroValueIndex(nextIdx, step, data);
    }

    private CoordinateScaleImpl makeDependentScale(ArrayEx<WaterfallDatum> data) {
        ArrayEx heightsAndBases = new ArrayEx();
        if (data.size() == 1) {
            heightsAndBases.add((Object)((WaterfallDatum)data.get(0)).base());
            heightsAndBases.add((Object)((WaterfallDatum)data.get(0)).height());
        } else {
            for (Object d : data) {
                if (((WaterfallDatum)d).total()) continue;
                heightsAndBases.add((Object)((WaterfallDatum)d).base());
                heightsAndBases.add((Object)((WaterfallDatum)d).height());
            }
        }
        ArrayEx extent = (ArrayEx)Rave.extent((Object[])heightsAndBases.toArray());
        if (ObjectConverter.toDouble((Object)extent.get(0)) < 0.0 && ObjectConverter.toDouble((Object)extent.get(1)) > 0.0) {
            this._drawBarAtZero = true;
        }
        return LinearCoordinateScale.create((List)extent);
    }

    private WaterfallColorScale makeColorScale(ArrayEx<WaterfallDatum> data) {
        WaterfallColorScale wcs = new WaterfallColorScale();
        ArrayEx colorDomain = new ArrayEx();
        ArrayEx colorRange = new ArrayEx();
        String firstPositiveLabel = ObjectConverter.asString((Object)this.context.getPropertyValue("firstBarPositive.label"));
        String firstNegativeLabel = ObjectConverter.asString((Object)this.context.getPropertyValue("firstBarNegative.label"));
        String valuePositiveLabel = ObjectConverter.asString((Object)this.context.getPropertyValue("valueBarPositive.label"));
        String valueNegativeLabel = ObjectConverter.asString((Object)this.context.getPropertyValue("valueBarNegative.label"));
        String totalPositiveLabel = ObjectConverter.asString((Object)this.context.getPropertyValue("totalBarPositive.label"));
        String totalNegativeLabel = ObjectConverter.asString((Object)this.context.getPropertyValue("totalBarNegative.label"));
        boolean negativeVal = false;
        boolean positiveVal = false;
        boolean totalVal = false;
        boolean totalPosVal = false;
        boolean totalNegVal = false;
        for (Object d : data) {
            double value = ((WaterfallDatum)d).value();
            if (negativeVal && positiveVal && totalVal && totalPosVal && totalNegVal) break;
            if (((WaterfallDatum)d).total()) {
                totalVal = true;
                if (value >= 0.0) {
                    totalPosVal = true;
                    continue;
                }
                totalNegVal = true;
                continue;
            }
            if (value >= 0.0) {
                positiveVal = true;
                continue;
            }
            negativeVal = true;
        }
        if (data.size() > 1) {
            if (positiveVal) {
                colorDomain.add((Object)(valuePositiveLabel != null ? valuePositiveLabel : "Increase"));
                colorRange.add((Object)(this._valuePositiveColor != null ? this._valuePositiveColor : "#8cd211"));
            }
            if (negativeVal) {
                colorDomain.add((Object)(valueNegativeLabel != null ? valueNegativeLabel : "Decrease"));
                colorRange.add((Object)(this._valueNegativeColor != null ? this._valueNegativeColor : "#ff5003"));
            }
            if (totalPosVal && totalNegVal) {
                if (this._totalPositiveColor == this._totalNegativeColor) {
                    String label = null;
                    label = totalPositiveLabel != null && totalNegativeLabel != null ? totalPositiveLabel + ", " + totalNegativeLabel : (totalPositiveLabel != null ? totalPositiveLabel : (totalNegativeLabel != null ? totalNegativeLabel : "Sum"));
                    colorDomain.add((Object)label);
                    colorRange.add((Object)this._totalPositiveColor);
                } else {
                    colorDomain.add((Object)(totalPositiveLabel != null ? totalPositiveLabel : "Positive Sum"));
                    colorRange.add((Object)this._totalPositiveColor);
                    colorDomain.add((Object)(totalNegativeLabel != null ? totalNegativeLabel : "Negative Sum"));
                    colorRange.add((Object)this._totalNegativeColor);
                }
            } else {
                if (totalPosVal && !totalNegVal) {
                    colorDomain.add((Object)(totalPositiveLabel != null ? totalPositiveLabel : "Sum"));
                    colorRange.add((Object)this._totalPositiveColor);
                }
                if (totalNegVal && !totalPosVal) {
                    colorDomain.add((Object)(totalNegativeLabel != null ? totalNegativeLabel : "Sum"));
                    colorRange.add((Object)this._totalNegativeColor);
                }
            }
        }
        double firstValue = ((WaterfallDatum)data.get(0)).value();
        String firstColor = null;
        if (this._firstPositiveColor != null && !this._firstPositiveColor.equals("") && firstValue >= 0.0) {
            firstColor = this._firstPositiveColor;
        } else if (this._firstNegativeColor != null && !this._firstNegativeColor.equals("") && firstValue < 0.0) {
            firstColor = this._firstNegativeColor;
        }
        if (firstColor != null && !colorRange.contains(firstColor)) {
            if (firstValue >= 0.0) {
                colorDomain.add((Object)(firstPositiveLabel != null ? firstPositiveLabel : "First Value"));
            } else {
                colorDomain.add((Object)(firstNegativeLabel != null ? firstNegativeLabel : "First Value"));
            }
            colorRange.add((Object)firstColor);
        }
        if (data.size() == 1 && firstColor == null) {
            if (firstValue >= 0.0) {
                if (totalPosVal) {
                    colorRange.add((Object)(this._totalPositiveColor != null && !this._totalPositiveColor.equals("") ? this._totalPositiveColor : "#4178be"));
                } else {
                    colorRange.add((Object)(this._valuePositiveColor != null && !this._valuePositiveColor.equals("") ? this._valuePositiveColor : "#8cd211"));
                }
                colorDomain.add((Object)(firstPositiveLabel != null ? firstPositiveLabel : "First Value"));
            } else {
                if (totalNegVal) {
                    colorRange.add((Object)(this._totalNegativeColor != null && !this._totalNegativeColor.equals("") ? this._totalNegativeColor : "#4178be"));
                } else {
                    colorRange.add((Object)(this._valueNegativeColor != null && !this._valueNegativeColor.equals("") ? this._valueNegativeColor : "#ff5003"));
                }
                colorDomain.add((Object)(firstNegativeLabel != null ? firstNegativeLabel : "First Value"));
            }
        }
        wcs.labels = colorDomain;
        wcs.colors = colorRange;
        return wcs;
    }

    public boolean isDatumPositive(WaterfallDatum datum, ArrayEx<WaterfallDatum> datums) {
        if (datum.value() > 0.0) {
            return true;
        }
        if (datum.value() < 0.0) {
            return false;
        }
        if (datum.id() == 0 && datum.value() == 0.0) {
            return true;
        }
        return ((WaterfallDatum)datums.get(this.findNotZeroValueIndex(datum.id(), -1, datums))).value() > 0.0;
    }

    private String determineBarColor(boolean isPositive, boolean isTotal, boolean isFirst) {
        String barColor = null;
        barColor = isFirst && !isTotal ? this.determineBarColorByValueSign(isPositive, this._firstPositiveColor, this._firstNegativeColor, "#8cd211", "#ff5003") : (isTotal ? this.determineBarColorByValueSign(isPositive, this._totalPositiveColor, this._totalNegativeColor, "#4178be", "#ff5003") : this.determineBarColorByValueSign(isPositive, this._valuePositiveColor, this._valueNegativeColor, "#8cd211", "#ff5003"));
        return barColor;
    }

    private String determineBarColorByValueSign(boolean isPositive, String positiveColor, String negativeColor, String defaultPositive, String defaultNegative) {
        return isPositive ? this.determineBarColorOrDefault(positiveColor, defaultPositive) : this.determineBarColorOrDefault(negativeColor, defaultNegative);
    }

    private String determineBarColorOrDefault(String color, String defaultColor) {
        return color == null ? defaultColor : color;
    }

    private double calculateTotal(int fromIndex, double lastTotal, ArrayEx<WaterfallDatum> dataObject) {
        double total = lastTotal;
        for (int i = fromIndex; i < dataObject.size(); ++i) {
            total += ((WaterfallDatum)dataObject.get(i)).value();
        }
        return total;
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-waterfall", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.gridlines", "(", "g.grid left", "g.grid bottom", ")", "g.elements", ")", "g.axes", "(", "g.axes-layout", "g.axisTransform left", "g.axisTransform bottom", ")", "g.axis-callout", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }

    private ArrayEx<WaterfallDatum> updateData(ArrayEx<WaterfallDatum> data, ArrayEx<WaterfallLineData> lineData) {
        for (int i = 1; i < data.size(); ++i) {
            ((WaterfallDatum)data.get(i)).setConnectingLineHeight(((WaterfallLineData)lineData.get((int)(i - 1))).y);
        }
        return data;
    }

    private ValueFunction<Object, Number> calculateBarDelay(final double duration) {
        return new ValueFunction<Object, Number>(){

            @SwiftMethodOverload(skipParameters={1})
            public Number getValue(Object context, Object data, int index, int groupIndex) {
                return (double)index * (2.0 * duration);
            }
        };
    }

    private ValueFunction<Object, Number> calculateLineDelay(final double duration) {
        return new ValueFunction<Object, Number>(){

            @SwiftMethodOverload(skipParameters={1})
            public Number getValue(Object context, Object data, int index, int groupIndex) {
                return (double)index * (2.0 * duration) + duration;
            }
        };
    }

    protected static class WaterfallLineData {
        int id1 = -1;
        int id2 = -1;
        double y = 0.0;
        String color = null;
        double value = 0.0;
    }

    static class WaterfallColorScale {
        ArrayEx<Object> labels = new ArrayEx();
        ArrayEx<Object> colors = new ArrayEx();
    }
}

