/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.wordCloudBundle;

import com.ibm.json.java.JSONArray;
import com.ibm.rave.codegenerator.annotations.JsonObject;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.datamodel.DataModel;
import com.ibm.rave.library.datamodel.DataModelDescriptor;
import com.ibm.rave.library.datamodel.DataSetDescriptor;
import com.ibm.rave.library.datamodel.DataSlotDescriptor;
import com.ibm.rave.library.datamodel.ext.DataImporter;
import com.ibm.rave.library.service.ErrorDispatcher;

public class WordCloudDataImporter
implements DataImporter {
    public static final String ERROR_REQUIRED_PROPERTY_NULL = "null ImportData or required ImportData property (dataString or dataSetId)";
    public static final String ERROR_INVALID_DATASETID = "ImportData dataSetId is not valid";

    @SwiftMethodOverload(skipParameters={1})
    public boolean importData(DataModel model, Object data) {
        if (model == null) {
            return false;
        }
        ImportData iData = (ImportData)data;
        if (iData == null || iData.dataString == null || iData.dataSetId == null) {
            WordCloudDataImporter.reportError(401, null);
            return false;
        }
        DataModelDescriptor modelDescriptor = model.getDescriptor();
        DataSetDescriptor setDescriptor = null;
        for (DataSetDescriptor dsd : modelDescriptor.dataSets()) {
            if (!iData.dataSetId.equals(dsd.id())) continue;
            setDescriptor = dsd;
            break;
        }
        if (setDescriptor == null) {
            WordCloudDataImporter.reportError(404, null);
            return false;
        }
        ArrayEx<WordDataNode> wordDataList = this.countWords(model, iData, setDescriptor);
        model.setData(iData.dataSetId, wordDataList);
        for (DataSlotDescriptor dsd : setDescriptor.dataSlots()) {
            model.clearDataSlot(iData.dataSetId, dsd.id());
        }
        model.setDataSlot(iData.dataSetId, "label", "string", (SingleValueFunction)new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WordDataNode)data).word;
            }
        });
        model.setDataSlot(iData.dataSetId, "size", "numeric", (SingleValueFunction)new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((WordDataNode)data).count;
            }
        });
        model.clearDataSlot(iData.dataSetId, "color");
        return true;
    }

    private ArrayEx<WordDataNode> countWords(DataModel model, ImportData iData, DataSetDescriptor setDescriptor) {
        String seperator;
        String data = iData.dataString;
        OMap wordCountMap = new OMap();
        ArrayEx wordDataList = new ArrayEx();
        data = data.replaceAll("(\n|\r|\t)", " ");
        if (iData.excludedCharacters != null && iData.excludedCharacters.size() > 0) {
            String excludedCharsRegexp = null;
            for (Object objectCharacter : iData.excludedCharacters) {
                String cU;
                String character = ObjectConverter.toString(objectCharacter);
                if (character.length() <= 0) continue;
                excludedCharsRegexp = excludedCharsRegexp == null ? "(" : excludedCharsRegexp + "|";
                String cL = character.toLowerCase();
                if (!cL.equals(cU = character.toUpperCase())) {
                    excludedCharsRegexp = excludedCharsRegexp + cL + "|" + cU;
                    continue;
                }
                if (character.charAt(0) >= '0' && character.charAt(0) <= '9') {
                    excludedCharsRegexp = excludedCharsRegexp + character;
                    continue;
                }
                excludedCharsRegexp = excludedCharsRegexp + "\\" + character;
            }
            excludedCharsRegexp = excludedCharsRegexp + ")";
            data = data.replaceAll(excludedCharsRegexp, "");
        }
        if ((seperator = iData.seperatorRegex) == null) {
            seperator = " ";
        }
        for (String word : data.split(seperator)) {
            if (word.length() == 0) continue;
            String lowerCaseWord = word.toLowerCase();
            if (iData.excludedWords != null && (iData.excludedWords.contains((Object)lowerCaseWord) || iData.excludedWords.contains((Object)word))) continue;
            WordDataNode currentWord = (WordDataNode)wordCountMap.get((Object)lowerCaseWord);
            if (currentWord == null) {
                currentWord = new WordDataNode();
                currentWord.word = word;
                currentWord.count = 0;
                wordDataList.add((Object)currentWord);
            } else if (!currentWord.word.equals(word)) {
                currentWord.word = lowerCaseWord;
            }
            ++currentWord.count;
            wordCountMap.put((Object)lowerCaseWord, (Object)currentWord);
        }
        return wordDataList;
    }

    private static void reportError(int code, String location) {
        ErrorDispatcher.INSTANCE.logError(code, location);
    }

    @JsonObject
    private static class WordDataNode {
        String word;
        int count;

        private WordDataNode() {
        }
    }

    @JsonObject
    public static class ImportData {
        public String dataString;
        public String seperatorRegex;
        public String dataSetId;
        public JSONArray excludedCharacters;
        public JSONArray excludedWords;
    }
}

