/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.wordCloudBundle;

import com.ibm.rave.bundles.components.wordcloud.WordCloudComponentImpl;
import com.ibm.rave.bundles.components.wordcloud.WordCloudDataNode;
import com.ibm.rave.bundles.data.WordCloudDatum;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.ext.layout.cloud.CloudLayout;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.DeselectAllOperation;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class WordCloudView
extends BundleView {
    private static final String DATASLOT_LABEL = "label";
    private static final String DATASLOT_SIZE = "size";
    @InlineStringConstant
    public static final String ORIENTATION_HORIZONTAL = "horizontal";
    @InlineStringConstant
    public static final String ORIENTATION_VERTICAL = "vertical";
    @InlineStringConstant
    public static final String ORIENTATION_BOTH = "both";
    @InlineStringConstant
    public static final String ORIENTATION_ANGLED = "angled";
    @InlineStringConstant
    public static final String ORIENTATION_ANY = "any";
    @InlineStringConstant
    private static final String DATASLOT_COLOR = "color";
    @InlineStringConstant
    private static final String DATAMODEL_DATA = "data";
    @InlineStringConstant
    private static final String DATASLOT_KEY = "key";
    private static final double DEFAULT_SIZE = 10.0;
    private static final SingleValueFunction<Object, Object> COLOR_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return ((WordCloudDatum)data)._node.color;
        }
    };
    private static final SingleValueFunction<WordCloudDataNode, Object> CLOUDNODE_ACCESSOR = new SingleValueFunction<WordCloudDataNode, Object>(){

        public WordCloudDataNode getValue(Object data) {
            return ((WordCloudDatum)data)._node;
        }
    };
    private final WordCloudComponentImpl _wordCloudComponent = new WordCloudComponentImpl();
    private ArrayEx<WordCloudDataNode> _wordCloudData;
    private RectStruct _chartRect;
    private final LinearScale _sizeScale;
    private CloudLayout<WordCloudDataNode> _layout;
    private static final ValueFunction<Object, Integer> LAYOUT_ROTATE_HORIZONTAL = new ValueFunction<Object, Integer>(){

        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return 0;
        }
    };
    private static final ValueFunction<Object, Integer> LAYOUT_ROTATE_VERTICAL = new ValueFunction<Object, Integer>(){

        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return 90;
        }
    };
    private static final ValueFunction<Object, Integer> LAYOUT_ROTATE_BOTH = new ValueFunction<Object, Integer>(){

        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((WordCloudDataNode)((Object)data)).index % 2 == 0 ? 0 : 90;
        }
    };
    private static final ValueFunction<Object, Integer> LAYOUT_ROTATE_ANGLED = new ValueFunction<Object, Integer>(){

        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((WordCloudDataNode)((Object)data)).index % 2 == 0 ? 45 : -45;
        }
    };
    private static final ValueFunction<Object, Integer> LAYOUT_ROTATE_ANY = new ValueFunction<Object, Integer>(){

        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return -60 + ((WordCloudDataNode)((Object)data)).index % 7 * 20;
        }
    };

    public WordCloudView(BundleContext context) {
        super(context);
        OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)"0px");
        BundleUtils.setupDefaultActions((BundleContext)context, (String)".vizlibrary-wordcloud .chart .word", (OMap)style);
        this._sizeScale = Rave.scale.linear();
    }

    @Override
    protected boolean isZoomSupported() {
        return false;
    }

    @Override
    public void setup() {
        super.setup();
        DeselectAllOperation deselectAllOp = (DeselectAllOperation)this.context.actions.action("deselectAll").getOperation();
        deselectAllOp.originalStyleDefault.put((Object)"stroke-width", (Object)"0px");
    }

    public void draw() {
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-wordcloud");
        if (!this.validateDataModel("g.element-group")) {
            return;
        }
        if (this.updateType == 0) {
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".vizlibrary-wordcloud .chart .word")});
        }
        DataSet dataSet = this.dataModel.dataset(DATAMODEL_DATA);
        Palette colorPalette = this.getDynamicPalette();
        colorPalette.setData(dataSet, DATASLOT_COLOR);
        colorPalette.setAccessor(COLOR_ACCESSOR);
        colorPalette.setNullColor(this.getStringProperty("color.null"));
        boolean showLegend = this.isShowLegend();
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        String legendPosition = this.getLegendPosition();
        this._legends.visible(showLegend).position(legendPosition).transition(!"none".equals(effect), duration).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, colorPalette).shape(0, "square").title(0, this.context.getDataSlotLabel("legend.title", dataSet.slot(DATASLOT_COLOR).entry())).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, dataSet.slot(DATASLOT_COLOR).entry());
        if (this.updateType <= 1) {
            this._chartRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
            RectStruct legendRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, this._legends.anyVisible());
            this._legends.preLayout(this._layoutComponent);
            this._layoutComponent.layout();
            legendPosition = this._layoutComponent.legendPosition();
            this._legends.position(legendPosition);
            this._chartRect = this._layoutComponent.elementRect();
            legendRect = this._layoutComponent.legendRect();
            this._clip.clipRect(this._chartRect).applyTo(this._chart.select((Object)"content")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
            this._legends.rectangle(legendRect);
        }
        this.setBackgroundProperties(this._chartRect, duration);
        List sizeDomain = ScaleManager.numericDomain((List)((List)dataSet.data()), (DataSlotEntry)dataSet.slot(DATASLOT_SIZE).entry());
        if (sizeDomain == null || sizeDomain.size() == 0) {
            sizeDomain = new ArrayEx(new Object[]{10.0, 10.0});
        }
        double minFontSize = this.getCSSSizeToPixelNumber("font.minSize");
        double maxFontSize = this.getCSSSizeToPixelNumber("font.maxSize");
        if (ObjectConverter.toDouble((Object)Rave.min((List)sizeDomain)) == ObjectConverter.toDouble((Object)Rave.max((List)sizeDomain))) {
            double newFontsize;
            minFontSize = maxFontSize = (newFontsize = minFontSize + Math.abs(maxFontSize - minFontSize) / 2.0);
        }
        this._sizeScale.range((List)new ArrayEx(new Object[]{minFontSize, maxFontSize})).domain(sizeDomain);
        OMap font = new OMap();
        font.put((Object)"font-family", (Object)"helvetica");
        font.put((Object)"font-weight", (Object)"normal");
        font.put((Object)"font-style", (Object)"normal");
        String fontProperty = this.getStringProperty("font.font");
        if (fontProperty != null && fontProperty.length() > 0) {
            String style;
            String weight;
            OMap<String, Object> f = FontPropertyParser.parseCSSFont(fontProperty);
            String family = ObjectConverter.asString((Object)f.get((Object)"font-family"));
            if (ObjectConverter.toBoolean((Object)family)) {
                font.put((Object)"font-family", (Object)family);
            }
            if (ObjectConverter.toBoolean((Object)(weight = ObjectConverter.asString((Object)f.get((Object)"font-weight"))))) {
                font.put((Object)"font-weight", (Object)weight);
            }
            if (ObjectConverter.toBoolean((Object)(style = ObjectConverter.asString((Object)f.get((Object)"font-style"))))) {
                font.put((Object)"font-style", (Object)style);
            }
        }
        int fontPadding = this.getCSSSizeToPixelNumber("font.padding").intValue();
        String wordOrientation = this.getStringProperty("word.orientation");
        ((WordCloudComponentImpl)((WordCloudComponentImpl)this._wordCloudComponent.setPreExecute(this.context.getPreExecute())).key((SingleValueFunction<Object, Object>)WordCloudView.originalDatumAccessor((SingleValueFunction)WordCloudView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_KEY).entry())))).size(this._chartRect).duration(duration).colorPalette(colorPalette).effect(effect).cloudNodeAccessor(CLOUDNODE_ACCESSOR).font((OMap<String, Object>)font);
        if (this.updateType <= 1) {
            this._wordCloudData = this.createWordCloudDataNodeArray(dataSet);
            final WordCloudView self = this;
            this._layout = this.buildLayout(fontPadding, wordOrientation, (OMap<String, Object>)font);
            this._layout.on("step", (RunFunction)new RunFunction<CloudLayout<WordCloudDataNode>>(){

                public Object run(CloudLayout<WordCloudDataNode> layout, Object ... args) {
                    self._chart.selectAll("g.element-group").transition().call((RunFunction)self._wordCloudComponent.data((ArrayEx<? extends Object>)self.getMappedNodes((ArrayEx<WordCloudDataNode>)((ArrayEx)args[0]))), new Object[0]);
                    return null;
                }
            }).on("end", (RunFunction)new RunFunction<CloudLayout<WordCloudDataNode>>(){

                public Object run(CloudLayout<WordCloudDataNode> layout, Object ... args) {
                    double[][] bounds = (double[][])args[1];
                    int[] size = layout.size();
                    if (bounds != null) {
                        double boundsWidth = bounds[1][0] - bounds[0][0];
                        double boundsHeight = bounds[1][1] - bounds[0][1];
                        double hScale = ((WordCloudView)self)._chartRect.width / boundsWidth;
                        double vScale = ((WordCloudView)self)._chartRect.height / boundsHeight;
                        double scale = Math.min(hScale, vScale);
                        double leftSpace = bounds[0][0];
                        double rightSpace = (double)size[0] - bounds[1][0];
                        double bottomSpace = bounds[0][1];
                        double topSpace = (double)size[1] - bounds[1][1];
                        double tx = ((WordCloudView)self)._chartRect.width / 2.0 + ((WordCloudView)self)._chartRect.x;
                        double ty = ((WordCloudView)self)._chartRect.height / 2.0 + ((WordCloudView)self)._chartRect.y;
                        self._wordCloudComponent.scale(scale);
                        self._wordCloudComponent.translate(tx += (rightSpace - leftSpace) / 2.0 * scale, ty += (topSpace - bottomSpace) / 2.0 * scale);
                        self._chart.selectAll("g.element-group").transition().call((RunFunction)self._wordCloudComponent.data((ArrayEx<? extends Object>)self.getMappedNodes((ArrayEx<WordCloudDataNode>)((ArrayEx)args[0]))), new Object[0]);
                        self.context.actions.applyBindings();
                    }
                    return null;
                }
            }).start();
        } else {
            this._chart.selectAll("g.element-group").transition().duration((Object)duration).call((RunFunction)this._wordCloudComponent, new Object[0]);
        }
        this._legends.draw();
        this.resetUpdate();
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
    }

    private ArrayEx<WordCloudDatum> getMappedNodes(ArrayEx<WordCloudDataNode> wordCloudDataNodes) {
        ArrayEx mappedNodes = wordCloudDataNodes.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<WordCloudDataNode, WordCloudDatum>(){

            public WordCloudDatum getValue(WordCloudDataNode currentValue, int index, ArrayEx<WordCloudDataNode> array) {
                WordCloudDatum d = new WordCloudDatum();
                d._node = currentValue;
                return d;
            }
        });
        return mappedNodes;
    }

    private static String getFont(String fontProperty) {
        String[] fontFamilies = fontProperty.split(",");
        String quotedFontFamilies = "";
        boolean firstFont = true;
        for (String font : fontFamilies) {
            if ((font = font.trim().replaceAll("\"", "").replaceAll("'", "")).length() <= 0) continue;
            if (!firstFont) {
                quotedFontFamilies = quotedFontFamilies + ",";
            } else {
                firstFont = false;
            }
            quotedFontFamilies = quotedFontFamilies + font;
        }
        return quotedFontFamilies.length() > 0 ? quotedFontFamilies : "'serif'";
    }

    private ArrayEx<WordCloudDataNode> createWordCloudDataNodeArray(DataSet dataSet) {
        DataSlotEntry textAccessor = dataSet.slot(DATASLOT_LABEL).entry();
        DataSlotEntry sizeAccessor = dataSet.slot(DATASLOT_SIZE).entry();
        DataSlotEntry colorAccessor = dataSet.slot(DATASLOT_COLOR).entry();
        ArrayEx dataNodeArray = new ArrayEx();
        ArrayEx data = ObjectConverter.listToArray((List)((List)dataSet.data()));
        int arrayIndex = 0;
        for (int i = 0; i < data.size(); ++i) {
            WordCloudDataNode node = new WordCloudDataNode();
            Object d = data.get(i);
            if (sizeAccessor != null && sizeAccessor.getValue(d) == null) continue;
            node.index = arrayIndex++;
            node.text = ObjectConverter.toString((Object)textAccessor.getValue(d));
            node.value = sizeAccessor != null ? ObjectConverter.toDouble((Object)sizeAccessor.getValue(d)) : 10.0;
            node.color = colorAccessor != null ? colorAccessor.getValue(d) : null;
            node.data = d;
            dataNodeArray.add((Object)node);
        }
        return dataNodeArray;
    }

    private CloudLayout<WordCloudDataNode> buildLayout(int fontPadding, String wordOrientation, OMap<String, Object> font) {
        final WordCloudView self = this;
        return ((CloudLayout)Rave.layout.extension("cloud")).timeInterval(Double.valueOf(100.0)).size(new int[]{ObjectConverter.toInt((Object)this._chartRect.width), ObjectConverter.toInt((Object)this._chartRect.height)}).padding(fontPadding).font(ObjectConverter.asString((Object)font.get((Object)"font-family"))).fontWeight(ObjectConverter.asString((Object)font.get((Object)"font-weight"))).fontStyle(ObjectConverter.asString((Object)font.get((Object)"font-style"))).rotate(WordCloudView.getLayoutRotateFunction(wordOrientation)).words(this._wordCloudData).fontSize((ValueFunction)new ValueFunction<Object, Double>(){

            public Double getValue(Object context, Object d, int index, int groupIndex) {
                return ObjectConverter.toDouble((Object)self._sizeScale.getValue(null, (Object)((WordCloudDataNode)((Object)d)).value, index, groupIndex));
            }
        });
    }

    private static ValueFunction<Object, Integer> getLayoutRotateFunction(String orientation) {
        if (ORIENTATION_HORIZONTAL.equals(orientation)) {
            return LAYOUT_ROTATE_HORIZONTAL;
        }
        if (ORIENTATION_VERTICAL.equals(orientation)) {
            return LAYOUT_ROTATE_VERTICAL;
        }
        if (ORIENTATION_BOTH.equals(orientation)) {
            return LAYOUT_ROTATE_BOTH;
        }
        if (ORIENTATION_ANGLED.equals(orientation)) {
            return LAYOUT_ROTATE_ANGLED;
        }
        return LAYOUT_ROTATE_ANY;
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-wordcloud", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.elements", "(", "g.element-group", ")", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }
}

