/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.ext.imagemap.internal.geom;

import com.ibm.rave.core.geom.Path2DHandler;
import com.ibm.rave.core.internal.nativeImpl.RegExp;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

public class ImageMapPathParser {
    private final RegExp _pathRegex = new RegExp("([MLHVACSTQZ, ][ \\t\\r\\n]*)|(-?[0-9]+([.][0-9]*)?([Ee]-?[0-9]+)?)", "gi");
    private boolean _regexEnd;
    private String _path;

    public void parsePath(String path, Path2DHandler handler) {
        String cmd;
        this._pathRegex.lastIndex = 0;
        this._regexEnd = false;
        this._path = path.trim();
        String lastCommand = "M";
        double lastX = 0.0;
        double lastY = 0.0;
        double bX = 0.0;
        double bY = 0.0;
        boolean done = false;
        block21: while (!done && !this._regexEnd && (cmd = this.nextCommand()) != null) {
            if ("".equals(cmd) || ",".equals(cmd)) {
                cmd = lastCommand;
            }
            lastCommand = cmd;
            switch (cmd.charAt(0)) {
                case 'M': {
                    double x = this.nextNumber();
                    double y = this.nextNumber();
                    handler.moveTo(x, y);
                    lastX = x;
                    lastY = y;
                    continue block21;
                }
                case 'm': {
                    double x = this.nextNumber() + lastX;
                    double y = this.nextNumber() + lastY;
                    handler.moveTo(x, y);
                    lastX = x;
                    lastY = y;
                    continue block21;
                }
                case 'L': {
                    double x = this.nextNumber();
                    double y = this.nextNumber();
                    handler.lineTo(x, y);
                    lastX = x;
                    lastY = y;
                    continue block21;
                }
                case 'l': {
                    double x = this.nextNumber() + lastX;
                    double y = this.nextNumber() + lastY;
                    handler.lineTo(x, y);
                    lastX = x;
                    lastY = y;
                    continue block21;
                }
                case 'H': {
                    double x = this.nextNumber();
                    handler.lineTo(x, lastY);
                    lastX = x;
                    continue block21;
                }
                case 'h': {
                    double x = this.nextNumber() + lastX;
                    handler.lineTo(x, lastY);
                    lastX = x;
                    continue block21;
                }
                case 'V': {
                    double y = this.nextNumber();
                    handler.lineTo(lastX, y);
                    lastY = y;
                    continue block21;
                }
                case 'v': {
                    double y = this.nextNumber() + lastY;
                    handler.lineTo(lastX, y);
                    lastY = y;
                    continue block21;
                }
                case 'A': {
                    double rx = this.nextNumber();
                    double ry = this.nextNumber();
                    double angle = this.nextNumber();
                    boolean arcflag = this.nextNumber() != 0.0;
                    boolean sweepflag = this.nextNumber() != 0.0;
                    double x = this.nextNumber();
                    double y = this.nextNumber();
                    handler.arcTo(lastX, lastY, rx, ry, angle, arcflag, sweepflag, x, y);
                    lastX = x;
                    lastY = y;
                    continue block21;
                }
                case 'a': {
                    double rx = this.nextNumber();
                    double ry = this.nextNumber();
                    double angle = this.nextNumber();
                    boolean arcflag = this.nextNumber() != 0.0;
                    boolean sweepflag = this.nextNumber() != 0.0;
                    double x = this.nextNumber() + lastX;
                    double y = this.nextNumber() + lastY;
                    handler.arcTo(lastX, lastY, rx, ry, angle, arcflag, sweepflag, x, y);
                    lastX = x;
                    lastY = y;
                    continue block21;
                }
                case 'Q': {
                    double cpx = this.nextNumber();
                    double cpy = this.nextNumber();
                    double x = this.nextNumber();
                    double y = this.nextNumber();
                    handler.quadraticCurveTo(cpx, cpy, x, y);
                    lastX = x;
                    lastY = y;
                    bX = cpx;
                    bY = cpy;
                    continue block21;
                }
                case 'q': {
                    double cpx = this.nextNumber() + lastX;
                    double cpy = this.nextNumber() + lastY;
                    double x = this.nextNumber() + lastX;
                    double y = this.nextNumber() + lastY;
                    handler.quadraticCurveTo(cpx, cpy, x, y);
                    lastX = x;
                    lastY = y;
                    bX = cpx;
                    bY = cpy;
                    continue block21;
                }
                case 'T': {
                    double cpx = 2.0 * lastX - bX;
                    double cpy = 2.0 * lastY - bY;
                    double x = this.nextNumber();
                    double y = this.nextNumber();
                    handler.quadraticCurveTo(cpx, cpy, x, y);
                    lastX = x;
                    lastY = y;
                    bX = cpx;
                    bY = cpy;
                    continue block21;
                }
                case 't': {
                    double cpx = 2.0 * lastX - bX;
                    double cpy = 2.0 * lastY - bY;
                    double x = this.nextNumber() + lastX;
                    double y = this.nextNumber() + lastY;
                    handler.quadraticCurveTo(cpx, cpy, x, y);
                    lastX = x;
                    lastY = y;
                    bX = cpx;
                    bY = cpy;
                    continue block21;
                }
                case 'C': {
                    double cp1x = this.nextNumber();
                    double cp1y = this.nextNumber();
                    double cp2x = this.nextNumber();
                    double cp2y = this.nextNumber();
                    double x = this.nextNumber();
                    double y = this.nextNumber();
                    handler.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
                    lastX = x;
                    lastY = y;
                    bX = cp2x;
                    bY = cp2y;
                    continue block21;
                }
                case 'c': {
                    double cp1x = this.nextNumber() + lastX;
                    double cp1y = this.nextNumber() + lastY;
                    double cp2x = this.nextNumber() + lastX;
                    double cp2y = this.nextNumber() + lastY;
                    double x = this.nextNumber() + lastX;
                    double y = this.nextNumber() + lastY;
                    handler.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
                    lastX = x;
                    lastY = y;
                    continue block21;
                }
                case 'S': {
                    double cpx1 = 2.0 * lastX - bX;
                    double cpy1 = 2.0 * lastY - bY;
                    double cpx2 = this.nextNumber();
                    double cpy2 = this.nextNumber();
                    double x = this.nextNumber();
                    double y = this.nextNumber();
                    handler.bezierCurveTo(cpx1, cpy1, cpx2, cpy2, x, y);
                    lastX = x;
                    lastY = y;
                    bX = cpx2;
                    bY = cpy2;
                    continue block21;
                }
                case 's': {
                    double cpx1 = 2.0 * lastX - bX;
                    double cpy1 = 2.0 * lastY - bY;
                    double cpx2 = this.nextNumber() + lastX;
                    double cpy2 = this.nextNumber() + lastY;
                    double x = this.nextNumber() + lastX;
                    double y = this.nextNumber() + lastY;
                    handler.bezierCurveTo(cpx1, cpy1, cpx2, cpy2, x, y);
                    lastX = x;
                    lastY = y;
                    bX = cpx2;
                    bY = cpy2;
                    continue block21;
                }
                case 'Z': 
                case 'z': {
                    handler.closePath();
                    continue block21;
                }
            }
            done = true;
        }
    }

    public void parsePolygon(String points, Path2DHandler handler) {
        this._pathRegex.lastIndex = 0;
        this._regexEnd = false;
        this._path = points.trim();
        double x = this.nextNumber();
        if (this._regexEnd) {
            return;
        }
        double y = this.nextNumber();
        if (this._regexEnd) {
            return;
        }
        handler.moveTo(x, y);
        while (!this._regexEnd) {
            x = this.nextNumber();
            if (this._regexEnd) break;
            y = this.nextNumber();
            handler.lineTo(x, y);
        }
    }

    private String nextCommand() {
        RegExp.RegExpResult rr;
        while ((rr = this._pathRegex.exec(this._path)) != null) {
            String cmd = (String)rr.get(1);
            if (cmd == null) continue;
            return cmd.trim();
        }
        this._regexEnd = true;
        return null;
    }

    private double nextNumber() {
        RegExp.RegExpResult rr;
        while ((rr = this._pathRegex.exec(this._path)) != null) {
            String n = (String)rr.get(2);
            if (n == null) continue;
            return ObjectConverter.toDouble((Object)n);
        }
        this._regexEnd = true;
        return 0.0;
    }
}

