/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.library.datamodel.ext.DataImporter;
import com.ibm.rave.library.datamodel.ext.Rave1HierarchyImporter;
import com.ibm.rave.library.datamodel.ext.Rave1TableImporter;
import com.ibm.rave.library.palette.internal.PaletteManager;
import com.ibm.rave.library.service.BundleService;
import com.ibm.rave.library.service.ErrorDispatcher;
import com.ibm.rave.library.service.LibraryError;
import com.ibm.rave.library.service.LibraryExtensionService;

public final class Library {
    private static final String RAVE1_TABULAR_IMPORTER_KEY = "rave1";
    private static final String RAVE1_HIERARCHY_IMPORTER_KEY = "rave1hierarchy";
    @InlineStringConstant
    private static final String LIBRARY_DATA_KEY = "LIBRARY_DATA_KEY";
    public static final BundleService bundle = BundleService.INSTANCE;
    public static final LibraryExtensionService extensions = LibraryExtensionService.INSTANCE;
    public static final PaletteManager palettes = new PaletteManager();

    private static LibraryData getLibraryData() {
        LibraryData libraryData = (LibraryData)RaveContextManager.INSTANCE.getRaveContext().getData(LIBRARY_DATA_KEY);
        if (libraryData == null) {
            libraryData = new LibraryData();
            RaveContextManager.INSTANCE.getRaveContext().putData(LIBRARY_DATA_KEY, (Object)libraryData);
        }
        return libraryData;
    }

    private Library() {
    }

    public static final void logError(int code) {
        ErrorDispatcher.INSTANCE.logError(code);
    }

    public static final void logError(int code, String location) {
        ErrorDispatcher.INSTANCE.logError(code, location);
    }

    public static final void logError(int code, String location, String bundleName) {
        ErrorDispatcher.INSTANCE.logError(code, location, bundleName);
    }

    public static DataImporter getDataImporter(String importerName) {
        return (DataImporter)Library.getLibraryData()._dataImporters.get((Object)importerName);
    }

    public static void registerDataImporter(String importerName, DataImporter dataImporter) {
        Library.getLibraryData()._dataImporters.put((Object)importerName, (Object)dataImporter);
    }

    public static void onError(LibraryError.ReportError errorReporter) {
        ErrorDispatcher.INSTANCE.setReporter(errorReporter);
    }

    public static void error(LibraryError error) {
        ErrorDispatcher.INSTANCE.error(error);
    }

    private static OMap<String, DataImporter> buildImporterMap() {
        OMap importers = new OMap();
        importers.put((Object)RAVE1_TABULAR_IMPORTER_KEY, (Object)new Rave1TableImporter());
        importers.put((Object)RAVE1_HIERARCHY_IMPORTER_KEY, (Object)new Rave1HierarchyImporter());
        return importers;
    }

    public static final String _generateId() {
        return "_raveLibId_" + Library.getLibraryData().idCounter++ + "_";
    }

    static /* synthetic */ OMap access$000() {
        return Library.buildImporterMap();
    }

    private static class LibraryData {
        long idCounter = 0L;
        final OMap<String, DataImporter> _dataImporters = Library.access$000();

        private LibraryData() {
        }
    }
}

