/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.action;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.action.internal.OperationsUtil;
import com.ibm.rave.library.action.internal.PanZoomOperation;
import com.ibm.rave.library.framework.internal.BundleContext;

public class BundleUtils {
    public static ValueFunction<SceneNode, Boolean> notExit = new ValueFunction<SceneNode, Boolean>(){

        @SwiftMethodOverload(skipParameters={1})
        public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
            if (context.hasProperty("isExit")) {
                return false;
            }
            return true;
        }
    };

    public static void setupDefaultActions(final @SwiftWeak BundleContext context, final String element, OMap<String, Object> originalStyle) {
        ActionImpl highlightAction = BundleUtils.setupAction(context, element, "highlight", new String[]{"mouseenter.default"});
        highlightAction.setOperation(OperationsUtil.highlight());
        ActionImpl dehighlightAction = BundleUtils.setupAction(context, element, "unhighlight", new String[]{"mouseout.default"});
        dehighlightAction.setOperation(OperationsUtil.unhighlight(originalStyle));
        context.actions.action("select").setOperation(OperationsUtil.select());
        context.actions.action("deselect").setOperation(OperationsUtil.deselect());
        final ActionImpl deselectAllAction = context.actions.action("deselectAll");
        deselectAllAction.setOperation(OperationsUtil.deselectAll(originalStyle));
        SelectorEventListener<Event> deselectAllEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                deselectAllAction.call(context.node.selectAll(element));
            }
        };
        deselectAllAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater(context, ".background", new String[]{"click.default", "touchstart.default"}, deselectAllEventListener));
        deselectAllAction.setUnbindFn(BundleUtils.bindOrUnbindActionFunctionCreater(context, ".background", new String[]{"click.default", "touchstart.default"}, null));
        final ActionImpl toggleSelectionAction = (ActionImpl)context.actions.action("toggleSelect").setOperation(OperationsUtil.toggleSelection(originalStyle));
        SelectorEventListener<Event> toggleSelectionListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                toggleSelectionAction.call(Rave.select((SceneNode)context1), context.node.selectAll(element));
            }
        };
        toggleSelectionAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater(context, element, new String[]{"click.default", "touchstart.default"}, toggleSelectionListener));
        toggleSelectionAction.setUnbindFn(BundleUtils.bindOrUnbindActionFunctionCreater(context, element, new String[]{"click.default", "touchstart.default"}, null));
        BundleUtils.setupZoomAction(context);
    }

    public static void setupZoomAction(final @SwiftWeak BundleContext context) {
        ActionImpl zoomAction = context.actions.action("zoom");
        if (zoomAction != null) {
            zoomAction.setBindFn(BundleUtils.bindPanZoom(context, zoomAction, "zoom"));
            zoomAction.setUnbindFn(BundleUtils.bindOrUnbindActionFunctionCreater(context, ".chart", new String[]{"wheel.zoom", "dblclick.zoom", "mousedown.zoom", "mouseup.zoom", "mousemove.zoom"}, null));
            PanZoomOperation.ZoomContextFunction fn = new PanZoomOperation.ZoomContextFunction(){

                @Override
                public Selection<?> getContextSelection() {
                    return context.node.selectAll(".chart");
                }
            };
            zoomAction.setOperation(OperationsUtil.panZoom(Rave.behavior.zoom(), fn));
        }
    }

    private static ActionImpl setupAction(@SwiftWeak BundleContext context, String element, String actionName, String[] event) {
        ActionImpl action = context.actions.action(actionName);
        if (action != null) {
            action.setBindFn(BundleUtils.bindAction(context, element, action, event));
            action.setUnbindFn(BundleUtils.bindOrUnbindActionFunctionCreater(context, element, event, null));
        }
        return action;
    }

    private static BindingOperation bindPanZoom(final @SwiftWeak BundleContext context, final @SwiftWeak ActionImpl zoomAction, final String action) {
        return new BindingOperation(){

            @Override
            public void call() {
                context.node.selectAll(".chart").call((RunFunction)((Zoom)zoomAction.get(action)), new Object[0]);
            }
        };
    }

    public static BindingOperation bindAction(final @SwiftWeak BundleContext context, final String element, final @SwiftWeak ActionImpl action, final String[] events) {
        SelectorEventListener<Event> listener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                action.call(Rave.select((SceneNode)context1));
            }
        };
        return new BindingOperation((SelectorEventListener)listener){
            final /* synthetic */ SelectorEventListener val$listener;
            {
                this.val$listener = selectorEventListener;
            }

            @Override
            public void call() {
                for (String event : events) {
                    context.node.selectAll(element).on(event, this.val$listener);
                }
            }
        };
    }

    public static BindingOperation bindOrUnbindActionFunctionCreater(final @SwiftWeak BundleContext context, final String element, final String[] events, final SelectorEventListener<Event> actionListener) {
        return new BindingOperation(){

            @Override
            public void call() {
                for (String event : events) {
                    context.node.selectAll(element).on(event, actionListener);
                }
            }
        };
    }

    public static void setupBreadcrumbDefaultActions(final @SwiftWeak BundleContext context, final String element) {
        final ActionImpl breadcrumbSelectAction = context.actions.action("breadcrumbSelect");
        breadcrumbSelectAction.setBindFn(new BindingOperation(){

            @Override
            public void call() {
                context.node.selectAll(element).on("click.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        breadcrumbSelectAction.call(data);
                    }
                });
            }
        });
        breadcrumbSelectAction.setUnbindFn(new BindingOperation(){

            @Override
            public void call() {
                context.node.selectAll(element).on("click.default", null);
            }
        });
    }

    @FunctionClass(value="call")
    @SwiftClosure(value="call")
    public static interface BindingOperation {
        public void call();
    }
}

