/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.action;

import com.ibm.rave.core.Rave;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;

public class SelectionManager {
    public static final String HIGHLIGHED_FLAG = "highlighted";
    public static final String SELECTED_FLAG = "selected";
    public static final String DEEMPHASIZED_FLAG = "deemphasized";
    private static final CallbackFunction<SceneNode> APPLY_HIGHLIGHTED_STATE = new CallbackFunction<SceneNode>(){

        public void run(SceneNode context, Object data, int index, int groupIndex) {
            Rave.select((SceneNode)context).property(SelectionManager.HIGHLIGHED_FLAG, (Object)true).classed(SelectionManager.HIGHLIGHED_FLAG, true);
        }
    };
    private static final CallbackFunction<SceneNode> REMOVE_HIGHLIGHTED_STATE = new CallbackFunction<SceneNode>(){

        public void run(SceneNode context, Object data, int index, int groupIndex) {
            Rave.select((SceneNode)context).property(SelectionManager.HIGHLIGHED_FLAG, (Object)false).classed(SelectionManager.HIGHLIGHED_FLAG, false);
        }
    };
    private static final CallbackFunction<SceneNode> APPLY_SELECTED_STATE = new CallbackFunction<SceneNode>(){

        public void run(SceneNode context, Object data, int index, int groupIndex) {
            Rave.select((SceneNode)context).property(SelectionManager.SELECTED_FLAG, (Object)true).classed(SelectionManager.SELECTED_FLAG, true);
        }
    };
    private static final CallbackFunction<SceneNode> APPLY_DEEMPHASIZED_STATE = new CallbackFunction<SceneNode>(){

        public void run(SceneNode context, Object data, int index, int groupIndex) {
            Rave.select((SceneNode)context).property(SelectionManager.DEEMPHASIZED_FLAG, (Object)true).classed(SelectionManager.DEEMPHASIZED_FLAG, true);
        }
    };
    private static final CallbackFunction<SceneNode> REMOVE_SELECTED_STATE = new CallbackFunction<SceneNode>(){

        public void run(SceneNode context, Object data, int index, int groupIndex) {
            Rave.select((SceneNode)context).property(SelectionManager.SELECTED_FLAG, (Object)false).classed(SelectionManager.SELECTED_FLAG, false);
        }
    };
    private static final CallbackFunction<SceneNode> REMOVE_DEEMPHASIZED_STATE = new CallbackFunction<SceneNode>(){

        public void run(SceneNode context, Object data, int index, int groupIndex) {
            Rave.select((SceneNode)context).property(SelectionManager.DEEMPHASIZED_FLAG, (Object)false).classed(SelectionManager.DEEMPHASIZED_FLAG, false);
        }
    };
    private Selection<?> _context = Rave.selection();
    private RunFunction<Selection<?>> _stateChangeCallback = new RunFunction<Selection<?>>(){

        public Object run(Selection<?> context, Object ... args) {
            return null;
        }
    };

    public SelectionManager updateContext(Selection<?> context) {
        this._context = context;
        Selection<?> selected = SelectionManager.filterSelected(this._context, true);
        if (selected.empty()) {
            this._context.each(REMOVE_DEEMPHASIZED_STATE);
        } else {
            SelectionManager.filterSelected(this._context, false).each(APPLY_DEEMPHASIZED_STATE);
        }
        this.stateChanged();
        return this;
    }

    public SelectionManager onStateChange(RunFunction<Selection<?>> callback) {
        this._stateChangeCallback = callback;
        return this;
    }

    public void highlight(Selection<?> selection) {
        selection.each(APPLY_HIGHLIGHTED_STATE);
        this.stateChanged();
    }

    public void unHighlight(Selection<?> selection) {
        selection.each(REMOVE_HIGHLIGHTED_STATE);
        this.stateChanged();
    }

    public void toggleHighlight(final Selection<?> selection) {
        final SelectionManager self = this;
        selection.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                Selector ctx = Rave.select((SceneNode)context);
                if (ObjectConverter.toBoolean((Object)ctx.property(SelectionManager.HIGHLIGHED_FLAG))) {
                    self.unHighlight(selection);
                } else {
                    self.highlight(selection);
                }
            }
        });
        this.stateChanged();
    }

    public void select(Selection<?> selection) {
        Selection<?> unSelected = SelectionManager.filterSelected(this._context, false);
        unSelected.each(APPLY_DEEMPHASIZED_STATE);
        selection.each(APPLY_SELECTED_STATE).each(REMOVE_DEEMPHASIZED_STATE);
        this.stateChanged();
    }

    public void deSelect(Selection<?> selection) {
        selection.each(REMOVE_SELECTED_STATE);
        Selection<?> selected = SelectionManager.filterSelected(this._context, true);
        if (selected.empty()) {
            this._context.each(REMOVE_DEEMPHASIZED_STATE);
        } else {
            selection.each(APPLY_DEEMPHASIZED_STATE);
        }
        this.stateChanged();
    }

    public void toggleSelect(final Selection<?> selection) {
        final SelectionManager self = this;
        selection.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                if (ObjectConverter.toBoolean((Object)Rave.select((SceneNode)context).property(SelectionManager.SELECTED_FLAG))) {
                    self.deSelect(selection);
                } else {
                    self.select(selection);
                }
            }
        });
        this.stateChanged();
    }

    public Selection<?> getHighlighted() {
        return SelectionManager.filterHighlighted(this._context, true);
    }

    public Selection<?> getSelected() {
        return SelectionManager.filterSelected(this._context, true);
    }

    private final void stateChanged() {
        this._context.call(this._stateChangeCallback, new Object[0]);
    }

    private static final Selection<?> filterHighlighted(Selection<?> context, final boolean highlighted) {
        return context.filter((ValueFunction)new ValueFunction<SceneNode, Boolean>(){

            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                return ObjectConverter.toBoolean((Object)Rave.select((SceneNode)context).property(SelectionManager.HIGHLIGHED_FLAG)) == highlighted;
            }
        });
    }

    private static final Selection<?> filterSelected(Selection<?> context, final boolean selected) {
        return context.filter((ValueFunction)new ValueFunction<SceneNode, Boolean>(){

            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                return ObjectConverter.toBoolean((Object)Rave.select((SceneNode)context).property(SelectionManager.SELECTED_FLAG)) == selected;
            }
        });
    }
}

