/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.action.internal;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.library.action.internal.Binding;
import java.util.Map;

public class BindingManager {
    private final ES6Map<String, ES6Map<String, ES6Map<String, Binding>>> bindingMap = ES6Map.create();

    public void addBinding(String action, String target, String event) {
        ES6Map targetEvents;
        ES6Map actionBinding = (ES6Map)this.bindingMap.get((Object)action);
        if (actionBinding == null) {
            actionBinding = ES6Map.create();
            this.bindingMap.set((Object)action, (Object)actionBinding);
        }
        if ((targetEvents = (ES6Map)actionBinding.get((Object)target)) == null) {
            targetEvents = ES6Map.create();
            actionBinding.set((Object)target, (Object)targetEvents);
        }
        targetEvents.set((Object)event, (Object)new Binding(action, target, event));
    }

    public Binding removeBinding(String action, String target, String event) {
        ES6Map targetEvents;
        Binding existingBinding = null;
        ES6Map actionBinding = (ES6Map)this.bindingMap.get((Object)action);
        if (actionBinding != null && (targetEvents = (ES6Map)actionBinding.get((Object)target)) != null) {
            existingBinding = (Binding)targetEvents.get((Object)event);
            targetEvents.remove((Object)event);
        }
        return existingBinding;
    }

    public ArrayEx<Binding> getBindings() {
        ArrayEx bindings = new ArrayEx();
        for (String action : this.bindingMap.keys()) {
            bindings = bindings.concat(new Object[]{this.getBindingsForAction(action)});
        }
        return bindings;
    }

    public ArrayEx<Binding> getBindingsForAction(String action) {
        ArrayEx bindings = new ArrayEx();
        ES6Map targets = (ES6Map)this.bindingMap.get((Object)action);
        if (targets != null) {
            for (Map.Entry target : targets.entries()) {
                for (Map.Entry event : ((ES6Map)target.getValue()).entries()) {
                    bindings.add(event.getValue());
                }
            }
        }
        return bindings;
    }
}

