/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.action.internal;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.layout.chord.ChordData;
import com.ibm.rave.core.layout.chord.GroupData;
import com.ibm.rave.core.layout.chord.GroupDataStruct;
import com.ibm.rave.core.layout.chord.MatrixDataStruct;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.library.action.ActionOperation;
import com.ibm.rave.library.action.FiltersUtil;
import com.ibm.rave.library.bundleData.ChordBundleChordDatum;

public class ChordToggleSelectionOperation
extends ActionOperation {
    public OMap<String, Object> primaryStyleDefault = new OMap();
    public OMap<String, Object> secondaryStyleDefault = new OMap();
    public OMap<String, Object> _chordsOriginalStyleDefault = new OMap();
    private OMap<String, Object> _groupsOriginalStyleDefault = new OMap();

    ChordToggleSelectionOperation(OMap<String, Object> chordsOriginalStyle, OMap<String, Object> groupsOriginalStyle) {
        this.primaryStyleDefault.put((Object)"stroke", (Object)new ValueFunction<SceneNode, Object>(){

            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                Object color = context.getProperty("_rave_initialColor");
                if (color == null) {
                    if ("path".equals(context.getName())) {
                        color = context.getStyle("stroke");
                        if (color instanceof String && ObjectConverter.toString((Object)color).length() == 0) {
                            color = context.getStyle("fill");
                        }
                    } else {
                        color = context.getStyle("fill");
                    }
                    if (color != null) {
                        context.setProperty("_rave_initialColor", (Object)color.toString());
                    }
                }
                return Rave.rgb((Object)color).darker(0.3);
            }
        });
        this.primaryStyleDefault.put((Object)"stroke-width", (Object)"1pt");
        this.primaryStyleDefault.put((Object)"opacity", (Object)0.8);
        this.secondaryStyleDefault.put((Object)"opacity", (Object)0.3);
        this.secondaryStyleDefault.put((Object)"stroke", null);
        if (chordsOriginalStyle != null) {
            this._chordsOriginalStyleDefault = chordsOriginalStyle;
        }
        if (groupsOriginalStyle != null) {
            this._groupsOriginalStyleDefault = groupsOriginalStyle;
        }
    }

    @Override
    public void call(Object ... args) {
        OMap primaryStyles = args.length > 2 && args[2] != null && !(args[2] instanceof Number) ? (OMap)args[2] : this.primaryStyleDefault;
        OMap secondaryStyles = args.length > 3 && args[3] != null && !(args[3] instanceof Number) ? (OMap)args[3] : this.secondaryStyleDefault;
        final double duration = args[args.length - 1] != null && args[args.length - 1] instanceof Number ? ObjectConverter.toDouble((Object)args[args.length - 1]) : 50.0;
        Selector allShapes = (Selector)args[1];
        Selector chordsSelection = allShapes.filter(".chord");
        Selector selectedChord = (Selector)args[0];
        ChordData chordData = ((ChordBundleChordDatum)selectedChord.datum()).getChordData();
        final MatrixDataStruct sourceStruct = (MatrixDataStruct)chordData.source.datum;
        final MatrixDataStruct targetStruct = (MatrixDataStruct)chordData.target.datum;
        Selector allGroupsSelection = allShapes.filter(".groupPath");
        Selector filteredGroupsAttachedToSelectedChord = allGroupsSelection.filter((ValueFunction)new ValueFunction<SceneNode, Boolean>(){

            @SwiftMethodOverload(skipParameters={1})
            public Boolean getValue(SceneNode arg0, Object data, int i, int groupIndex) {
                GroupData groupData = (GroupData)data;
                String groupLabel = ObjectConverter.asString((Object)((GroupDataStruct)groupData.datum).label);
                return groupLabel.equals(sourceStruct.sourceID) || groupLabel.equals(targetStruct.sourceID);
            }
        });
        if (ObjectConverter.toBoolean((Object)selectedChord.property("selected"))) {
            selectedChord.property("selected", null);
            Selector selectedItems = FiltersUtil.INSTANCE.selectionFilter(chordsSelection, false);
            if (selectedItems.size() == 0) {
                Transition tAll = chordsSelection.transition(".transitionAllChords").duration((Object)duration);
                for (Object key : this._chordsOriginalStyleDefault.keySet()) {
                    tAll.style((String)key, this._chordsOriginalStyleDefault.get(key));
                }
            } else {
                Transition deselectSelectedChordTransition = selectedChord.transition(".deselectSelectedChordTransition").duration((Object)duration);
                for (Object key : secondaryStyles.keySet()) {
                    deselectSelectedChordTransition.style((String)key, secondaryStyles.get(key));
                }
            }
            filteredGroupsAttachedToSelectedChord.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    Selector element = Rave.select((SceneNode)context);
                    int chordReferenceCounter = element.property("chordReferenceCounter") == null ? 0 : ObjectConverter.asInteger((Object)element.property("chordReferenceCounter"));
                    if (chordReferenceCounter > 0) {
                        element.property("chordReferenceCounter", (Object)(chordReferenceCounter - 1));
                    }
                }
            });
        } else {
            selectedChord.property("selected", (Object)true);
            Selector unselectedChords = FiltersUtil.INSTANCE.selectionFilter(chordsSelection, true);
            Transition applyDeselectionToUnselectedChordsTransition = unselectedChords.transition("deselect").duration((Object)duration);
            OMap attr = secondaryStyles;
            for (String key : attr.keySet()) {
                applyDeselectionToUnselectedChordsTransition.style(key, attr.get((Object)key));
            }
            Transition selectChordTransition = selectedChord.transition("selectChord").duration((Object)duration);
            attr = primaryStyles;
            for (String key : attr.keySet()) {
                selectChordTransition.style(key, attr.get((Object)key));
            }
            filteredGroupsAttachedToSelectedChord.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    Selector group = Rave.select((SceneNode)context);
                    int chordReferenceCounter = group.property("chordReferenceCounter") == null ? 0 : ObjectConverter.asInteger((Object)group.property("chordReferenceCounter"));
                    group.property("chordReferenceCounter", (Object)(chordReferenceCounter + 1));
                }
            });
        }
        Selector selectedChords = FiltersUtil.INSTANCE.selectionFilter(chordsSelection, false);
        if (selectedChords.size() == 0) {
            Transition originalT = allGroupsSelection.transition(".originalT").duration((Object)duration);
            for (Object key : this._groupsOriginalStyleDefault.keySet()) {
                originalT.style((String)key, this._groupsOriginalStyleDefault.get(key));
            }
        } else {
            final ChordToggleSelectionOperation self = this;
            allGroupsSelection.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context, Object data, int index, int indexGroup) {
                    Selector group = Rave.select((SceneNode)context);
                    int chordReferenceCounter = group.property("chordReferenceCounter") == null ? 0 : ObjectConverter.asInteger((Object)group.property("chordReferenceCounter"));
                    Transition tAll = Rave.select((SceneNode)context).transition(".tAll").duration((Object)duration);
                    if (chordReferenceCounter == 0) {
                        for (String key : self.secondaryStyleDefault.keySet()) {
                            tAll.style(key, self.secondaryStyleDefault.get((Object)key));
                        }
                    } else {
                        for (String key : self._groupsOriginalStyleDefault.keySet()) {
                            tAll.style(key, self._groupsOriginalStyleDefault.get((Object)key));
                        }
                    }
                }
            });
        }
    }
}

