/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.action.internal;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.library.action.ActionOperation;

public class PanZoomOperation
extends ActionOperation {
    private final Zoom _zoom;
    private ZoomContextFunction _contextSelectionFn;

    public PanZoomOperation(Zoom z, ZoomContextFunction selectionContext) {
        this._zoom = z;
        this._contextSelectionFn = selectionContext;
    }

    @Override
    public Object get(String id) {
        if (id.equals("zoom")) {
            return this._zoom;
        }
        return null;
    }

    @Override
    public void call(Object ... args) {
        if (this._zoom == null) {
            return;
        }
        double scaleFactor = 1.0;
        double translate_x = 0.0;
        double translate_y = 0.0;
        if (args.length > 0) {
            Double scaleBy = ObjectConverter.asDouble((Object)args[0]);
            double d = scaleFactor = scaleBy != null ? scaleBy : 1.0;
        }
        if (args.length > 1) {
            translate_x = ObjectConverter.toDouble((Object)args[1]);
        }
        if (args.length > 2) {
            translate_y = ObjectConverter.toDouble((Object)args[2]);
        }
        Point t = this._zoom.translate();
        this._zoom.translate(new Point(t.getX() - translate_x, t.getY() - translate_y));
        Point center0 = this._zoom.center() != null ? this._zoom.center() : new Point(this._zoom.size().getX() / 2.0, this._zoom.size().getY() / 2.0);
        Point translate0 = this._zoom.translate();
        Point coordinates0 = this.coordinates(center0);
        Dim extent = this._zoom.scaleExtent();
        double scaleTo = Math.max(extent.getWidth(), Math.min(extent.getHeight(), this._zoom.scale() * scaleFactor));
        this._zoom.scale(scaleTo);
        Point center1 = this.point(coordinates0);
        this._zoom.translate(new Point(translate0.getX() + center0.getX() - center1.getX(), translate0.getY() + center0.getY() - center1.getY()));
        Selection<?> zoomContext = this._contextSelectionFn.getContextSelection();
        this._zoom.event.run(null, new Object[]{zoomContext});
    }

    private Point coordinates(Point point) {
        double scale = this._zoom.scale();
        Point translate = this._zoom.translate();
        return new Point((point.getX() - translate.getX()) / scale, (point.getY() - translate.getY()) / scale);
    }

    private Point point(Point coordinates) {
        double scale = this._zoom.scale();
        Point translate = this._zoom.translate();
        return new Point(coordinates.getX() * scale + translate.getX(), coordinates.getY() * scale + translate.getY());
    }

    @FunctionClass(value="getContextSelection")
    public static interface ZoomContextFunction {
        public Selection<?> getContextSelection();
    }
}

