/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.datamodel.ext;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.JsonObject;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.library.datamodel.DataModel;
import com.ibm.rave.library.datamodel.DataModelDescriptor;
import com.ibm.rave.library.datamodel.DataSetDescriptor;
import com.ibm.rave.library.datamodel.ext.Rave1Importer;

public class Rave1TableImporter
extends Rave1Importer {
    @Override
    public boolean importData(DataModel model, Object data) {
        ImportData idata = (ImportData)data;
        if (model == null) {
            return false;
        }
        if (idata == null || idata.visJSONData == null || idata.index == null || idata.dataSetId == null) {
            Rave1TableImporter.reportError(model, 401, null);
            return false;
        }
        int index = idata.index;
        if (index < 0 || index >= idata.visJSONData.size()) {
            Rave1TableImporter.reportError(model, 402, null);
            return false;
        }
        JSONObject raveTable = (JSONObject)idata.visJSONData.get(index);
        if (raveTable == null || raveTable.get((Object)"fields") == null) {
            Rave1TableImporter.reportError(model, 403, null);
            return false;
        }
        DataModelDescriptor modelDescriptor = model.getDescriptor();
        DataSetDescriptor setDescriptor = null;
        for (DataSetDescriptor dsd : modelDescriptor.dataSets()) {
            if (!idata.dataSetId.equals(dsd.id())) continue;
            setDescriptor = dsd;
            break;
        }
        if (setDescriptor == null) {
            Rave1TableImporter.reportError(model, 404, null);
            return false;
        }
        if (!"tabular".equals(setDescriptor.type())) {
            Rave1TableImporter.reportError(model, 406, null);
            return false;
        }
        boolean reversed = idata.map != null && idata.reverseMap != null && idata.reverseMap != false;
        OMap<String, ArrayEx<String>> map = Rave1TableImporter.makeMap(model, idata.map, reversed, raveTable, setDescriptor);
        if (map == null) {
            return false;
        }
        ArrayEx rows = new ArrayEx();
        JSONArray specRows = (JSONArray)raveTable.get((Object)"rows");
        if (specRows != null) {
            int len = specRows.size();
            for (int i = 0; i < len; ++i) {
                rows.add(specRows.get(i));
            }
        }
        model.setData(idata.dataSetId, rows);
        return Rave1TableImporter.setSlots(model, setDescriptor, raveTable, map, reversed);
    }

    @JsonObject
    public static class ImportData {
        public JSONArray visJSONData;
        public Integer index;
        public String dataSetId;
        public OMap<String, Object> map;
        public Boolean reverseMap;
    }
}

