/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.datamodel.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.collections.OSet;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.datamodel.DataModel;
import com.ibm.rave.library.datamodel.DataModelDescriptor;
import com.ibm.rave.library.datamodel.internal.DataModelDescriptorImpl;
import com.ibm.rave.library.datamodel.internal.DataModelImpl;
import com.ibm.rave.library.i18n.MessagesRegistry;

public class BundleDataModels {
    private final ArrayEx<DataModelDescriptor> _allDescriptors = new ArrayEx();
    private final OMap<String, DataModelDescriptor> _allIds = new OMap();
    private final OSet<String> _hiddenIds = new OSet();
    private ArrayEx<DataModelDescriptor> _visibleDescriptors = new ArrayEx();
    private String _defaultModel;
    private DataModelImpl _dataModel;

    public final void populate(JSONObject json, MessagesRegistry messages) {
        Object v = json.get((Object)"datamodels");
        if (v != null) {
            for (Object o : (JSONArray)v) {
                JSONObject model = (JSONObject)o;
                String id = ObjectConverter.asString((Object)model.get((Object)"id"));
                if (id == null || this._allIds.containsKey((Object)id)) continue;
                DataModelDescriptorImpl desc = DataModelDescriptorImpl.create(model);
                desc.setMessages(messages);
                this._allDescriptors.add((Object)desc);
                this._allIds.put((Object)id, (Object)desc);
            }
            this._dataModel = null;
            this._visibleDescriptors = new ArrayEx();
            this.setDefaultModel(json);
        }
    }

    public final void configure(JSONObject json) {
        Object v = json.get((Object)"datamodels");
        if (v != null) {
            for (Object o : (JSONArray)v) {
                JSONObject model = (JSONObject)o;
                String id = ObjectConverter.asString((Object)model.get((Object)"id"));
                Boolean hidden = ObjectConverter.toBoolean((Object)model.get((Object)"hidden"));
                if (id == null || hidden == null || !hidden.booleanValue()) continue;
                this._hiddenIds.add((Object)id);
            }
            this._dataModel = null;
            this._visibleDescriptors = new ArrayEx();
            if (this._defaultModel != null && this._hiddenIds.contains((Object)this._defaultModel)) {
                this._defaultModel = null;
            }
            this.setDefaultModel(json);
        }
        if ((v = json.get((Object)"dataSlots")) != null) {
            for (DataModelDescriptor model : this._allDescriptors) {
                ((DataModelDescriptorImpl)model).configure((JSONArray)v);
            }
        }
    }

    private void setDefaultModel(JSONObject json) {
        String id;
        if (this._defaultModel == null && (id = ObjectConverter.asString((Object)json.get((Object)"defaultModel"))) != null && this._allIds.containsKey((Object)id) && !this._hiddenIds.contains((Object)id)) {
            this._defaultModel = id;
        }
    }

    public final ArrayEx<DataModelDescriptor> getDataModels() {
        if (this._visibleDescriptors.length() == 0) {
            for (DataModelDescriptor dmd : this._allDescriptors) {
                if (this._hiddenIds.contains((Object)dmd.id())) continue;
                this._visibleDescriptors.add((Object)dmd);
            }
        }
        return this._visibleDescriptors;
    }

    public final String getDefaultModelId() {
        if (this._defaultModel == null) {
            this.getDataModels();
            if (this._visibleDescriptors.length() > 0) {
                this._defaultModel = ((DataModelDescriptor)this._visibleDescriptors.get(0)).id();
            }
        }
        return this._defaultModel;
    }

    public final DataModel createDataModel(String modelId) {
        if (this._allDescriptors.length() == 0) {
            BundleDataModels.reportError(104, null);
            return null;
        }
        this.getDefaultModelId();
        if (modelId != null) {
            if (this._hiddenIds.contains((Object)modelId)) {
                BundleDataModels.reportError(105, modelId);
                return null;
            }
            DataModelDescriptor desc = (DataModelDescriptor)this._allIds.get((Object)modelId);
            if (desc != null) {
                this._dataModel = new DataModelImpl(desc);
                return this._dataModel;
            }
            BundleDataModels.reportError(105, modelId);
            return null;
        }
        this._dataModel = new DataModelImpl((DataModelDescriptor)this._allIds.get((Object)this._defaultModel));
        return this._dataModel;
    }

    public final DataModel dataModel() {
        if (this._dataModel == null) {
            this.createDataModel(null);
        }
        return this._dataModel;
    }

    private static final void reportError(int code, String location) {
        Library.logError(code, location);
    }

    public BundleDataModels copy() {
        BundleDataModels models = new BundleDataModels();
        for (DataModelDescriptor model : this._allDescriptors) {
            models._allDescriptors.add((Object)((DataModelDescriptorImpl)model).copy());
        }
        for (DataModelDescriptor model : models._allDescriptors) {
            models._allIds.put((Object)model.id(), (Object)model);
        }
        for (Object key : this._hiddenIds.toArray()) {
            models._hiddenIds.add((Object)ObjectConverter.asString((Object)key));
        }
        this._visibleDescriptors = new ArrayEx();
        models._defaultModel = this._defaultModel;
        models._dataModel = this._dataModel;
        return models;
    }
}

