/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.datamodel.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.datamodel.DataModelDescriptor;
import com.ibm.rave.library.datamodel.DataSetDescriptor;
import com.ibm.rave.library.datamodel.internal.DataSetDescriptorImpl;
import com.ibm.rave.library.i18n.MessagesRegistry;

public final class DataModelDescriptorImpl
implements DataModelDescriptor {
    final String _id;
    final String _label;
    final String _description;
    final ArrayEx<String> _tags;
    final ArrayEx<DataSetDescriptor> _dataSets;
    final OMap<String, Integer> _setIndexes;
    private MessagesRegistry _messages;

    private DataModelDescriptorImpl(String id, String label, String description, ArrayEx<String> tags) {
        this._id = id;
        this._label = label;
        this._description = description;
        this._tags = tags;
        this._dataSets = new ArrayEx();
        this._setIndexes = new OMap();
    }

    public static DataModelDescriptorImpl create(JSONObject json) {
        String id = ObjectConverter.asString((Object)json.get((Object)"id"));
        String label = ObjectConverter.asString((Object)json.get((Object)"label"));
        String description = ObjectConverter.asString((Object)json.get((Object)"description"));
        ArrayEx tags = new ArrayEx();
        JSONArray a = (JSONArray)json.get((Object)"tags");
        if (a != null) {
            int l = a.size();
            for (int i = 0; i < l; ++i) {
                tags.add((Object)ObjectConverter.toString((Object)a.get(i)));
            }
        }
        DataModelDescriptorImpl dmd = new DataModelDescriptorImpl(id, label, description, (ArrayEx<String>)tags);
        a = (JSONArray)json.get((Object)"datasets");
        if (a != null) {
            int l = a.size();
            for (int i = 0; i < l; ++i) {
                DataSetDescriptorImpl set = DataSetDescriptorImpl.create((JSONObject)a.get(i));
                dmd._dataSets.add((Object)set);
                dmd._setIndexes.put((Object)set._id, (Object)i);
            }
        }
        return dmd;
    }

    public final DataModelDescriptor configure(JSONArray dataSlotConfigs) {
        for (DataSetDescriptor dataSet : this._dataSets) {
            ((DataSetDescriptorImpl)dataSet).clearConfiguration();
        }
        for (Object configObj : dataSlotConfigs) {
            JSONObject config = (JSONObject)configObj;
            if (!this._id.equals(config.get((Object)"dataModelId"))) continue;
            for (DataSetDescriptor dataSet : this._dataSets) {
                if (!dataSet.id().equals(config.get((Object)"dataSetId"))) continue;
                ((DataSetDescriptorImpl)dataSet).configure(config);
            }
        }
        return this;
    }

    public final void setMessages(MessagesRegistry messages) {
        this._messages = messages;
        for (DataSetDescriptor set : this._dataSets) {
            ((DataSetDescriptorImpl)set).setMessages(messages);
        }
    }

    @Override
    public final String id() {
        return this._id;
    }

    @Override
    public final String label() {
        if (this._messages == null) {
            return this._label;
        }
        return this._messages._nls(this._label, this._label);
    }

    @Override
    public final String description() {
        if (this._messages == null) {
            return this._description;
        }
        return this._messages._nls(this._description, this._description);
    }

    @Override
    public final ArrayEx<String> tags() {
        if (this._messages == null) {
            return this._tags;
        }
        ArrayEx msgTags = new ArrayEx();
        for (String tag : this._tags) {
            msgTags.add((Object)this._messages._nls(tag, tag));
        }
        return msgTags;
    }

    @Override
    public ArrayEx<DataSetDescriptor> dataSets() {
        return this._dataSets;
    }

    DataModelDescriptor copy() {
        DataModelDescriptorImpl descriptor = new DataModelDescriptorImpl(this._id, this._label, this._description, this._tags);
        int ct = 0;
        for (DataSetDescriptor desc : this.dataSets()) {
            descriptor._dataSets.add((Object)desc.copy());
            descriptor._setIndexes.put((Object)desc.id(), (Object)ct++);
        }
        descriptor.setMessages(this._messages);
        return descriptor;
    }

    final Integer dataSetIndex(String dataSetId) {
        return (Integer)this._setIndexes.get((Object)dataSetId);
    }
}

