/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.datamodel.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.datamodel.DataSetDescriptor;
import com.ibm.rave.library.datamodel.DataSlotDescriptor;
import com.ibm.rave.library.datamodel.internal.DataSlotDescriptorImpl;
import com.ibm.rave.library.i18n.MessagesRegistry;

public final class DataSetDescriptorImpl
extends DataSetDescriptor {
    final String _id;
    final String _label;
    final String _description;
    final ArrayEx<String> _tags;
    final Object _icon;
    final String _cardinality;
    final String _type;
    final ArrayEx<DataSlotDescriptor> _dataSlots;
    final OMap<String, Integer> _slotIndexes;
    private MessagesRegistry _messages;

    private DataSetDescriptorImpl(String id, String label, String description, ArrayEx<String> tags, Object icon, String cardinality, String type) {
        this._id = id;
        this._label = label;
        this._description = description;
        this._tags = tags;
        this._icon = icon;
        this._cardinality = cardinality;
        this._type = type;
        this._dataSlots = new ArrayEx();
        this._slotIndexes = new OMap();
    }

    public static DataSetDescriptorImpl create(JSONObject json) {
        String type;
        String id = ObjectConverter.asString((Object)json.get((Object)"id"));
        String label = ObjectConverter.asString((Object)json.get((Object)"label"));
        String description = ObjectConverter.asString((Object)json.get((Object)"description"));
        ArrayEx tags = new ArrayEx();
        JSONArray a = (JSONArray)json.get((Object)"tags");
        if (a != null) {
            int l = a.size();
            for (int i = 0; i < l; ++i) {
                tags.add((Object)ObjectConverter.toString((Object)a.get(i)));
            }
        }
        Object icon = json.get((Object)"icon");
        String cardinality = ObjectConverter.toString((Object)json.get((Object)"cardinality"));
        if (!"0..1".equals(cardinality) && !"1".equals(cardinality)) {
            cardinality = "0..1";
        }
        if (!"tabular".equals(type = ObjectConverter.toString((Object)json.get((Object)"type"))) && !"hierarchy".equals(type)) {
            type = "tabular";
        }
        DataSetDescriptorImpl dsd = new DataSetDescriptorImpl(id, label, description, (ArrayEx<String>)tags, icon, cardinality, type);
        a = (JSONArray)json.get((Object)"dataslots");
        if (a != null) {
            int l = a.size();
            for (int i = 0; i < l; ++i) {
                DataSlotDescriptorImpl slot = DataSlotDescriptorImpl.create((JSONObject)a.get(i));
                dsd._dataSlots.add((Object)slot);
                dsd._slotIndexes.put((Object)slot._id, (Object)i);
            }
        }
        return dsd;
    }

    public final DataSetDescriptorImpl clearConfiguration() {
        for (DataSlotDescriptor dataSlot : this._dataSlots) {
            ((DataSlotDescriptorImpl)dataSlot).clearConfiguration();
        }
        return this;
    }

    public final DataSetDescriptorImpl configure(JSONObject slotConfig) {
        for (DataSlotDescriptor dataSlot : this._dataSlots) {
            if (!dataSlot.id().equals(slotConfig.get((Object)"dataSlotId"))) continue;
            ((DataSlotDescriptorImpl)dataSlot).configure(slotConfig);
        }
        return this;
    }

    public final void setMessages(MessagesRegistry messages) {
        this._messages = messages;
        for (DataSlotDescriptor slot : this._dataSlots) {
            ((DataSlotDescriptorImpl)slot).setMessages(messages);
        }
    }

    @Override
    public final String id() {
        return this._id;
    }

    @Override
    public final String label() {
        if (this._messages == null) {
            return this._label;
        }
        return this._messages._nls(this._label, this._label);
    }

    @Override
    public final String description() {
        if (this._messages == null) {
            return this._description;
        }
        return this._messages._nls(this._description, this._description);
    }

    @Override
    public final ArrayEx<String> tags() {
        if (this._messages == null) {
            return this._tags;
        }
        ArrayEx msgTags = new ArrayEx();
        for (String tag : this._tags) {
            msgTags.add((Object)this._messages._nls(tag, tag));
        }
        return msgTags;
    }

    @Override
    public final Object icon() {
        return this._icon;
    }

    @Override
    public final String cardinality() {
        return this._cardinality;
    }

    @Override
    public final String type() {
        return this._type;
    }

    @Override
    public final ArrayEx<DataSlotDescriptor> dataSlots() {
        return this._dataSlots;
    }

    final Integer dataSlotIndex(String dataSlotId) {
        return (Integer)this._slotIndexes.get((Object)dataSlotId);
    }

    @Override
    public final DataSetDescriptorImpl copy() {
        DataSetDescriptorImpl newDescriptor = new DataSetDescriptorImpl(this._id, this._label, this._description, this._tags, this._icon, this._cardinality, this._type);
        for (int i = 0; i < this._dataSlots.length(); ++i) {
            DataSlotDescriptorImpl slot = (DataSlotDescriptorImpl)((DataSlotDescriptor)this._dataSlots.get(i)).copy();
            newDescriptor._dataSlots.add((Object)slot);
            newDescriptor._slotIndexes.put((Object)slot._id, (Object)i);
        }
        newDescriptor._messages = this._messages;
        return newDescriptor;
    }
}

