/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.datamodel.internal;

import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.library.datamodel.DataModel;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlot;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.datamodel.internal.DataModelImpl;
import com.ibm.rave.library.datamodel.internal.DataSetImpl;
import com.ibm.rave.library.datamodel.internal.DataSlotDescriptorImpl;
import com.ibm.rave.library.datamodel.internal.DataSlotImpl;
import com.ibm.rave.library.service.LibraryError;
import java.util.List;

public final class DataSlotEntryImpl
implements DataSlotEntry {
    @SwiftWeak
    private final DataModelImpl _dataModel;
    @SwiftWeak
    private final DataSetImpl _dataSet;
    @SwiftWeak
    private final DataSlotImpl _dataSlot;
    private final int _dataSlotIndex;
    private final DataSlotDescriptorImpl _descriptor;
    private final String _qualifiedId;
    private String _type;
    private SingleValueFunction<Object, Object> _accessor;
    private List<Object> _domain;
    private Number _subDomainMagnitude;
    private String _label;
    private String _unit;
    private boolean _badValue;

    DataSlotEntryImpl(DataSlotDescriptorImpl descriptor, DataModelImpl dataModel, DataSetImpl dataSet, DataSlotImpl dataSlot, int index) {
        this._dataModel = dataModel;
        this._dataSet = dataSet;
        this._dataSlot = dataSlot;
        this._dataSlotIndex = index;
        this._descriptor = descriptor;
        this._qualifiedId = (this._dataModel != null ? this._dataModel.getDescriptor().id() : "null") + "." + (this._dataSet != null ? this._dataSet.descriptor().id() : "null") + "." + (this._dataSlot != null ? this._dataSlot.descriptor().id() : "null") + "[" + this._dataSlotIndex + "]";
        this._type = null;
        this._accessor = null;
        this._domain = null;
        this._label = null;
        this._unit = null;
        this._badValue = false;
        this._subDomainMagnitude = null;
    }

    @Override
    public DataModel dataModel() {
        return this._dataModel;
    }

    @Override
    public DataSet dataSet() {
        return this._dataSet;
    }

    @Override
    public DataSlot dataSlot() {
        return this._dataSlot;
    }

    @Override
    public final String type() {
        return this._type;
    }

    @Override
    public final DataSlotEntry type(String type) {
        if (type == null) {
            this._dataModel.error(LibraryError.create(111, this._qualifiedId));
            this._badValue = true;
        } else if (!this._descriptor.isValidType(type)) {
            this._dataModel.error(LibraryError.create(108, this._qualifiedId));
            this._badValue = true;
        } else {
            this._type = type;
            this._dataModel.dataModelDataChanged();
        }
        return this;
    }

    @Override
    public final SingleValueFunction<Object, Object> accessor() {
        return this._accessor;
    }

    @Override
    public final DataSlotEntry accessor(SingleValueFunction<Object, Object> accessor) {
        if (accessor == null) {
            this._dataModel.error(LibraryError.create(111, this._qualifiedId));
            this._badValue = true;
        } else {
            this._accessor = accessor;
            this._dataModel.dataModelDataChanged();
        }
        return this;
    }

    @Override
    public final List<Object> domain() {
        return this._domain;
    }

    @Override
    public final Number subDomainDivision() {
        return this._subDomainMagnitude;
    }

    @Override
    public final DataSlotEntry domain(List<Object> domain) {
        this._domain = domain != null && domain.size() == 0 ? null : domain;
        this._dataModel.dataModelDataChanged();
        return this;
    }

    @Override
    public final DataSlotEntry domain(List<Object> domain, Number subDomainDivision) {
        this._domain = domain != null && domain.size() == 0 ? null : domain;
        this._subDomainMagnitude = subDomainDivision;
        this._dataModel.dataModelDataChanged();
        return this;
    }

    @Override
    public String label() {
        return this._label;
    }

    @Override
    public DataSlotEntry label(String label) {
        this._label = label;
        this._dataModel.dataModelDataChanged();
        return this;
    }

    @Override
    public String unit() {
        return this._unit;
    }

    @Override
    public DataSlotEntry unit(String unit) {
        this._unit = unit;
        this._dataModel.dataModelDataChanged();
        return this;
    }

    @Override
    public final Object getValue(Object data) {
        return this._accessor != null ? this._accessor.getValue(data) : null;
    }

    @Override
    public final boolean isValid() {
        boolean b = !this._badValue;
        this._badValue = false;
        return b;
    }

    @Override
    public String qualifiedId() {
        return this._qualifiedId;
    }

    final boolean validate() {
        if (this._type == null || this._accessor == null) {
            this._dataModel.error(LibraryError.create(111, this._qualifiedId));
            return false;
        }
        if (!this._descriptor.isValidType(this._type)) {
            this._dataModel.error(LibraryError.create(108, this._qualifiedId));
            return false;
        }
        return true;
    }
}

