/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.datamodel.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.datamodel.DataSlot;
import com.ibm.rave.library.datamodel.DataSlotDescriptor;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.datamodel.internal.DataModelImpl;
import com.ibm.rave.library.datamodel.internal.DataSetImpl;
import com.ibm.rave.library.datamodel.internal.DataSlotDescriptorImpl;
import com.ibm.rave.library.datamodel.internal.DataSlotEntryImpl;
import com.ibm.rave.library.service.LibraryError;

public final class DataSlotImpl
implements DataSlot {
    @SwiftWeak
    private final DataModelImpl _dataModel;
    @SwiftWeak
    private final DataSetImpl _dataSet;
    private final DataSlotDescriptorImpl _descriptor;
    private final ArrayEx<DataSlotEntry> _entries;
    private final String _errorLocation;
    private String _overrideLabel;

    DataSlotImpl(DataSlotDescriptor descriptor, DataModelImpl dataModel, DataSetImpl dataSet) {
        this._descriptor = (DataSlotDescriptorImpl)descriptor;
        this._dataModel = dataModel;
        this._dataSet = dataSet;
        this._entries = new ArrayEx();
        this._errorLocation = (this._dataModel != null ? this._dataModel.getDescriptor().id() : "null") + "." + (this._dataSet != null ? this._dataSet.descriptor().id() : "null") + "." + this._descriptor.id();
        if (((DataSlotDescriptorImpl)descriptor).isRequired()) {
            String defaultType = (String)descriptor.dataTypes().get(0);
            this._entries.add((Object)new DataSlotEntryImpl(this._descriptor, this._dataModel, this._dataSet, this, 0).type(defaultType).accessor(DataSlotImpl.makeDefaultAccessor(descriptor.id(), defaultType)));
        }
    }

    @Override
    public void overrideLabel(String label) {
        this._overrideLabel = label;
    }

    @Override
    public String overrideLabel() {
        return this._overrideLabel;
    }

    @Override
    public DataSlotDescriptor descriptor() {
        return this._descriptor;
    }

    @Override
    public final DataSlotEntry push() {
        if (!this._descriptor.isMultiple()) {
            this.clear();
        }
        DataSlotEntryImpl e = new DataSlotEntryImpl(this._descriptor, this._dataModel, this._dataSet, this, this._entries.size());
        if (!this._descriptor.isHidden()) {
            this._entries.push((Object[])new DataSlotEntry[]{e});
            this._dataModel.dataModelDataChanged();
        }
        return e;
    }

    @Override
    public int size() {
        return this._entries.size();
    }

    @Override
    public ArrayEx<DataSlotEntry> entries() {
        return this._entries;
    }

    @Override
    public DataSlotEntry entry() {
        return this._entries.length() > 0 ? (DataSlotEntry)this._entries.get(0) : null;
    }

    @Override
    public DataSlotEntry entry(int index) {
        return this._entries.length() > index ? (DataSlotEntry)this._entries.get(index) : null;
    }

    @Override
    public final DataSlot clear() {
        this._entries.clear();
        this._dataModel.dataModelDataChanged();
        return this;
    }

    private static final SingleValueFunction<Object, Object> makeDefaultAccessor(final String dataslotId, String type) {
        if ("numeric".equals(type)) {
            return new SingleValueFunction<Object, Object>(){

                public Object getValue(Object data) {
                    if (data == null) {
                        return null;
                    }
                    Object v = ((JSONObject)data).get((Object)dataslotId);
                    return v == null ? null : Double.valueOf(ObjectConverter.toDouble((Object)v));
                }
            };
        }
        if ("string".equals(type)) {
            return new SingleValueFunction<Object, Object>(){

                public Object getValue(Object data) {
                    if (data == null) {
                        return null;
                    }
                    Object v = ((JSONObject)data).get((Object)dataslotId);
                    return v == null ? null : ObjectConverter.toString((Object)v);
                }
            };
        }
        if ("date".equals(type)) {
            return new SingleValueFunction<Object, Object>(){

                public Object getValue(Object data) {
                    if (data == null) {
                        return null;
                    }
                    Object v = ((JSONObject)data).get((Object)dataslotId);
                    return v == null ? null : ObjectConverter.toDate((Object)v);
                }
            };
        }
        return new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return data == null ? null : ((JSONObject)data).get((Object)dataslotId);
            }
        };
    }

    final boolean validate() {
        boolean OK = true;
        if (this._descriptor.isRequired() && this._entries.size() == 0) {
            this._dataModel.error(LibraryError.create(110, this._errorLocation));
            OK = false;
        }
        for (DataSlotEntry entry : this._entries) {
            if (((DataSlotEntryImpl)entry).validate()) continue;
            OK = false;
        }
        return OK;
    }
}

