/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.framework;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.nativeImpl.xhr.Xhr;
import com.ibm.rave.core.nativeImpl.xhr.XhrResult;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.datamodel.DataModelDescriptor;
import com.ibm.rave.library.datamodel.internal.BundleDataModels;
import com.ibm.rave.library.framework.BundleInfo;
import com.ibm.rave.library.framework.Controller;
import com.ibm.rave.library.framework.internal.AbstractController;
import com.ibm.rave.library.framework.internal.AbstractView;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.meta.ActionMeta;
import com.ibm.rave.library.framework.meta.BundleConfiguration;
import com.ibm.rave.library.framework.meta.GenericMetadata;
import com.ibm.rave.library.framework.meta.PreviewsMetadata;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.framework.meta.PropertyPresentationMeta;
import com.ibm.rave.library.framework.meta.internal.BundleConfigurationImpl;
import com.ibm.rave.library.framework.meta.internal.BundleConfigurationManager;
import com.ibm.rave.library.framework.meta.internal.GenericMetadataImpl;
import com.ibm.rave.library.framework.meta.internal.PreviewsMetadataImpl;
import com.ibm.rave.library.framework.meta.internal.PropertyPresentationMetaImpl;
import com.ibm.rave.library.i18n.Messages;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.internal.nativeImpl.LoaderNativeUtils;
import com.ibm.rave.library.property.PropertyProcessingInfo;
import com.ibm.rave.library.property.PropertyProcessor;
import com.ibm.rave.library.property.PropertySet;

public abstract class Bundle {
    private final GenericMetadataImpl _metadata = new GenericMetadataImpl();
    private final PreviewsMetadataImpl _previewsMeta = new PreviewsMetadataImpl();
    private ArrayEx<PropertyMeta> _properties = new ArrayEx();
    private final ArrayEx<PropertyPresentationMeta> _propertyPresentations = new ArrayEx();
    private final ArrayEx<ActionMeta> _actions = new ArrayEx();
    private final BundleDataModels _dataModels = new BundleDataModels();
    private final BundleConfigurationManager _configurations = new BundleConfigurationManager();
    private final BundleInfo _info;
    private String _version = "0.0.0";
    private String _build = "development";
    private String _path = "development";
    private final MessagesRegistry _messages = new MessagesRegistry();
    public static String DEFAULT_LOCALE = "en";
    private String _locale = DEFAULT_LOCALE;
    protected JSONArray _manifest;
    private Xhr<JSONArtifact> messageXhr;

    protected Bundle() {
        final Bundle self = this;
        this._info = new BundleInfo(){

            @Override
            public GenericMetadata meta() {
                return self._metadata;
            }

            @Override
            public ArrayEx<PropertyMeta> properties() {
                return self._properties;
            }

            @Override
            public ArrayEx<PropertyPresentationMeta> propertyPresentations() {
                return self._propertyPresentations;
            }

            @Override
            public ArrayEx<ActionMeta> actions() {
                return self._actions;
            }

            @Override
            public ArrayEx<DataModelDescriptor> dataModels() {
                return self._dataModels.getDataModels();
            }

            @Override
            public String getPreview(String format, ArrayEx<String> tags) {
                return self._previewsMeta.getPreview(format, tags);
            }

            @Override
            public ArrayEx<String> getPreviewTags() {
                return self._previewsMeta.getAllTags();
            }

            @Override
            public ArrayEx<String> getPreviews(String format) {
                return self._previewsMeta.getPreviews(format);
            }

            @Override
            public String getPreview(String format) {
                return self._previewsMeta.getPreview(format, null);
            }

            @Override
            public String getPreview() {
                return self._previewsMeta.getPreview("svg", null);
            }

            @Override
            public ArrayEx<String> getPreviews() {
                return self._previewsMeta.getPreviews("svg");
            }

            @Override
            public PreviewsMetadata previews() {
                return self._previewsMeta;
            }
        };
        this._configurations.setBundleInfo(this, this._info);
    }

    public final BundleInfo info() {
        return this._info;
    }

    public final String version() {
        return this._version;
    }

    public final String build() {
        return this._build;
    }

    public ArrayEx<BundleConfiguration> configurations() {
        return this._configurations.configurations();
    }

    public final Controller create() {
        return this.doCreate(null, true);
    }

    public final Controller create(String configID) {
        return this.doCreate(configID, true);
    }

    public final Controller create(String configID, boolean viewRequired) {
        return this.doCreate(configID, viewRequired);
    }

    public final String locale() {
        return this._locale;
    }

    public final void locale(String locale) {
        this._locale = locale;
    }

    public void locale(final String locale, String url, final Controller.Callback userCallback) {
        final Bundle self = this;
        String path = LoaderNativeUtils.getMessagesPath(locale, url);
        if (self._messages.locale(locale)) {
            if (userCallback != null) {
                userCallback.callback();
            }
            return;
        }
        self.messageXhr = Rave.json.create(path, (Xhr.Callback)new Xhr.Callback<JSONArtifact>(){

            public void callback(XhrResult error, JSONArtifact response) {
                if (error == null) {
                    self.setMessageCatalog(locale, (JSONObject)response);
                    self._messages.locale(locale);
                    if (userCallback != null) {
                        userCallback.callback();
                    }
                }
            }
        });
    }

    public void configure(JSONObject configurations, Controller.Callback userCallback) {
        if (configurations != null) {
            this._doConfigure(configurations, userCallback, this);
        } else if (userCallback != null) {
            userCallback.callback();
        }
    }

    protected void _doConfigure(JSONObject configurations, Controller.Callback userCallback, Bundle bundle) {
        if (userCallback != null) {
            userCallback.callback();
        }
    }

    protected abstract String getName();

    protected abstract AbstractView createView(BundleContext var1);

    protected AbstractController createController(String bundleName, BundleContext ctx, AbstractView view) {
        return new AbstractController(bundleName, ctx, view);
    }

    private Controller doCreate(String configID, boolean viewRequired) {
        String instanceId = Library._generateId();
        BundleContext ctx = this.createBundleContext(instanceId);
        if (configID != null) {
            BundleConfigurationImpl configuration = (BundleConfigurationImpl)this._configurations.configuration(configID);
            if (configuration == null) {
                Library.logError(204, configID);
                return null;
            }
            JSONObject configJSON = configuration.json();
            ((GenericMetadataImpl)ctx._metadata).populate(configJSON);
            if (viewRequired) {
                ctx._metadata.configure(configJSON);
            }
            ((PreviewsMetadataImpl)ctx._previewsMeta).populate(configJSON);
            ((GenericMetadataImpl)ctx._metadata).setMessages(this._messages);
            ctx.datamodels.configure(configJSON);
            ctx.properties.configure(configJSON);
            ctx.propertyPresentations.configure(configJSON);
            ctx.actions.configure(configJSON);
            this.validatePresentations(ctx);
        }
        AbstractView view = viewRequired ? this.createView(ctx) : null;
        return this.createController(this.getName(), ctx, view);
    }

    private void validatePresentations(BundleContext ctx) {
        ArrayEx<PropertyPresentationMeta> presentations = ctx.propertyPresentations.meta();
        for (PropertyPresentationMeta p : presentations) {
            ((PropertyPresentationMetaImpl)p).validateProperties(ctx.properties);
        }
    }

    private Messages getMessageCatalog() {
        Messages catalog = this._messages.get(this._locale);
        if (catalog == null) {
            catalog = this._messages.get(DEFAULT_LOCALE);
        }
        return catalog;
    }

    private BundleContext createBundleContext(String instanceId) {
        BundleContext ctx = new BundleContext(instanceId, this._messages, this._dataModels.copy(), this._metadata.copy(), this._previewsMeta.copy());
        for (PropertyPresentationMeta property : this._propertyPresentations) {
            ctx.propertyPresentations.put(((PropertyPresentationMetaImpl)property).copy());
        }
        ctx.actions.populate(this._actions);
        ctx.properties.populate(this._properties);
        return ctx;
    }

    private void parseActions(JSONArray list) {
        for (int i = 0; i < list.size(); ++i) {
            ActionMeta a = ActionMeta.parse((JSONObject)list.get(i), this._messages);
            this._actions.add((Object)a);
        }
    }

    private void parsePropertyPresentations(JSONArray list) {
        for (int i = 0; i < list.size(); ++i) {
            PropertyPresentationMetaImpl PP = new PropertyPresentationMetaImpl(this._messages);
            this._propertyPresentations.add((Object)PP.parse((JSONObject)list.get(i)));
        }
    }

    public void initialize(JSONObject config) {
        String build;
        JSONArray resourceArray;
        if (config == null) {
            return;
        }
        this._metadata.populate(config);
        this._metadata.setMessages(this._messages);
        this._previewsMeta.populate(config);
        this._dataModels.populate(config, this._messages);
        JSONObject resourceObject = (JSONObject)config.get((Object)"properties");
        if (resourceObject != null) {
            PropertyProcessingInfo info = PropertyProcessor.processProperties(resourceObject, this._messages, false);
            for (PropertyMeta p : info.properties) {
                this._properties.add((Object)p);
            }
        }
        if ((resourceArray = (JSONArray)config.get((Object)"propertyPresentations")) != null) {
            this.parsePropertyPresentations(resourceArray);
        }
        if ((resourceArray = (JSONArray)config.get((Object)"actions")) != null) {
            this.parseActions(resourceArray);
        }
        if ((resourceArray = (JSONArray)config.get((Object)"colorpalettes")) != null) {
            Library.palettes.addPalettes(resourceArray);
        }
        this._configurations.populate(config, this._messages);
        this._properties = PropertySet.merge(this._properties);
        String version = ObjectConverter.toString((Object)config.get((Object)"version"));
        if (version != null) {
            this._version = ObjectConverter.toString((Object)version);
        }
        if ((build = ObjectConverter.toString((Object)config.get((Object)"build"))) != null) {
            this._build = ObjectConverter.toString((Object)build);
        }
    }

    public void setMessageCatalog(String locale, JSONObject catalog) {
        Messages message = Messages.createFromCatalog(catalog, locale);
        this._messages.add(locale, message);
    }
}

