/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.framework.internal;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.nativeImpl.xhr.Xhr;
import com.ibm.rave.core.nativeImpl.xhr.XhrResult;
import com.ibm.rave.core.scene.ImageCreatedCallback;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.transition.TransitionCollector;
import com.ibm.rave.library.action.Action;
import com.ibm.rave.library.datamodel.DataModel;
import com.ibm.rave.library.datamodel.DataModelDescriptor;
import com.ibm.rave.library.datamodel.internal.DataModelImpl;
import com.ibm.rave.library.framework.BundleInfo;
import com.ibm.rave.library.framework.ComponentCallback;
import com.ibm.rave.library.framework.Controller;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.CustomFormatter;
import com.ibm.rave.library.framework.RenderCompleteCallback;
import com.ibm.rave.library.framework.internal.AbstractView;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.TransitionsCompleteMonitor;
import com.ibm.rave.library.framework.meta.ActionMeta;
import com.ibm.rave.library.framework.meta.GenericMetadata;
import com.ibm.rave.library.framework.meta.PreviewsMetadata;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.framework.meta.PropertyPresentationMeta;
import com.ibm.rave.library.i18n.Messages;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.internal.nativeImpl.LoaderNativeUtils;
import com.ibm.rave.library.property.Property;
import com.ibm.rave.library.service.LibraryError;
import java.util.List;

public class AbstractController
implements Controller {
    private static final double DEFAULT_SIZE_WIDTH = 400.0;
    private static final double DEFAULT_SIZE_HEIGHT = 400.0;
    private final String _bundleName;
    protected final BundleContext _context;
    protected final AbstractView _view;
    private final BundleInfo _info;
    private MessagesRegistry _messages;
    private LibraryError.ReportError _errorReporter;
    private final LibraryError.ReportError reportError;
    private final List<TransitionsCompleteMonitor> transitionCompleteMonitors = new ArrayEx();
    private boolean localeSet = false;
    private Xhr<JSONArtifact> messageXhr;

    public AbstractController(String bundleName, BundleContext ctx, AbstractView view) {
        final AbstractController self = this;
        this.reportError = new LibraryError.ReportError(){

            @Override
            public void error(LibraryError liberror) {
                liberror.setBundlename(self._bundleName);
                if (self._errorReporter != null) {
                    self._errorReporter.error(liberror);
                }
            }
        };
        this._bundleName = bundleName;
        this._context = ctx;
        this._messages = ctx._messages;
        this._info = new BundleInfo(){

            @Override
            public GenericMetadata meta() {
                return self._context._metadata;
            }

            @Override
            public ArrayEx<PropertyMeta> properties() {
                return self._context.properties.meta();
            }

            @Override
            public ArrayEx<PropertyPresentationMeta> propertyPresentations() {
                return self._context.propertyPresentations.meta();
            }

            @Override
            public ArrayEx<ActionMeta> actions() {
                return self._context.actions.meta();
            }

            @Override
            public ArrayEx<DataModelDescriptor> dataModels() {
                return self._context.datamodels.getDataModels();
            }

            @Override
            public String getPreview(String format, ArrayEx<String> tags) {
                return self._context._previewsMeta.getPreview(format, tags);
            }

            @Override
            public ArrayEx<String> getPreviewTags() {
                return self._context._previewsMeta.getAllTags();
            }

            @Override
            public ArrayEx<String> getPreviews(String format) {
                return self._context._previewsMeta.getPreviews(format);
            }

            @Override
            public String getPreview(String format) {
                return self._context._previewsMeta.getPreview(format, null);
            }

            @Override
            public String getPreview() {
                return self._context._previewsMeta.getPreview("svg", null);
            }

            @Override
            public ArrayEx<String> getPreviews() {
                return self._context._previewsMeta.getPreviews("svg");
            }

            @Override
            public PreviewsMetadata previews() {
                return self._context._previewsMeta;
            }
        };
        this._view = view;
        if (this._view != null) {
            this._view.setup();
        }
    }

    @Override
    public void render() {
        this.render(null);
    }

    @Override
    public void render(final RenderCompleteCallback callback) {
        this.updateContextSize();
        if (this._view != null) {
            DataModelImpl dataModel = (DataModelImpl)this._context.datamodels.dataModel();
            if (dataModel.dataUpdated()) {
                this._view.reset();
                dataModel.dataUpdated(false);
            }
            if (callback == null) {
                this._view.draw();
            } else {
                TransitionCollector.startCollectingTransitions();
                this._view.draw();
                List transitions = TransitionCollector.stopCollectingTransitions();
                if (transitions.size() == 0) {
                    callback.renderComplete();
                } else {
                    final AbstractController self = this;
                    TransitionsCompleteMonitor.TransitionsCompleteCallback tcc = new TransitionsCompleteMonitor.TransitionsCompleteCallback(){

                        @Override
                        public void transtionsComplete(TransitionsCompleteMonitor tcm) {
                            int i = self.transitionCompleteMonitors.indexOf(tcm);
                            if (i >= 0) {
                                self.transitionCompleteMonitors.remove(i);
                            }
                            callback.renderComplete();
                        }
                    };
                    TransitionsCompleteMonitor m = new TransitionsCompleteMonitor(tcc);
                    this.transitionCompleteMonitors.add(m);
                    m.monitor(transitions);
                }
            }
        }
        this.updateActionBindings();
    }

    @Override
    public final BundleInfo info() {
        return this._info;
    }

    @Override
    public final Action action(String id) {
        return this._context.actions.action(id);
    }

    @Override
    public ArrayEx<DataModelDescriptor> getDataModels() {
        return this._context.datamodels.getDataModels();
    }

    @Override
    public DataModel createDataModel(String modelId) {
        this._view.reset();
        return this._context.datamodels.createDataModel(modelId);
    }

    @Override
    public DataModel dataModel() {
        return this._context.datamodels.dataModel();
    }

    @Override
    public Controller node(Selector svg) {
        this._context.node = svg;
        return this;
    }

    @Override
    public void setMessageCatalog(String locale, JSONObject catalog) {
        Messages message = Messages.createFromCatalog(catalog, locale);
        this._messages.add(locale, message);
    }

    @Override
    public boolean setLocale(final String locale, String url, final Controller.Callback userCallback) {
        final AbstractController self = this;
        String path = LoaderNativeUtils.getMessagesPath(locale, url);
        if (self._messages.locale(locale)) {
            if (userCallback != null) {
                userCallback.callback();
            }
            return true;
        }
        self.messageXhr = Rave.json.create(path, (Xhr.Callback)new Xhr.Callback<JSONArtifact>(){

            public void callback(XhrResult error, JSONArtifact response) {
                if (error == null) {
                    self.setMessageCatalog(locale, (JSONObject)response);
                    self.localeSet = self._messages.locale(locale);
                    if (userCallback != null) {
                        userCallback.callback();
                    }
                }
            }
        });
        return this.localeSet;
    }

    @Override
    public Selector node() {
        return this._context.node;
    }

    @Override
    public Controller property(String id, Object value) {
        Property p = this._context.properties.property(id);
        if (p == null) {
            this.reportError.error(LibraryError.create(32, id, this._bundleName));
        } else {
            p.value(value);
            this._view.checkUpdate(id);
        }
        return this;
    }

    @Override
    public Object property(String id) {
        Property prop = this._context.properties.property(id);
        if (prop != null) {
            return prop.value();
        }
        return null;
    }

    @Override
    public void setCustomFormatter(String target, CustomFormatter formatter) {
        this._context.addCustomFormatter(target, formatter);
        this._view.resetRedraw();
    }

    @Override
    public OMap<String, CustomFormatter> getCustomFormatters() {
        return this._context.getCustomFormatters();
    }

    @Override
    public void removeCustomFormatter(String target) {
        this._context.removeCustomFormatter(target);
        this._view.resetRedraw();
    }

    private void updateContextSize() {
        String _w = ObjectConverter.toString((Object)this._context.node.style("width")).replace("px", "");
        String _h = ObjectConverter.toString((Object)this._context.node.style("height")).replace("px", "");
        double w = ObjectConverter.toDouble((Object)_w);
        double h = ObjectConverter.toDouble((Object)_h);
        if (ObjectConverter.isNaN((Object)w)) {
            w = 400.0;
        }
        if (ObjectConverter.isNaN((Object)h)) {
            h = 400.0;
        }
        if (this._context.size.w != w || this._context.size.h != h) {
            this.node().attr("__rave_resize__", (Object)true).attr("__rave_resize__", null);
            this._view.resetLayout();
        }
        this._context.size.w = w;
        this._context.size.h = h;
    }

    private void updateActionBindings() {
        this._context.actions.applyBindings();
    }

    @Override
    public void onError(LibraryError.ReportError errorReport) {
        this._errorReporter = errorReport;
    }

    public LibraryError.ReportError errorReporter() {
        return this.reportError;
    }

    public String locale() {
        return this._context.locale();
    }

    @Override
    public void preExecuteCallback(ComponentCallback callback) {
        this._context.setPreExecute(callback);
    }

    @Override
    public void preRenderCallback(Controller.Callback callback) {
        this._context.setPrerenderCallback(callback);
    }

    @Override
    public void renderCallback(RunFunction<Selection<?>> callback) {
        this._context.setRenderCallback(callback);
    }

    @Override
    public void postRenderCallback(Controller.Callback callback) {
        this._context.setPostrenderCallback(callback);
    }

    @Override
    public void getSVGImage(ImageCreatedCallback callback) {
        Rave.getSVGImage((SceneNode)this._context.node.node(), (ImageCreatedCallback)callback);
    }

    @Override
    public CoordinateScale getCoordinateScale(String role) {
        return this._view != null ? this._view.getCoordinateScale(role) : null;
    }

    @Override
    public void dispose() {
        if (this._context.node != null) {
            this._context.node.selectAll("*").interrupt().transition();
        }
        if (this._view != null) {
            this._view.dispose();
        }
    }

    @Override
    public Controller on(String eventName, Controller.BundleEventCallback callback) {
        if (this._view != null) {
            this._view.on(eventName, callback);
        }
        return this;
    }
}

