/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.framework.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.svg.SymbolCreator;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.action.internal.OperationsUtil;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.Controller;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.BundleDatum;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import com.ibm.rave.library.palette.internal.ContinuousPalette;
import com.ibm.rave.library.property.Property;
import java.util.List;

public abstract class AbstractView {
    @InlineStringConstant
    public static final String VIZLIBRARY_CLASS = "vizlibrary";
    @InlineStringConstant
    public static final String ELEMENT_GROUP_CLASS = "element-group";
    @InlineStringConstant
    public static final String BUNDLE_SHAPE_CLASS = "bundle-shape";
    @InlineStringConstant
    public static final String ELEMENT_SHAPE_CLASS = "element-shape";
    @InlineStringConstant
    public static final String ELEMENT_LABEL_CLASS = "element-label";
    @InlineStringConstant
    public static final String ELEMENT_CLASS = "element";
    @InlineStringConstant
    public static final String ELEMENT_LINE_CLASS = "element-line";
    @InlineStringConstant
    public static final String DIM_CLASS = "dim";
    @InlineStringConstant
    protected static final String LEGENDLINESYMBOL = "compositeViewLegendLineSymbol";
    @InlineStringConstant
    private static final String RESET_DATA = "data";
    @InlineStringConstant
    private static final String RESET_LAYOUT = "layout";
    @InlineStringConstant
    private static final String RESET_ZOOM = "zoom";
    public final BundleContext context;
    @InlineStringConstant
    public static final String CLIP_VIEWPORT_NAME = "clipViewport";
    protected static final int UPDATE_RESET_DATA = 0;
    protected static final int UPDATE_RESET_LAYOUT = 1;
    protected static final int UPDATE_ZOOM = 2;
    protected static final int UPDATE_REDRAW = 3;
    protected static final int UPDATE_NOTHING = 4;
    protected int updateType = 0;
    @InlineStringConstant
    protected static final String HIGHLIGHT_ACTION_NAME = "highlight";
    @InlineStringConstant
    protected static final String UNHIGHLIGHT_ACTION_NAME = "unhighlight";
    @InlineStringConstant
    protected static final String TRANSITION_NAME = "transition";
    protected static final Object[] ONEDATA = new Object[]{new Double(0.0)};

    protected AbstractView(BundleContext context) {
        this.context = context;
    }

    public void setup() {
    }

    public void dispose() {
    }

    public abstract void draw();

    public CoordinateScale getCoordinateScale(String role) {
        return null;
    }

    public static final void createGroupStructure(Selector node, String[] list) {
        AbstractView.createGroupStructureRecursive(node, list, new int[]{0});
    }

    private static void createGroupStructureRecursive(Selector node, String[] list, int[] index) {
        Selector last = node;
        while (index[0] < list.length) {
            String type;
            int n = index[0];
            index[0] = n + 1;
            String cs = list[n];
            if (cs == null) continue;
            if ("(".equals(cs)) {
                AbstractView.createGroupStructureRecursive(last, list, index);
                continue;
            }
            if (")".equals(cs)) {
                return;
            }
            String id = null;
            int p = cs.indexOf("#");
            if (p >= 0) {
                id = cs.substring(p + 1);
                if ("".equals(id)) {
                    id = null;
                }
                cs = cs.substring(0, p);
            }
            String classnames = null;
            p = cs.indexOf(".");
            if (p >= 0) {
                classnames = cs.substring(p + 1);
                if ("".equals(classnames)) {
                    classnames = null;
                }
                cs = cs.substring(0, p);
            }
            if ("".equals(type = cs)) {
                type = "g";
            }
            Selector s = classnames == null ? node.selectAll(type).data(ONEDATA).enter().append(type) : node.selectAll(type + "." + classnames.replaceAll(" ", ".")).data(ONEDATA).enter().append(type).attr("class", (Object)classnames);
            if (id != null) {
                s.attr("id", (Object)id);
            }
            last = s;
        }
    }

    protected static Palette getPalette(String paletteID, ArrayEx<String> fills) {
        Palette colorPalette = AbstractView.getFillPalette(fills);
        if (colorPalette != null) {
            return colorPalette;
        }
        colorPalette = Library.palettes.getPalette(paletteID);
        if (colorPalette != null) {
            return colorPalette;
        }
        return Library.palettes.getDefaultPalette();
    }

    protected static Palette getFillPalette(ArrayEx<String> fills) {
        if (fills == null || fills.size() < 2) {
            return null;
        }
        for (String s : fills) {
            if (s != null && !"".equals(s)) continue;
            return null;
        }
        JSONObject paletteJSON = new JSONObject();
        paletteJSON.put((Object)"fillType", (Object)"continuous");
        paletteJSON.put((Object)"valueType", (Object)"normalized");
        int nfills = fills.size();
        JSONArray fillsJSON = new JSONArray();
        for (int i = 0; i < nfills; ++i) {
            JSONObject stop = new JSONObject();
            stop.put((Object)"at", (Object)((double)i / ((double)nfills - 1.0)));
            stop.put((Object)"fill", fills.get(i));
            fillsJSON.add((Object)stop);
        }
        paletteJSON.put((Object)"fills", (Object)fillsJSON);
        return new ContinuousPalette(paletteJSON);
    }

    protected static final SingleValueFunction<Object, Object> accessorOf(DataSlotEntry entry) {
        return entry != null ? entry.accessor() : null;
    }

    protected static final SingleValueFunction<Object, Object> domainCheckerOf(List<Object> data, DataSlotEntry entry) {
        if (entry == null) {
            return null;
        }
        if ("string".equals(entry.type())) {
            CoordinateScaleImpl scale = ScaleManager.makeCoordinateScale(data, entry);
            if (scale != null) {
                scale.range(1.0, 2.0, null, null);
                final AbstractScale<?, ?> sscale = scale.scale();
                return new SingleValueFunction<Object, Object>(){

                    public Object getValue(Object d) {
                        return sscale.getValue(null, d, 0, 0);
                    }
                };
            }
            return null;
        }
        return null;
    }

    public String message(String key, String alt) {
        return this.context.message(key, alt);
    }

    protected static void registerBundleSymbols() {
        Rave.svg.symbolCreator(LEGENDLINESYMBOL, new SymbolCreator(){

            public String create(double size) {
                double len = Math.sqrt(size) / 2.0;
                double l3 = len / 3.0;
                return "M" + -len + "," + len + "L" + -l3 + "," + (-l3 + 1.5) + " " + l3 + "," + (l3 + 1.5) + " " + len + "," + (-len + 3.0) + " " + len + "," + -len + " " + l3 + "," + (l3 - 1.5) + " " + -l3 + "," + (-l3 - 1.15) + " " + -len + "," + (len - 3.0) + "Z";
            }
        });
    }

    protected int requireUpdate(String property) {
        if (property.equals("axis.x.title.text") && this.isInvisible("axis.x.title.display")) {
            return 4;
        }
        if (property.equals("axis.y.title.text") && this.isInvisible("axis.y.title.display")) {
            return 4;
        }
        if (property.equals("axis.x.title.style.fill") && this.isInvisible("axis.x.title.display")) {
            return 4;
        }
        if (property.equals("axis.y.title.style.fill") && this.isInvisible("axis.y.title.display")) {
            return 4;
        }
        if ((property.equals("axis.y.gridlines.style.stroke") || property.equals("axis.y.gridlines.style.stroke-dasharray")) && this.isInvisible("axis.y.gridlines.display")) {
            return 4;
        }
        if ((property.equals("axis.x.gridlines.style.stroke") || property.equals("axis.x.gridlines.style.stroke-dasharray")) && this.isInvisible("axis.x.gridlines.display")) {
            return 4;
        }
        if ((property.equals("axis.y2.gridlines.style.stroke") || property.equals("axis.y2.gridlines.style.stroke-dasharray")) && this.isInvisible("axis.y2.gridlines.display")) {
            return 4;
        }
        if (property.equals("legend.position") && this.isInvisible("legend.display")) {
            return 4;
        }
        if (property.equals("legend.title") && this.isInvisible("legend.display")) {
            return 4;
        }
        if (property.equals("effect.duration") || property.equals("effect.name")) {
            return 4;
        }
        if (this.isInvisible("shadow.display") && property.equals("shadow.style")) {
            return 4;
        }
        Property p = this.context.properties.property(property);
        if (p == null) {
            return 4;
        }
        String reset = p.meta().resetView();
        if (reset.equals(RESET_DATA)) {
            return 0;
        }
        if (reset.equals(RESET_LAYOUT)) {
            return 1;
        }
        return reset.equals(RESET_ZOOM) ? 2 : 3;
    }

    private boolean isInvisible(String id) {
        Object obj = this.context.getPropertyValue(id);
        if (obj != null) {
            return !ObjectConverter.toBoolean((Object)obj);
        }
        return false;
    }

    public void checkUpdate(String id) {
        this.updateType = Math.min(this.updateType, this.requireUpdate(id));
    }

    public void reset() {
        this.updateType = 0;
    }

    public void resetRedraw() {
        this.updateType = 3;
    }

    public void on(String eventName, Controller.BundleEventCallback callback) {
    }

    protected void resetLayout() {
        this.updateType = 1;
    }

    protected void setBorder(String width, String color) {
        String borderWidth = this.context.convertCSSSizeToPixels(this.context.getPropertyValue(width));
        String borderColor = ObjectConverter.asString((Object)this.context.getPropertyValue(color));
        OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)borderWidth);
        style.put((Object)"stroke", (Object)borderColor);
        this.context.actions.action(UNHIGHLIGHT_ACTION_NAME).setOperation(OperationsUtil.unhighlight((OMap<String, Object>)style));
        this.context.actions.action("deselectAll").setOperation(OperationsUtil.deselectAll((OMap<String, Object>)style));
        this.context.actions.action("toggleSelect").setOperation(OperationsUtil.toggleSelection((OMap<String, Object>)style));
    }

    protected static final SingleValueFunction<Object, Object> originalDatumAccessor(final SingleValueFunction<Object, Object> accessor) {
        return accessor != null ? new SingleValueFunction<Object, Object>(){

            public Object getValue(Object datum) {
                Object d = datum != null ? ((BundleDatum)datum).originalData() : null;
                return d != null ? accessor.getValue(d) : null;
            }
        } : null;
    }
}

