/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.framework.internal;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.library.action.internal.ActionsManager;
import com.ibm.rave.library.datamodel.DataModel;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.datamodel.internal.BundleDataModels;
import com.ibm.rave.library.framework.ComponentCallback;
import com.ibm.rave.library.framework.Controller;
import com.ibm.rave.library.framework.CustomFormatInfo;
import com.ibm.rave.library.framework.CustomFormatter;
import com.ibm.rave.library.framework.internal.CSSConverter;
import com.ibm.rave.library.framework.internal.ContextSize;
import com.ibm.rave.library.framework.internal.CustomFormatInfoImpl;
import com.ibm.rave.library.framework.meta.GenericMetadata;
import com.ibm.rave.library.framework.meta.PreviewsMetadata;
import com.ibm.rave.library.framework.meta.internal.PropertyPresentationManager;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.property.Property;
import com.ibm.rave.library.property.PropertySet;

public final class BundleContext {
    public final GenericMetadata _metadata;
    public final PreviewsMetadata _previewsMeta;
    public final PropertySet properties = new PropertySet();
    public final ActionsManager actions = new ActionsManager();
    public final BundleDataModels datamodels;
    public final PropertyPresentationManager propertyPresentations;
    public final ContextSize size = new ContextSize();
    public Selector node = Rave.selection();
    private OMap<String, CustomFormatter> _customFormatters = new OMap();
    public final MessagesRegistry _messages;
    private ComponentCallback _preExecuteCallback;
    private Controller.Callback _prerenderCallback;
    private RunFunction<Selection<?>> _renderCallback;
    private Controller.Callback _postrenderCallback;
    private final String _instanceId;

    public BundleContext(String instanceId, MessagesRegistry messages, BundleDataModels dataModels, GenericMetadata metaData, PreviewsMetadata previews) {
        this._instanceId = instanceId;
        this._messages = messages;
        this._metadata = metaData;
        this._previewsMeta = previews;
        this.datamodels = dataModels;
        this.propertyPresentations = new PropertyPresentationManager(this._messages);
    }

    public final DataModel getInputDataModel(String modelId) {
        return this.datamodels.createDataModel(modelId);
    }

    public final DataModel dataModel() {
        return this.datamodels.dataModel();
    }

    public Object getPropertyValue(String id) {
        Property prop = this.properties.property(id);
        if (prop != null) {
            return prop.value();
        }
        return null;
    }

    public Object getPropertyDefault(String id) {
        Property prop = this.properties.property(id);
        if (prop != null) {
            return prop.meta().defaultValue();
        }
        return null;
    }

    protected void addCustomFormatter(String target, CustomFormatter formatter) {
        if (formatter == null) {
            this._customFormatters.remove((Object)target);
        } else {
            this._customFormatters.put((Object)target, (Object)formatter);
        }
    }

    public OMap<String, CustomFormatter> getCustomFormatters() {
        return this._customFormatters;
    }

    protected void removeCustomFormatter(String target) {
        if ("all".equals(target)) {
            this._customFormatters = new OMap();
        } else {
            this._customFormatters.remove((Object)target);
        }
    }

    public static CustomFormatInfo makeCustomFormatInfo(String type, String role, String format, ArrayEx<DataSlotEntry> entries) {
        return new CustomFormatInfoImpl(type, role, format, entries);
    }

    public ValueFunction<Object, String> getCustomFormatterWithFlag(String[] targets, final CustomFormatInfo info, ValueFunction<Object, String> defaultFunction, final boolean simplified) {
        for (String s : targets) {
            final CustomFormatter f = (CustomFormatter)this._customFormatters.get((Object)s);
            if (f == null) continue;
            return new ValueFunction<Object, String>(){

                @SwiftMethodOverload(skipParameters={1})
                public String getValue(Object context, Object value, int index, int groupIndex) {
                    return f.getValue(context, value, index, groupIndex, info, simplified);
                }
            };
        }
        return defaultFunction;
    }

    public ValueFunction<Object, String> getCustomFormatterForElementLabels(DataSlotEntry entry) {
        return this.getCustomFormatterForElementLabels(entry, "ROLE_NONE");
    }

    public ValueFunction<Object, String> getCustomFormatterForElementLabels(DataSlotEntry entry, String role) {
        return this.getCustomFormatterWithFlag(new String[]{"label", "all"}, CustomFormatInfoImpl.makeForEntry("element-label", role, "none", entry), null, false);
    }

    public String message(String key, String alt) {
        return this._messages._nls(key, alt);
    }

    public String instanceId() {
        return this._instanceId;
    }

    public String locale() {
        return this._messages.locale();
    }

    public final void setPreExecute(ComponentCallback callback) {
        this._preExecuteCallback = callback;
    }

    public final ComponentCallback getPreExecute() {
        return this._preExecuteCallback;
    }

    public final void setPrerenderCallback(Controller.Callback callback) {
        this._prerenderCallback = callback;
    }

    public final Controller.Callback getPrerenderCallback() {
        return this._prerenderCallback;
    }

    public final void setRenderCallback(RunFunction<Selection<?>> callback) {
        this._renderCallback = callback;
    }

    public final RunFunction<Selection<?>> getRenderCallback() {
        return this._renderCallback;
    }

    public final void setPostrenderCallback(Controller.Callback callback) {
        this._postrenderCallback = callback;
    }

    public final Controller.Callback getPostrenderCallback() {
        return this._postrenderCallback;
    }

    public final String convertCSSSizeToPixels(Object value) {
        return CSSConverter.convertCSSSizeToPixel(value, 100.0, 10.0);
    }

    public final String getDataSlotLabel(String propertyId, DataSlotEntry entry) {
        return this.getDataSlotLabel(propertyId, (ArrayEx<DataSlotEntry>)new ArrayEx((Object[])new DataSlotEntry[]{entry}));
    }

    public final String getDataSlotLabel(String propertyId, ArrayEx<DataSlotEntry> entries) {
        String label = ObjectConverter.asString((Object)this.getPropertyValue(propertyId));
        if (!ObjectConverter.toBoolean((Object)label) && entries != null && entries.size() > 0) {
            String entryLabel = null;
            for (int i = 0; entryLabel == null && i < entries.size(); ++i) {
                DataSlotEntry e = (DataSlotEntry)entries.get(i);
                if (e == null || !ObjectConverter.toBoolean((Object)e.label())) continue;
                entryLabel = e.label();
            }
            label = entryLabel;
        }
        return label;
    }
}

