/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.framework.internal;

import com.ibm.rave.core.Rave;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.Symbol;

public class BundleSymbol
implements ValueFunction<Object, String> {
    private final Symbol _symbol = Rave.svg.symbol();
    private static final double SQRT3 = Math.sqrt(3.0);

    public String getValue(Object context, Object data, int index, int groupIndex) {
        String type = (String)this._symbol.type().getValue(context, data, index, groupIndex);
        if ("rectangle".equals(type) || "horizontal-rectangle".equals(type) || "vertical-rectangle".equals(type)) {
            double h;
            double w;
            double size = ObjectConverter.toDouble((Object)this._symbol.size().getValue(context, data, index, groupIndex));
            double r = Math.sqrt(size / 2.0) / 2.0;
            if ("vertical-rectangle".equals(type)) {
                w = r;
                h = 2.0 * r;
            } else {
                w = 2.0 * r;
                h = r;
            }
            return "M" + -w + "," + -h + "H" + w + "V" + h + "H" + -w + "Z";
        }
        if ("triangle-left".equals(type) || "triangle-right".equals(type)) {
            double size = ObjectConverter.toDouble((Object)this._symbol.size().getValue(context, data, index, groupIndex));
            double ry = Math.sqrt(size / SQRT3);
            double rx = ry * SQRT3 / 2.0;
            if ("triangle-right".equals(type)) {
                rx = -rx;
                ry = -ry;
            }
            return "M" + -rx + ",0L" + rx + "," + -ry + " " + rx + "," + ry + "Z";
        }
        return this._symbol.getValue(context, data, index, groupIndex);
    }

    public final ValueFunction<Object, String> type() {
        return this._symbol.type();
    }

    public final BundleSymbol type(ValueFunction<Object, String> type) {
        this._symbol.type(type);
        return this;
    }

    public final BundleSymbol type(String type) {
        this._symbol.type(type);
        return this;
    }

    public final ValueFunction<Object, ? extends Number> size() {
        return this._symbol.size();
    }

    public BundleSymbol size(ValueFunction<Object, ? extends Number> size) {
        this._symbol.size(size);
        return this;
    }

    public BundleSymbol size(double size) {
        this._symbol.size(size);
        return this;
    }
}

