/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.framework.internal;

import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.OrdinalScale;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import java.util.ArrayList;
import java.util.List;

public class ClusteredCoordinateScale
extends CoordinateScaleImpl {
    private final ArrayEx<OrdinalScale> _scales = new ArrayEx();
    private double _firstWidth;
    private List<Object> _originalDomain;
    private ValueFunction<Object, String> _originalDomainLabelAccessor;

    public static ClusteredCoordinateScale create(List<List<Object>> domains) {
        return ClusteredCoordinateScale.create(domains, null);
    }

    public static ClusteredCoordinateScale create(List<List<Object>> domains, List<? extends Object> originalDomain) {
        if (domains == null) {
            return null;
        }
        ArrayEx nonNullDomains = new ArrayEx();
        for (List<Object> domain : domains) {
            if (domain == null) continue;
            nonNullDomains.add(domain);
        }
        return nonNullDomains.size() == 0 ? null : new ClusteredCoordinateScale((List<List<Object>>)nonNullDomains, originalDomain);
    }

    private ClusteredCoordinateScale(List<List<Object>> domains, List<Object> originalDomain) {
        for (List<Object> domain : domains) {
            this._scales.add((Object)Rave.scale.ordinal().domain(domain));
        }
        this._originalDomain = originalDomain;
        this._firstWidth = 1.0;
    }

    @Override
    public AbstractScale<?, ?> scale() {
        return (AbstractScale)this._scales.get(0);
    }

    @Override
    public boolean isClustered() {
        return true;
    }

    @Override
    public CoordinateScaleImpl range(double v1, double v2, Double padding, Double outerPadding) {
        double width;
        OrdinalScale scale = (OrdinalScale)this._scales.get(0);
        if (ClusteredCoordinateScale.useRounding(v1, v2, scale.domain().size(), padding, outerPadding)) {
            scale.rangeRoundBands((List)new ArrayEx(new Object[]{v1, v2}), padding, outerPadding);
        } else {
            scale.rangeBands((List)new ArrayEx(new Object[]{v1, v2}), padding, outerPadding);
        }
        this._firstWidth = width = ObjectConverter.toDouble((Object)scale.rangeBand.getValue());
        boolean rev = v2 < v1;
        int s = this._scales.size();
        for (int i = 1; i < s; ++i) {
            scale = (OrdinalScale)this._scales.get(i);
            if (ClusteredCoordinateScale.useRounding(0.0, width, scale.domain().size(), padding, outerPadding)) {
                scale.rangeRoundBands((List)(rev ? new ArrayEx(new Object[]{width, 0}) : new ArrayEx(new Object[]{0, width})), padding, outerPadding);
            } else {
                scale.rangeBands((List)(rev ? new ArrayEx(new Object[]{width, 0}) : new ArrayEx(new Object[]{0, width})), padding, outerPadding);
            }
            width = ObjectConverter.toDouble((Object)scale.rangeBand.getValue());
        }
        return this;
    }

    @Override
    public Number center(Object data) {
        return this.getCoord(ClusteredCoordinateScale.toArray(data), 0.5);
    }

    @Override
    public Number lower(Object data) {
        return this.getCoord(ClusteredCoordinateScale.toArray(data), 0.0);
    }

    @Override
    public Number upper(Object data) {
        return this.getCoord(ClusteredCoordinateScale.toArray(data), 1.0);
    }

    private static List<Object> toArray(Object data) {
        ArrayList<Object> arrayData;
        if (!(data instanceof List)) {
            arrayData = new ArrayList<Object>();
            arrayData.add(data);
        } else {
            arrayData = (ArrayList<Object>)data;
        }
        return arrayData;
    }

    private Number getCoord(List<Object> data, double wmult) {
        if (data == null || data.size() == 0) {
            return null;
        }
        OrdinalScale scale = (OrdinalScale)this._scales.get(0);
        double sum = 0.0;
        int l = data.size() < this._scales.size() ? data.size() : this._scales.size();
        double zoomFactor = ObjectConverter.toDouble((Object)((OrdinalScale)this._scales.get((int)0)).rangeBand.getValue()) / this._firstWidth;
        for (int i = 0; i < l; ++i) {
            Number v;
            scale = (OrdinalScale)this._scales.get(i);
            Number number = v = scale.getValue(null, data.get(i), 0, 0) != null ? (Number)ObjectConverter.toDouble((Object)scale.getValue(null, data.get(i), 0, 0)) : (Number)null;
            if (v == null) {
                return v;
            }
            sum += v.doubleValue() * (i == 0 ? 1.0 : zoomFactor);
        }
        return sum += wmult * ObjectConverter.toDouble((Object)scale.rangeBand.getValue()) * (data.size() == 1 ? 1.0 : zoomFactor);
    }

    @Override
    public double width() {
        double v = ObjectConverter.toDouble((Object)((OrdinalScale)this._scales.get((int)(this._scales.size() - 1))).rangeBand.getValue());
        if (this._scales.size() > 1) {
            v *= ObjectConverter.toDouble((Object)((OrdinalScale)this._scales.get((int)0)).rangeBand.getValue()) / this._firstWidth;
        }
        return v;
    }

    @Override
    public List<Object> originalDomain() {
        return this._originalDomain;
    }

    @Override
    public void originalDomainLabelAccessor(ValueFunction<Object, String> accessor) {
        this._originalDomainLabelAccessor = accessor;
    }

    @Override
    public ValueFunction<Object, String> originalDomainLabelAccessor() {
        return this._originalDomainLabelAccessor;
    }
}

