/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.framework.internal;

import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.OrdinalScale;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import java.util.List;

public class OrdinalCoordinateScale
extends CoordinateScaleImpl {
    private final OrdinalScale _scale;
    private double _width = 0.0;
    private boolean _applyWidth = false;
    private List<Object> _originalDomain;
    private ValueFunction<Object, String> _originalDomainLabelAccessor;

    public static OrdinalCoordinateScale create(List<Object> domain, List<? extends Object> originalDomain) {
        return domain != null ? new OrdinalCoordinateScale(domain, originalDomain) : null;
    }

    public static OrdinalCoordinateScale create(List<Object> domain) {
        return domain != null ? new OrdinalCoordinateScale(domain, null) : null;
    }

    private OrdinalCoordinateScale(List<Object> domain, List<Object> originalDomain) {
        this._scale = Rave.scale.ordinal().domain(domain);
        this._originalDomain = originalDomain;
    }

    @Override
    public AbstractScale<?, ?> scale() {
        return this._scale;
    }

    @Override
    public boolean isOrdinal() {
        return true;
    }

    @Override
    public CoordinateScaleImpl range(double v1, double v2, Double padding, Double outerPadding) {
        if (OrdinalCoordinateScale.useRounding(v1, v2, this._scale.domain().size(), padding, outerPadding)) {
            this._scale.rangeRoundBands((List)new ArrayEx(new Object[]{v1, v2}), padding, outerPadding);
        } else {
            this._scale.rangeBands((List)new ArrayEx(new Object[]{v1, v2}), padding, outerPadding);
        }
        return this;
    }

    @Override
    public Number center(Object data) {
        Double v = ObjectConverter.asDouble((Object)this._scale.getValue(null, data, 0, 0));
        if (v != null) {
            return v + ObjectConverter.toDouble((Object)this._scale.rangeBand.getValue()) / 2.0;
        }
        return v;
    }

    @Override
    public Number lower(Object data) {
        Double v;
        Double d = v = this._scale.getValue(null, data, 0, 0) != null ? Double.valueOf(ObjectConverter.toDouble((Object)this._scale.getValue(null, data, 0, 0))) : null;
        if (v != null) {
            if (this._applyWidth && this._width > 0.0) {
                return v + ObjectConverter.toDouble((Object)this._scale.rangeBand.getValue()) / 2.0 - this._width;
            }
            return this._scale.getValue(null, data, 0, 0) != null ? Double.valueOf(ObjectConverter.toDouble((Object)this._scale.getValue(null, data, 0, 0))) : null;
        }
        return v;
    }

    @Override
    public Number upper(Object data) {
        Double v = ObjectConverter.asDouble((Object)this._scale.getValue(null, data, 0, 0));
        if (v != null) {
            if (this._applyWidth && this._width > 0.0) {
                return v + ObjectConverter.toDouble((Object)this._scale.rangeBand.getValue()) / 2.0 + this._width;
            }
            return v + ObjectConverter.toDouble((Object)this._scale.rangeBand.getValue());
        }
        return v;
    }

    @Override
    public double width() {
        if (this._applyWidth && this._width > 0.0) {
            return 2.0 * this._width;
        }
        return ObjectConverter.toDouble((Object)this._scale.rangeBand.getValue());
    }

    @Override
    public void setWidth(double width) {
        this._width = width >= 0.0 ? width / 2.0 : 0.0;
    }

    @Override
    public void applyWidth(boolean apply) {
        this._applyWidth = apply;
    }

    @Override
    public List<Object> originalDomain() {
        return this._originalDomain;
    }

    @Override
    public void originalDomainLabelAccessor(ValueFunction<Object, String> format) {
        this._originalDomainLabelAccessor = format;
    }

    @Override
    public ValueFunction<Object, String> originalDomainLabelAccessor() {
        return this._originalDomainLabelAccessor;
    }
}

