/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.framework.meta;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.i18n.MessagesRegistry;
import java.util.List;

public class ActionMeta {
    private String _id;
    private String _label;
    private String _description;
    private String _icon;
    private ArrayEx<String> _tags;
    private ArrayEx<Object> _options;
    private ArrayEx<BindingMeta> _defaultBindings;
    private ArrayEx<ArgumentsMeta> _args;
    private MessagesRegistry _messages;

    private ActionMeta() {
    }

    public String id() {
        return this._id;
    }

    public String label() {
        return this._messages._nls(this._label, this._label);
    }

    public String description() {
        return this._messages._nls(this._description, this._description);
    }

    public String icon() {
        return this._icon;
    }

    public ArrayEx<String> tags() {
        ArrayEx msgTags = new ArrayEx();
        for (String tag : this._tags) {
            msgTags.add((Object)this._messages._nls(tag, tag));
        }
        return msgTags;
    }

    public ArrayEx<Object> options() {
        return this._options;
    }

    public ArrayEx<BindingMeta> defaultBindings() {
        return this._defaultBindings;
    }

    public static ActionMeta parse(JSONObject action, MessagesRegistry messages) {
        int i;
        ActionMeta a = new ActionMeta();
        JSONArray bindings = (JSONArray)action.get((Object)"binding");
        JSONArray args = (JSONArray)action.get((Object)"args");
        a._id = ObjectConverter.asString((Object)action.get((Object)"id"));
        a._icon = ObjectConverter.asString((Object)action.get((Object)"icon"));
        a._label = ObjectConverter.asString((Object)action.get((Object)"label"));
        a._description = ObjectConverter.asString((Object)action.get((Object)"description"));
        a._tags = ObjectConverter.listToArray((List)((JSONArray)action.get((Object)"tags")));
        a._options = ObjectConverter.listToArray((List)((JSONArray)action.get((Object)"options")));
        a._args = new ArrayEx();
        if (args != null) {
            for (i = 0; i < args.size(); ++i) {
                a._args.add((Object)ArgumentsMeta.parse((JSONObject)args.get(i), messages));
            }
        }
        a._defaultBindings = new ArrayEx();
        if (bindings != null) {
            for (i = 0; i < bindings.size(); ++i) {
                a._defaultBindings.add((Object)BindingMeta.parse((JSONObject)bindings.get(i)));
            }
        }
        a._messages = messages;
        return a;
    }

    private static class ArgumentsMeta {
        private String _id;
        private String _label;
        private String _description;
        private String _icon;
        private ArrayEx<String> _tags;
        private String _type;
        private MessagesRegistry _messages;

        private ArgumentsMeta() {
        }

        public String id() {
            return this._id;
        }

        public String label() {
            return this._messages._nls(this._label, this._label);
        }

        public String description() {
            return this._messages._nls(this._description, this._description);
        }

        public String icon() {
            return this._icon;
        }

        public ArrayEx<String> tags() {
            ArrayEx msgTags = new ArrayEx();
            for (String tag : this._tags) {
                msgTags.add((Object)this._messages._nls(tag, tag));
            }
            return msgTags;
        }

        public String type() {
            return this._type;
        }

        public static ArgumentsMeta parse(JSONObject args, MessagesRegistry msgs) {
            ArgumentsMeta a = new ArgumentsMeta();
            a._id = ObjectConverter.toString((Object)args.get((Object)"id"));
            a._label = ObjectConverter.toString((Object)args.get((Object)"label"));
            a._description = ObjectConverter.toString((Object)args.get((Object)"description"));
            a._icon = ObjectConverter.toString((Object)args.get((Object)"icon"));
            a._tags = ObjectConverter.listToArray((List)((JSONArray)args.get((Object)"tags")));
            a._type = ObjectConverter.toString((Object)args.get((Object)"type"));
            a._messages = msgs;
            return a;
        }
    }

    public static class BindingMeta {
        private String _target;
        private String _event;

        private BindingMeta() {
        }

        public String target() {
            return this._target;
        }

        public String event() {
            return this._event;
        }

        public static BindingMeta parse(JSONObject binding) {
            BindingMeta b = new BindingMeta();
            b._target = ObjectConverter.toString((Object)binding.get((Object)"target"));
            b._event = ObjectConverter.toString((Object)binding.get((Object)"event"));
            return b;
        }
    }
}

