/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.framework.meta.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.framework.meta.GenericMetadata;
import com.ibm.rave.library.i18n.MessagesRegistry;
import java.util.List;

public class GenericMetadataImpl
implements GenericMetadata {
    @InlineStringConstant
    public static final String GENERIC_META = "genericMeta";
    @InlineStringConstant
    public static final String ID = "id";
    @InlineStringConstant
    public static final String NAME = "name";
    @InlineStringConstant
    public static final String LABEL = "label";
    @InlineStringConstant
    public static final String DESCRIPTION = "description";
    private ES6Map<String, String> metadataInfo = ES6Map.create();
    private ArrayEx<String> metadataTags = new ArrayEx();
    private MessagesRegistry _messages;

    @Override
    public String[] ids() {
        List keys = this.metadataInfo.keys();
        String[] keyArray = keys.toArray(new String[keys.size()]);
        for (int i = 0; i < keyArray.length; ++i) {
            keyArray[i] = this._messages._nls(keyArray[i], keyArray[i]);
        }
        return keyArray;
    }

    @Override
    public final String id(String id) {
        String str = (String)this.metadataInfo.get((Object)id);
        if (NAME.equals(id) || LABEL.equals(id) || DESCRIPTION.equals(id)) {
            str = this._messages._nls(str, str);
        }
        return str;
    }

    @Override
    public final ArrayEx<String> tags() {
        ArrayEx newTags = new ArrayEx();
        for (String tag : this.metadataTags) {
            newTags.add((Object)this._messages._nls(tag, tag));
        }
        return newTags;
    }

    public final void populate(JSONObject o) {
        this.process(o, true);
    }

    @Override
    public final void configure(JSONObject o) {
        this.process(o, false);
    }

    public final void setMessages(MessagesRegistry messages) {
        this._messages = messages;
    }

    public final MessagesRegistry getMessages() {
        return this._messages;
    }

    private final void process(JSONObject o, boolean isPopulate) {
        JSONObject genericMeta = (JSONObject)o.get((Object)GENERIC_META);
        if (genericMeta != null) {
            for (Object k : genericMeta.keySet()) {
                Object v;
                String key = ObjectConverter.asString(k);
                if (key.equals("tags")) {
                    JSONArray tagsArray = (JSONArray)genericMeta.get((Object)key);
                    if (tagsArray == null) continue;
                    int l = tagsArray.size();
                    for (int i = 0; i < l; ++i) {
                        String tag = ObjectConverter.toString((Object)tagsArray.get(i));
                        if (this.metadataTags.contains((Object)tag)) continue;
                        this.metadataTags.add((Object)tag);
                    }
                    continue;
                }
                if (!isPopulate && ID.equals(key) || (v = genericMeta.get((Object)key)) == null) continue;
                this.metadataInfo.set((Object)key, (Object)ObjectConverter.toString((Object)v));
            }
        }
    }

    public GenericMetadataImpl copy() {
        GenericMetadataImpl c = new GenericMetadataImpl();
        for (String key : this.metadataInfo.keys()) {
            c.metadataInfo.set((Object)key, this.metadataInfo.get((Object)key));
        }
        for (String t : this.metadataTags) {
            c.metadataTags.add((Object)t);
        }
        c.setMessages(this._messages);
        return c;
    }
}

