/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.framework.meta.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.collections.OSet;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.framework.meta.PropertyPresentationMeta;
import com.ibm.rave.library.framework.meta.internal.PropertyPresentationMetaImpl;
import com.ibm.rave.library.i18n.MessagesRegistry;

public class PropertyPresentationManager {
    private final OMap<String, PropertyPresentationMetaImpl> _presentations = new OMap();
    private final OSet<String> _hiddenPresentations = new OSet();
    private ArrayEx<PropertyPresentationMeta> _visiblePresentations = null;
    private MessagesRegistry _messagesRegistry;

    public PropertyPresentationManager(MessagesRegistry registry) {
        this._messagesRegistry = registry;
    }

    public void populate(JSONObject json) {
        Object v = json.get((Object)"propertyPresentations");
        if (v != null) {
            PropertyPresentationMetaImpl ppMeta = new PropertyPresentationMetaImpl(this._messagesRegistry);
            for (Object o : (JSONArray)v) {
                JSONObject pp = (JSONObject)o;
                String id = ObjectConverter.asString((Object)pp.get((Object)"id"));
                if (id == null || this._presentations.containsKey((Object)id)) continue;
                this._presentations.put((Object)id, (Object)ppMeta.parse(pp));
            }
            this._visiblePresentations = null;
        }
    }

    public void configure(JSONObject json) {
        Object v = json.get((Object)"propertyPresentations");
        if (v != null) {
            for (Object o : (JSONArray)v) {
                Boolean hidden;
                JSONObject pp = (JSONObject)o;
                String id = ObjectConverter.asString((Object)pp.get((Object)"id"));
                Boolean bl = hidden = pp.get((Object)"hidden") != null ? Boolean.valueOf(ObjectConverter.toBoolean((Object)pp.get((Object)"hidden"))) : null;
                if (id == null || hidden == null || !hidden.booleanValue()) continue;
                this._hiddenPresentations.add((Object)id);
            }
            this._visiblePresentations = null;
        }
    }

    public ArrayEx<PropertyPresentationMeta> meta() {
        if (this._visiblePresentations == null) {
            this._visiblePresentations = new ArrayEx();
            for (String id : this._presentations.keySet()) {
                if (this._hiddenPresentations.contains((Object)id)) continue;
                this._visiblePresentations.add(this._presentations.get((Object)id));
            }
        }
        return this._visiblePresentations;
    }

    public void put(PropertyPresentationMetaImpl presentation) {
        this._presentations.put((Object)presentation.id(), (Object)presentation);
        this._visiblePresentations = null;
    }
}

