/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.i18n;

import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.library.framework.Bundle;
import com.ibm.rave.library.i18n.Messages;

public class MessagesRegistry {
    private String _locale = Bundle.DEFAULT_LOCALE;
    private Messages _currentMessages = Messages.EMPTY_MESSAGES;
    private final OMap<String, Messages> registry = new OMap();
    private static MessagesRegistry _emptyRegistry;

    public static MessagesRegistry EmptyRegistry() {
        if (_emptyRegistry == null) {
            _emptyRegistry = new MessagesRegistry();
            _emptyRegistry.add("en", Messages.EMPTY_MESSAGES);
        }
        return _emptyRegistry;
    }

    public void add(String locale, Messages catalog) {
        this.registry.put((Object)locale, (Object)catalog);
        if (this._locale.equals(locale)) {
            this._currentMessages = catalog;
        }
    }

    public boolean locale(String locale) {
        Messages current = this.get(locale);
        if (current != null) {
            this._locale = locale;
            this._currentMessages = current;
            return true;
        }
        return false;
    }

    public String locale() {
        return this._locale;
    }

    public Messages get(String locale) {
        return (Messages)this.registry.get((Object)locale);
    }

    public String _nls(String key, String alt) {
        return this._currentMessages._nls(key, alt);
    }
}

