/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

public final class BundleManifest {
    @InlineStringConstant
    private static final String MANIFEST = "manifest";
    @InlineStringConstant
    private static final String PATH = "path";
    @InlineStringConstant
    private static final String ROLE = "role";
    @InlineStringConstant
    private static final String CONFIGURATION = "configuration";
    @InlineStringConstant
    private static final String CSS = "stylesheet";
    @InlineStringConstant
    private static final String PATH_SEPARATOR = "/";
    private final ArrayEx<String> configurationPaths = new ArrayEx();
    private final ArrayEx<JSONObject> configurationResources = new ArrayEx();
    private final ArrayEx<String> stylesheetPaths = new ArrayEx();
    private static final JSONObject EMPTY_OBJECT = new JSONObject();

    BundleManifest() {
    }

    final void define(JSONObject manifest) {
        if (manifest == null) {
            return;
        }
        JSONArray resources = (JSONArray)manifest.get((Object)MANIFEST);
        if (resources != null) {
            int size = resources.size();
            for (int i = 0; i < size; ++i) {
                JSONObject resource = (JSONObject)resources.get(i);
                String path = ObjectConverter.asString((Object)resource.get((Object)PATH));
                if (path == null || path.length() <= 0) continue;
                String role = ObjectConverter.toString((Object)resource.get((Object)ROLE));
                if (CSS.equals(role)) {
                    this.stylesheetPaths.add((Object)path);
                    continue;
                }
                if (!CONFIGURATION.equals(role)) continue;
                this.configurationPaths.add((Object)path);
                this.configurationResources.add((Object)EMPTY_OBJECT);
            }
        }
    }

    final ArrayEx<String> getConfigurationPaths() {
        return this.configurationPaths;
    }

    final void setConfigurationResource(int index, JSONObject resource) {
        if (index >= 0) {
            this.configurationResources.set(index, (Object)(resource != null ? resource : EMPTY_OBJECT));
        }
    }

    public final ArrayEx<JSONObject> getConfigurationResources() {
        return this.configurationResources;
    }

    final ArrayEx<String> getStylesheetPaths() {
        return this.stylesheetPaths;
    }
}

