/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.internal.nativeImpl;

import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArtifact;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.css.RaveCSSEngine;
import com.ibm.rave.library.Library;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class RaveLibraryResourceLoader {
    private final String resourcePath;

    public RaveLibraryResourceLoader(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArtifact requireJSON(String path) {
        JSONArtifact results = null;
        InputStream input = this.getClass().getResourceAsStream(this.getResourcePath(path));
        if (input != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            String line = null;
            StringBuffer output = new StringBuffer();
            try {
                while ((line = reader.readLine()) != null) {
                    output.append(line);
                }
                results = JSON.parse((String)output.toString());
            }
            catch (IOException e) {
                results = null;
                Library.logError(201, "Loading JSON failed:" + e);
            }
            finally {
                try {
                    input.close();
                    reader.close();
                }
                catch (IOException e) {
                    Library.logError(201, "Loading JSON failed:" + e);
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requireCSS(String path) {
        InputStream input = this.getClass().getResourceAsStream(this.getResourcePath(path));
        if (input != null) {
            StringBuffer output = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    output.append(line);
                }
            }
            catch (IOException e) {
                Library.logError(201, "Loading CSS failed:" + e);
            }
            finally {
                try {
                    input.close();
                    reader.close();
                }
                catch (IOException e) {
                    Library.logError(201, "Loading CSS failed:" + e);
                }
            }
            if (Rave.css == null) {
                Rave.css = new RaveCSSEngine();
            }
            Rave.css.importCSS(output.toString());
        }
    }

    private String getResourcePath(String path) {
        if ("./".equals(path.substring(0, 2))) {
            path = path.substring(2);
        } else if ("/".equals(path.substring(0, 1))) {
            path = path.substring(1);
        }
        String combinedResourcePath = this.resourcePath;
        combinedResourcePath = "/".equals(this.resourcePath.substring(this.resourcePath.length() - 1, this.resourcePath.length())) ? combinedResourcePath + path : combinedResourcePath + "/" + path;
        return combinedResourcePath;
    }
}

