/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.palette.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.OrdinalScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlot;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class CategoricalPalette
extends Palette {
    private String invalidDomainEntry = "";
    private final OrdinalScale colors;
    public static final String Type = "categorical";

    public CategoricalPalette(JSONObject jsonPalette) {
        super(jsonPalette);
        this.type = Type;
        this.colors = Rave.scale.ordinal();
        this.addAllColors((JSONArray)jsonPalette.get((Object)"fills"));
    }

    @Override
    public void addColor(Object color) {
        List range = this.colors.range();
        range.add(ObjectConverter.toString((Object)color));
        this.colors.range(range);
    }

    @Override
    public void removeColor(Object color) {
        List range = this.colors.range();
        int index = range.indexOf(ObjectConverter.toString((Object)color));
        if (index != -1) {
            range.remove(index);
        }
        this.colors.range(range);
    }

    @Override
    public void addAllColors(JSONArray colorArray) {
        ArrayEx range = new ArrayEx();
        for (Object color : colorArray) {
            range.add(ObjectConverter.toString(color));
        }
        this.colors.range((List)range);
    }

    @Override
    protected void domain(List<Object> domain) {
        this.colors.domain(domain);
    }

    @Override
    public AbstractScale<Object, Object> getScale() {
        return this.colors;
    }

    @Override
    public final void setData(List<Object> domain, DataSet dataSet, String slot) {
        this.setInvalidDomainEntry(dataSet, slot);
        super.setData(domain, dataSet, slot);
    }

    @Override
    public void setData(DataSet dataSet, String slot) {
        this.setInvalidDomainEntry(dataSet, slot);
        super.setData(dataSet, slot);
    }

    private void setInvalidDomainEntry(DataSet dataSet, String slot) {
        DataSlot dataSlot = dataSet.slot(slot);
        if (dataSlot != null) {
            this.invalidDomainEntry = dataSlot.overrideLabel();
            if (this.invalidDomainEntry == null) {
                this.invalidDomainEntry = dataSlot.descriptor().label();
            }
        } else {
            this.invalidDomainEntry = dataSet.descriptor().label();
        }
    }

    @Override
    protected void invalidateDomain() {
        this.domain((List<Object>)new ArrayEx(new Object[]{this.invalidDomainEntry}));
    }

    @Override
    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
        Object dataValue = this.getDomainValidity() == VALID_DOMAIN ? this.dataAccessor.getValue(data) : (this.getDomainValidity() == INVALID_DOMAIN_NULL ? this.invalidDomainEntry : null);
        return dataValue != null ? this.colors.getValue((Object)context, dataValue, index, groupIndex) : this.nullColor;
    }

    @Override
    protected boolean canHandleDataType(String type) {
        return true;
    }
}

