/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.palette.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class ContinuousPalette
extends Palette {
    @InlineStringConstant
    public static final String CONTINUOUS_TYPE = "continuous";
    @InlineStringConstant
    public static final String DISCRETE_TYPE = "discrete";
    @InlineStringConstant
    private static final String DATATYPE_NUMERIC = "numeric";
    private static final double INVALID_DOMAIN_START = 0.0;
    private static final double INVALID_DOMAIN_MID = 0.5;
    private static final double INVALID_DOMAIN_END = 1.0;
    @InlineStringConstant
    private static final String NORMALIZED_VALUE_TYPE = "normalized";
    @InlineStringConstant
    private static final String ABSOLUTE_VALUE_TYPE = "absolute";
    private final AbstractScale<Object, Object> colorScale;
    private String valueType = "absolute";
    private String fillType = "continuous";
    private double minValue = Double.MAX_VALUE;
    private double maxValue = Double.MIN_VALUE;
    private String upper = null;
    private String lower = null;
    private final List<Object> normalizedValues = new ArrayEx();

    public ContinuousPalette(JSONObject jsonPalette) {
        super(jsonPalette);
        String fType = ObjectConverter.toString((Object)jsonPalette.get((Object)"fillType"));
        if (DISCRETE_TYPE.equals(fType) || CONTINUOUS_TYPE.equals(fType)) {
            this.fillType = fType;
        }
        this.type = this.fillType;
        this.colorScale = DISCRETE_TYPE.equals(this.fillType) ? Rave.scale.threshold() : Rave.scale.linear();
        String vType = ObjectConverter.asString((Object)jsonPalette.get((Object)"valueType"));
        if (vType != null) {
            this.valueType = vType;
        }
        if (this.colorScale != null) {
            this.addAllColors((JSONArray)jsonPalette.get((Object)"fills"));
        }
    }

    public String getValueType() {
        return this.valueType;
    }

    private void setupColorScale(List<Object> domain, List<Object> range) {
        this.colorScale.range(range);
        this.colorScale.domain(domain);
    }

    @Override
    public void addColor(Object color) {
        List domain = this.colorScale.domain();
        List range = this.colorScale.range();
        this.addColorImpl((JSONObject)color, domain, range);
        this.setupColorScale(domain, range);
    }

    private void addColorImpl(JSONObject jsonColor, List<Object> domain, List<Object> range) {
        Object atValue = jsonColor.get((Object)"at");
        if (atValue instanceof String) {
            if ("lower".equals(atValue)) {
                this.lower = ObjectConverter.toString((Object)jsonColor.get((Object)"fill"));
            } else if ("upper".equals(atValue)) {
                this.upper = ObjectConverter.toString((Object)jsonColor.get((Object)"fill"));
            }
        } else {
            Double doubleAtValue = ObjectConverter.toDouble((Object)jsonColor.get((Object)"at"));
            if (this.valueType.equals(ABSOLUTE_VALUE_TYPE)) {
                this.minValue = Math.min(this.minValue, doubleAtValue);
                this.maxValue = Math.max(this.maxValue, doubleAtValue);
                int previousIndex = 0;
                for (Object o : domain) {
                    double domainValue = ObjectConverter.toDouble((Object)o);
                    if (doubleAtValue < domainValue) break;
                    ++previousIndex;
                }
                range.add(previousIndex, jsonColor.get((Object)"fill"));
                domain.add(previousIndex, doubleAtValue);
            } else {
                range.add(jsonColor.get((Object)"fill"));
                domain.add(doubleAtValue);
                this.normalizedValues.add(doubleAtValue);
            }
        }
    }

    @Override
    public void addAllColors(JSONArray colors) {
        ArrayEx domain = new ArrayEx();
        ArrayEx range = new ArrayEx();
        for (Object color : colors) {
            this.addColorImpl((JSONObject)color, (List<Object>)domain, (List<Object>)range);
        }
        this.setupColorScale((List<Object>)domain, (List<Object>)range);
    }

    @Override
    public void removeColor(Object color) {
        List domain = this.colorScale.domain();
        List range = this.colorScale.range();
        JSONObject jsonColor = (JSONObject)color;
        Object atValue = jsonColor.get((Object)"at");
        if ("lower".equals(atValue)) {
            this.lower = null;
        } else if ("upper".equals(atValue)) {
            this.upper = null;
        } else {
            int atIndex;
            if (this.valueType.equals(ABSOLUTE_VALUE_TYPE)) {
                atIndex = domain.indexOf(ObjectConverter.toDouble((Object)atValue));
            } else {
                Double value = ObjectConverter.toDouble((Object)atValue);
                atIndex = domain.indexOf(this.minValue + value * (this.maxValue - this.minValue));
            }
            if (atIndex != -1) {
                domain.remove(atIndex);
                range.remove(atIndex);
                this.minValue = ObjectConverter.toDouble((Object)Rave.min((List)domain));
                this.maxValue = ObjectConverter.toDouble((Object)Rave.max((List)domain));
                this.setupColorScale(domain, range);
            }
        }
    }

    @Override
    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
        Object dataValue;
        Object object = dataValue = this.dataAccessor != null ? this.dataAccessor.getValue(data) : null;
        if (this.getDomainValidity() == INVALID_DOMAIN_NULL) {
            dataValue = 0.5;
        } else if (this.getDomainValidity() == INVALID_DOMAIN_EMPTY) {
            dataValue = null;
        } else if (this.getDomainValidity() == INVALID_DOMAIN_DATATYPE) {
            Object object2 = dataValue = dataValue != null || this.nullColor == null ? Double.valueOf(0.5) : null;
        }
        if (dataValue != null) {
            boolean isContinuous = CONTINUOUS_TYPE.equals(this.fillType);
            double doubleValue = ObjectConverter.toDouble((Object)dataValue);
            if (doubleValue < this.minValue && this.lower != null && isContinuous) {
                return this.lower;
            }
            if (doubleValue > this.maxValue && this.upper != null) {
                return this.upper;
            }
            if (doubleValue >= this.maxValue && !isContinuous) {
                return this.colorScale.range().get(this.colorScale.range().size() - 1);
            }
            if (isContinuous && doubleValue > this.maxValue) {
                return this.colorScale.getValue((Object)context, (Object)this.maxValue, index, groupIndex);
            }
            if (isContinuous && doubleValue < this.minValue) {
                return this.colorScale.getValue((Object)context, (Object)this.minValue, index, groupIndex);
            }
            return this.colorScale.getValue((Object)context, (Object)doubleValue, index, groupIndex);
        }
        return this.nullColor;
    }

    @Override
    protected void domain(List<Object> domain) {
        this.minValue = ObjectConverter.toDouble((Object)Rave.min(domain));
        this.maxValue = ObjectConverter.toDouble((Object)Rave.max(domain));
        if (this.valueType.equals(NORMALIZED_VALUE_TYPE)) {
            ArrayEx dm = new ArrayEx();
            double dmRange = this.maxValue - this.minValue;
            for (int i = 0; i < this.normalizedValues.size(); ++i) {
                double domainValue = ObjectConverter.toDouble((Object)this.normalizedValues.get(i));
                dm.set(i, this.minValue + domainValue * dmRange);
            }
            this.colorScale.domain((List)dm);
        }
    }

    @Override
    public AbstractScale<Object, Object> getScale() {
        return this.colorScale;
    }

    @Override
    protected void invalidateDomain() {
        ArrayEx domain = new ArrayEx();
        domain.add((Object)0.0);
        domain.add((Object)1.0);
        this.domain((List<Object>)domain);
    }

    @Override
    protected boolean canHandleDataType(String type) {
        return DATATYPE_NUMERIC.equals(type);
    }
}

