/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.palette.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.internal.nativeImpl.PropertyNativeUtils;
import com.ibm.rave.library.palette.Palette;
import com.ibm.rave.library.palette.internal.CategoricalPalette;
import com.ibm.rave.library.palette.internal.ConditionalPalette;
import com.ibm.rave.library.palette.internal.ContinuousPalette;
import com.ibm.rave.library.service.LibraryError;

public class PaletteSet {
    private final OMap<String, JSONObject> palettes = new OMap();

    public void populate(JSONArray palettes) {
        if (palettes == null) {
            return;
        }
        for (int i = 0; i < palettes.size(); ++i) {
            JSONObject jsonPalette;
            boolean passed;
            Object obj = palettes.get(i);
            if (!PropertyNativeUtils.isJSONObject(obj) || (passed = this.add(jsonPalette = (JSONObject)obj))) continue;
            return;
        }
    }

    public boolean add(JSONObject palette) {
        String id = ObjectConverter.toString((Object)palette.get((Object)"id"));
        if (id != null && id.length() > 0) {
            this.palettes.put((Object)id, (Object)palette);
            return true;
        }
        Library.logError(5);
        return false;
    }

    public void remove(String paletteId, LibraryError error) {
        if (paletteId != null && paletteId.length() > 0) {
            this.palettes.remove((Object)paletteId);
        } else {
            Library.logError(5, "PaletteSet remove");
        }
    }

    public JSONObject getPaletteJSON(String paletteId) {
        return (JSONObject)this.palettes.get((Object)paletteId);
    }

    public Palette get(String id) {
        JSONObject jsonPalette;
        Palette palette = null;
        if (id != null && (jsonPalette = (JSONObject)this.palettes.get((Object)id)) != null) {
            if ("simple".equals(jsonPalette.get((Object)"fillType"))) {
                palette = new CategoricalPalette(jsonPalette);
            } else if ("continuous".equals(jsonPalette.get((Object)"fillType")) || "discrete".equals(jsonPalette.get((Object)"fillType"))) {
                palette = new ContinuousPalette(jsonPalette);
            } else if ("conditional".equals(jsonPalette.get((Object)"fillType"))) {
                palette = new ConditionalPalette(jsonPalette);
            }
        }
        return palette;
    }

    public ArrayEx<Palette> getAll() {
        ArrayEx paletteArray = new ArrayEx();
        for (String key : this.palettes.keySet()) {
            paletteArray.add((Object)this.get(key));
        }
        return paletteArray;
    }

    public ArrayEx<String> getAllIds() {
        ArrayEx paletteIds = new ArrayEx();
        for (String key : this.palettes.keySet()) {
            paletteIds.add((Object)key);
        }
        return paletteIds;
    }
}

