/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.property;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.internal.nativeImpl.PropertyNativeUtils;
import com.ibm.rave.library.property.Property;
import com.ibm.rave.library.property.PropertyImpl;
import com.ibm.rave.library.property.PropertyObjectType;

public class ObjectPropertyImpl
extends PropertyImpl {
    private OMap<String, Property> _childProperties = new OMap();

    public ObjectPropertyImpl(PropertyObjectType propertyType, PropertyImpl parent) {
        super(propertyType, parent);
        this.buildValue();
    }

    void buildValue() {
        JSONObject defaultValue = (JSONObject)this.meta().defaultValue();
        JSONObject valueInstance = (JSONObject)this.value();
        for (Object propertyId : defaultValue.keySet()) {
            Object def = defaultValue.get(propertyId);
            valueInstance.put(propertyId, def);
        }
    }

    @Override
    public Object reset() {
        for (String propertyId : this._childProperties.keySet()) {
            PropertyImpl childProperty = (PropertyImpl)this._childProperties.get((Object)propertyId);
            childProperty.reset();
        }
        return this.value();
    }

    @Override
    public boolean value(Object obj) {
        boolean result = true;
        OMap childPropertiesOriginalValues = new OMap();
        if (obj == null) {
            for (String propertyId : this._childProperties.keySet()) {
                PropertyImpl childProperty = (PropertyImpl)this._childProperties.get((Object)propertyId);
                childPropertiesOriginalValues.put((Object)propertyId, childProperty.value());
                if (childProperty.value(null)) continue;
                this.rollBackChildPropertiesValues((OMap<String, Object>)childPropertiesOriginalValues);
                result = false;
            }
            return result;
        }
        if (!PropertyNativeUtils.isJSONObject(obj)) {
            Library.logError(31, "Property validate");
            return false;
        }
        JSONObject val = (JSONObject)obj;
        for (Object propertyId : val.keySet()) {
            Object propVal = val.get(propertyId);
            PropertyImpl childProperty = (PropertyImpl)this._childProperties.get((Object)ObjectConverter.toString(propertyId));
            if (childProperty == null) {
                Library.logError(32, "Property validate");
                this.rollBackChildPropertiesValues((OMap<String, Object>)childPropertiesOriginalValues);
                result = false;
                continue;
            }
            childPropertiesOriginalValues.put((Object)ObjectConverter.toString(propertyId), childProperty.value());
            if (childProperty.value(propVal)) continue;
            this.rollBackChildPropertiesValues((OMap<String, Object>)childPropertiesOriginalValues);
            result = false;
        }
        return result;
    }

    private void rollBackChildPropertiesValues(OMap<String, Object> childPropertiesOriginalValues) {
        for (String childId : childPropertiesOriginalValues.keySet()) {
            PropertyImpl childProperty = (PropertyImpl)this._childProperties.get((Object)childId);
            childProperty.value(childPropertiesOriginalValues.get((Object)childId));
        }
    }

    public OMap<String, Property> childProperties() {
        return this._childProperties;
    }
}

