/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.property;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.property.PropertyProcessingInfo;
import com.ibm.rave.library.property.PropertyType;
import com.ibm.rave.library.property.PropertyUtil;
import java.util.List;

public class PropertyArrayType
extends PropertyType<Object> {
    private int _minLen = -1;
    private int _maxLen = -1;
    PropertyType<Object> _items;

    protected PropertyArrayType(String propertyId, String qualifiedId, PropertyType<Object> parent, MessagesRegistry messages) {
        super(propertyId, qualifiedId, parent, messages);
    }

    @Override
    public String type() {
        return "array";
    }

    @Override
    public int typeId() {
        return 20;
    }

    public int minLength() {
        return this._minLen;
    }

    public int maxLength() {
        return this._maxLen;
    }

    public PropertyType<Object> items() {
        return this._items;
    }

    @Override
    public boolean validateValue(Object obj) {
        Integer minNum;
        if (this._items == null) {
            return false;
        }
        if (!PropertyUtil.INSTANCE.validateBasicType(obj, 20)) {
            return false;
        }
        Integer maxNum = this._maxLen != -1 ? Integer.valueOf(this._maxLen) : null;
        Integer n = minNum = this._minLen != -1 ? Integer.valueOf(this._minLen) : null;
        if (!PropertyUtil.INSTANCE.validateMinMaxPropertyValue(minNum, maxNum, false, ((List)obj).size())) {
            return false;
        }
        List list = (List)obj;
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            Object entry = list.get(i);
            if (this._items.validateValue(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void initType(JSONObject propertyJSON, PropertyProcessingInfo info) {
        super.initType(propertyJSON, info);
        if (!info.validate || !info.hasInvalidProperties) {
            Object minObj = propertyJSON.get((Object)"minLength");
            Object maxObj = propertyJSON.get((Object)"maxLength");
            if (info.validate && !PropertyUtil.INSTANCE.validateMinMaxProperties(minObj, maxObj, false, false)) {
                info.processError();
                return;
            }
            if (minObj != null) {
                this._minLen = ObjectConverter.toInt((Object)minObj);
            }
            if (maxObj != null) {
                this._maxLen = ObjectConverter.toInt((Object)maxObj);
            }
            if (this.defaultValue() != null && info.validate && !this.validateValue(this.defaultValue())) {
                info.processError();
                return;
            }
        }
    }

    @Override
    public PropertyMeta<Object> copy(PropertyMeta<Object> parent) {
        PropertyArrayType pat = new PropertyArrayType(this.simpleId(), this.id(), (PropertyType)parent, this._messages);
        this.pTypeCopy(pat);
        pat._minLen = this._minLen;
        pat._maxLen = this._maxLen;
        pat._items = (PropertyType)this._items.copy(parent);
        return pat;
    }
}

