/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.property;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.property.PropertyProcessingInfo;
import com.ibm.rave.library.property.PropertyType;
import com.ibm.rave.library.property.PropertyUtil;

public class PropertyBooleanType
extends PropertyType<Object> {
    private String _truLabel;
    private String _falsLabel;

    protected PropertyBooleanType(String propertyId, String qualifiedId, PropertyType parent, MessagesRegistry messages) {
        super(propertyId, qualifiedId, parent, messages);
    }

    public String falseLabel() {
        return this._falsLabel;
    }

    public String trueLabel() {
        return this._truLabel;
    }

    @Override
    @SwiftMethodOverload(overloads={"Bool"})
    public boolean validateValue(Object obj) {
        return PropertyUtil.INSTANCE.validateBasicType(obj, 12);
    }

    @Override
    public String type() {
        return "boolean";
    }

    @Override
    public int typeId() {
        return 12;
    }

    @Override
    protected void initType(JSONObject propertyJSON, PropertyProcessingInfo info) {
        super.initType(propertyJSON, info);
        if (!info.validate || !info.hasInvalidProperties) {
            Object obj = propertyJSON.get((Object)"trueLabel");
            Object obj2 = propertyJSON.get((Object)"falseLabel");
            if (info.validate) {
                if (!(obj == null && obj2 == null || obj != null && obj2 != null)) {
                    Library.logError(33, "PropertyBooleanType Constructor");
                    info.processError();
                    return;
                }
                if (obj != null && !PropertyUtil.INSTANCE.validateBasicType(obj, 10)) {
                    info.processError();
                    return;
                }
                if (obj2 != null && !PropertyUtil.INSTANCE.validateBasicType(obj2, 10)) {
                    info.processError();
                    return;
                }
            }
            if (obj != null) {
                this._truLabel = ObjectConverter.toString((Object)obj);
                this._truLabel = this._messages._nls(this._truLabel, this._truLabel);
            }
            if (obj2 != null) {
                this._falsLabel = ObjectConverter.toString((Object)obj2);
                this._falsLabel = this._messages._nls(this._falsLabel, this._falsLabel);
            }
            if (this.defaultValue() != null && info.validate && !this.validateValue(this.defaultValue())) {
                info.processError();
                return;
            }
        }
    }

    @Override
    public PropertyMeta<Object> copy(PropertyMeta<Object> parent) {
        PropertyBooleanType pbt = new PropertyBooleanType(this.simpleId(), this.id(), (PropertyType)parent, this._messages);
        this.pTypeCopy(pbt);
        pbt._truLabel = this._truLabel;
        pbt._falsLabel = this._falsLabel;
        return pbt;
    }
}

