/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.property;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.property.EnumPropertyOption;
import com.ibm.rave.library.property.PropertyProcessingInfo;
import com.ibm.rave.library.property.PropertyType;
import com.ibm.rave.library.property.PropertyUtil;

public class PropertyEnumType
extends PropertyType<Integer> {
    private final OMap<Integer, String> _enums = new OMap();

    protected PropertyEnumType(String propertyId, String qualifiedId, PropertyType parent, MessagesRegistry messages) {
        super(propertyId, qualifiedId, parent, messages);
    }

    @Override
    @SwiftMethodOverload(overloads={"Int", "Int64"})
    public boolean validateValue(Object obj) {
        if (!PropertyUtil.INSTANCE.validateNumeric(obj, false)) {
            return false;
        }
        if (this._enums.get((Object)ObjectConverter.toInt((Object)obj)) == null) {
            Library.logError(34, "Property Validator");
            return false;
        }
        return true;
    }

    public String enumValue(int num) {
        return (String)this._enums.get((Object)num);
    }

    @Override
    public String type() {
        return "enum";
    }

    @Override
    public int typeId() {
        return 13;
    }

    @Override
    protected void initType(JSONObject propertyJSON, PropertyProcessingInfo info) {
        super.initType(propertyJSON, info);
        if (!info.validate || !info.hasInvalidProperties) {
            Object obj = propertyJSON.get((Object)"options");
            if (obj == null) {
                if (info.validate) {
                    Library.logError(41, "Property Validator");
                }
                info.processError();
                return;
            }
            if (!PropertyUtil.INSTANCE.validateBasicType(obj, 20)) {
                info.processError();
                return;
            }
            JSONArray optionsArray = (JSONArray)obj;
            int len = optionsArray.size();
            for (int i = 0; i < len; ++i) {
                Object optionObj = optionsArray.get(i);
                if (!PropertyUtil.INSTANCE.validateBasicType(optionObj, 21)) {
                    info.processError();
                    if (!info.validate) continue;
                    return;
                }
                Object valueObj = ((JSONObject)optionObj).get((Object)"enum");
                Object labelObj = ((JSONObject)optionObj).get((Object)"enumLabel");
                if (valueObj == null || labelObj == null) {
                    if (info.validate) {
                        Library.logError(42, "Property Validator");
                    }
                    info.processError();
                    if (!info.validate) continue;
                    return;
                }
                if (info.validate && !PropertyUtil.INSTANCE.validateNumeric(valueObj, false)) {
                    info.processError();
                    return;
                }
                int value = ObjectConverter.toInt((Object)valueObj);
                if (info.validate && !PropertyUtil.INSTANCE.validateBasicType(labelObj, 10)) {
                    info.processError();
                    return;
                }
                String label = ObjectConverter.toString((Object)labelObj);
                if (this._enums.get((Object)value) != null) {
                    if (info.validate) {
                        Library.logError(43, "Property Validator");
                    }
                    info.processError();
                    if (!info.validate) continue;
                    return;
                }
                this._enums.put((Object)value, (Object)label);
                this._options.add(new EnumPropertyOption(value, label, this._messages));
            }
        }
        if (this.defaultValue() != null) {
            if (PropertyUtil.INSTANCE.validateNumeric(this.defaultValue(), false)) {
                super.setDefaultValue(ObjectConverter.toInt((Object)this.defaultValue()));
            }
            if (info.validate && !this.validateValue(this.defaultValue())) {
                info.processError();
                return;
            }
        }
    }

    @Override
    public PropertyMeta copy(PropertyMeta<Object> parent) {
        PropertyEnumType pet = new PropertyEnumType(this.simpleId(), this.id(), (PropertyType)parent, this._messages);
        this.pTypeCopy(pet);
        for (Integer key : this._enums.keySet()) {
            pet._enums.put((Object)key, this._enums.get((Object)key));
        }
        return pet;
    }
}

