/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.property;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.internal.nativeImpl.PropertyNativeUtils;
import com.ibm.rave.library.property.PropertyProcessingInfo;
import com.ibm.rave.library.property.PropertyType;

public class PropertyJSONObjectType
extends PropertyType<Object> {
    protected PropertyJSONObjectType(String propertyId, String qualifiedId, PropertyType parent, MessagesRegistry messages) {
        super(propertyId, qualifiedId, parent, messages);
    }

    @Override
    @SwiftMethodOverload(skipParameters={1})
    public boolean validateValue(Object obj) {
        if (!PropertyNativeUtils.isJSONObject(obj)) {
            Library.logError(31, "PropertyJSONObjectType validateValue");
            return false;
        }
        return true;
    }

    @Override
    public String type() {
        return "jsonobject";
    }

    @Override
    public int typeId() {
        return 22;
    }

    @Override
    protected void initType(JSONObject propertyJSON, PropertyProcessingInfo info) {
        super.initType(propertyJSON, info);
        if (this.defaultValue() != null && info.validate && !this.validateValue(this.defaultValue())) {
            info.processError();
        }
    }

    @Override
    public PropertyMeta<Object> copy(PropertyMeta<Object> parent) {
        PropertyJSONObjectType pjt = new PropertyJSONObjectType(this.simpleId(), this.id(), (PropertyType)parent, this._messages);
        this.pTypeCopy(pjt);
        return pjt;
    }
}

