/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.property;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.property.NumberPropertyOption;
import com.ibm.rave.library.property.PropertyOption;
import com.ibm.rave.library.property.PropertyProcessingInfo;
import com.ibm.rave.library.property.PropertyType;
import com.ibm.rave.library.property.PropertyUtil;
import java.util.List;

public class PropertyNumericType
extends PropertyType<Number> {
    private double _minVal = Double.NaN;
    private double _maxVal = Double.NaN;
    private boolean _decimal = true;

    protected PropertyNumericType(String propertyId, String qualifiedId, PropertyType parent, MessagesRegistry messages) {
        super(propertyId, qualifiedId, parent, messages);
    }

    @Override
    public List<PropertyOption<Number>> options() {
        return this._options;
    }

    @Override
    @SwiftMethodOverload(overloads={"Int", "Int64", "Double"})
    public boolean validateValue(Object obj) {
        Double minNum;
        Double maxNum = Double.isNaN(this._maxVal) ? null : Double.valueOf(this._maxVal);
        Double d = minNum = Double.isNaN(this._minVal) ? null : Double.valueOf(this._minVal);
        if (!PropertyUtil.INSTANCE.validateNumeric(obj, this._decimal) || !PropertyUtil.INSTANCE.validateMinMaxPropertyValue(minNum, maxNum, this._decimal, ObjectConverter.toDouble((Object)obj))) {
            return false;
        }
        return this._options == null || PropertyUtil.INSTANCE.validateNumericProperties(this._options, ObjectConverter.toDouble((Object)obj), this._decimal);
    }

    public double min() {
        return this._minVal;
    }

    public double max() {
        return this._maxVal;
    }

    public boolean decimal() {
        return this._decimal;
    }

    @Override
    public String type() {
        return "numeric";
    }

    @Override
    public int typeId() {
        return 11;
    }

    @Override
    protected void initType(JSONObject propertyJSON, PropertyProcessingInfo info) {
        super.initType(propertyJSON, info);
        if (!info.validate || !info.hasInvalidProperties) {
            Object obj = propertyJSON.get((Object)"decimal");
            if (obj != null) {
                if (info.validate && !PropertyUtil.INSTANCE.validateBasicType(obj, 12)) {
                    info.processError();
                    return;
                }
                this._decimal = ObjectConverter.toBoolean((Object)obj);
            }
            Object minObj = propertyJSON.get((Object)"min");
            Object maxObj = propertyJSON.get((Object)"max");
            if (info.validate && !PropertyUtil.INSTANCE.validateMinMaxProperties(minObj, maxObj, this._decimal, true)) {
                info.processError();
                return;
            }
            if (minObj != null) {
                this._minVal = ObjectConverter.toDouble((Object)minObj);
            }
            if (maxObj != null) {
                this._maxVal = ObjectConverter.toDouble((Object)maxObj);
            }
            if ((obj = propertyJSON.get((Object)"options")) != null) {
                if (PropertyUtil.INSTANCE.validateBasicType(obj, 20)) {
                    JSONArray optionsArray = (JSONArray)obj;
                    if (info.validate && !PropertyUtil.INSTANCE.validateSimpleOptions(optionsArray, this)) {
                        info.processError();
                        return;
                    }
                    int len = optionsArray.size();
                    this._options = new ArrayEx();
                    for (int i = 0; i < len; ++i) {
                        Double t = this._decimal ? ObjectConverter.toDouble((Object)optionsArray.get(i)) : (double)ObjectConverter.toInt((Object)optionsArray.get(i));
                        this._options.add(new NumberPropertyOption(t));
                    }
                } else {
                    info.processError();
                    if (info.validate) {
                        return;
                    }
                }
            }
            if (this.defaultValue() != null) {
                if (PropertyUtil.INSTANCE.validateNumeric(this.defaultValue(), this._decimal)) {
                    super.setDefaultValue(this._decimal ? ObjectConverter.toDouble((Object)this.defaultValue()) : (double)ObjectConverter.toInt((Object)this.defaultValue()));
                }
                if (info.validate && !this.validateValue(this.defaultValue())) {
                    info.processError();
                    return;
                }
            }
        }
    }

    @Override
    public PropertyMeta copy(PropertyMeta<Object> parent) {
        PropertyNumericType pnt = new PropertyNumericType(this.simpleId(), this.id(), (PropertyType)parent, this._messages);
        this.pTypeCopy(pnt);
        pnt._minVal = this._minVal;
        pnt._maxVal = this._maxVal;
        pnt._decimal = this._decimal;
        return pnt;
    }
}

