/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.property;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.property.PropertyProcessingInfo;
import com.ibm.rave.library.property.PropertyType;
import com.ibm.rave.library.property.PropertyUtil;

public class PropertyObjectType
extends PropertyType<Object> {
    OMap<String, PropertyType<Object>> _childProperties = new OMap();

    protected PropertyObjectType(String propertyId, String qualifiedId, PropertyType<Object> parent, MessagesRegistry messages) {
        super(propertyId, qualifiedId, parent, messages);
    }

    @Override
    public String type() {
        return "object";
    }

    @Override
    public int typeId() {
        return 21;
    }

    public final OMap<String, PropertyType<Object>> childProperties() {
        return this._childProperties;
    }

    @Override
    @SwiftMethodOverload(skipParameters={1})
    public boolean validateValue(Object obj) {
        if (!PropertyUtil.INSTANCE.validateBasicType(obj, 21)) {
            return false;
        }
        JSONObject objJson = (JSONObject)obj;
        for (Object propertyId : objJson.keySet()) {
            PropertyType childProperty = (PropertyType)this._childProperties.get((Object)ObjectConverter.toString(propertyId));
            if (childProperty == null) {
                Library.logError(36, "Property Validator");
                return false;
            }
            Object propVal = objJson.get(propertyId);
            if (childProperty.validateValue(propVal)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void initType(JSONObject propertyJSON, PropertyProcessingInfo info) {
        super.initType(propertyJSON, info);
        if (!info.validate || !info.hasInvalidProperties) {
            this.buildDefaultValue();
        }
    }

    private void buildDefaultValue() {
        JSONObject defaultInstance = (JSONObject)this.defaultValue();
        for (String propertyId : this._childProperties.keySet()) {
            PropertyType childProperty = (PropertyType)this._childProperties.get((Object)propertyId);
            defaultInstance.put((Object)propertyId, childProperty.defaultValue());
        }
    }

    @Override
    public PropertyMeta<Object> copy(PropertyMeta<Object> parent) {
        PropertyObjectType pot = new PropertyObjectType(this.simpleId(), this.id(), (PropertyType)parent, this._messages);
        this.pTypeCopy(pot);
        pot._childProperties = new OMap();
        for (String key : this._childProperties.keySet()) {
            pot._childProperties.put((Object)key, (Object)((PropertyType)((PropertyType)this._childProperties.get((Object)key)).copy(pot)));
        }
        return pot;
    }
}

