/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.property;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.property.PropertyArrayType;
import com.ibm.rave.library.property.PropertyBooleanType;
import com.ibm.rave.library.property.PropertyColorType;
import com.ibm.rave.library.property.PropertyDashArrayType;
import com.ibm.rave.library.property.PropertyEnumType;
import com.ibm.rave.library.property.PropertyFontType;
import com.ibm.rave.library.property.PropertyGeoJsonType;
import com.ibm.rave.library.property.PropertyJSONObjectType;
import com.ibm.rave.library.property.PropertyLengthType;
import com.ibm.rave.library.property.PropertyNumericType;
import com.ibm.rave.library.property.PropertyObjectType;
import com.ibm.rave.library.property.PropertyPaddingType;
import com.ibm.rave.library.property.PropertyPaletteType;
import com.ibm.rave.library.property.PropertyProcessingInfo;
import com.ibm.rave.library.property.PropertyShadowType;
import com.ibm.rave.library.property.PropertyStringType;
import com.ibm.rave.library.property.PropertyType;
import com.ibm.rave.library.property.PropertyUnknownType;
import com.ibm.rave.library.property.PropertyUtil;

public final class PropertyProcessor {
    private PropertyProcessor() {
    }

    public static PropertyProcessingInfo processProperties(JSONObject props, MessagesRegistry messages, boolean validate) {
        PropertyProcessingInfo info = new PropertyProcessingInfo(validate);
        for (Object propertyId : props.keySet()) {
            PropertyType property;
            JSONObject propertyJSON;
            if (info.validate && !PropertyUtil.INSTANCE.validatePropertySimpleId(ObjectConverter.toString(propertyId))) {
                info.processError();
            }
            if ((propertyJSON = PropertyUtil.INSTANCE.propertyEntry(props, ObjectConverter.toString(propertyId))) == null) {
                property = new PropertyUnknownType(ObjectConverter.toString(propertyId), ObjectConverter.toString(propertyId), null, messages);
                info.properties.add((Object)property);
                info.processError();
                if (!info.validate) continue;
                break;
            }
            property = PropertyProcessor.processProperty(propertyJSON, ObjectConverter.toString(propertyId), ObjectConverter.toString(propertyId), null, info, messages);
            info.properties.add((Object)property);
            if (!info.validate || !info.hasInvalidProperties) continue;
            break;
        }
        return info;
    }

    public static PropertyMeta processProperty(JSONObject propertyJSON, String propertyId, MessagesRegistry messages) {
        return PropertyProcessor.processProperty(propertyJSON, propertyId, null, messages, false);
    }

    public static PropertyMeta processProperty(JSONObject propertyJSON, String propertyId, PropertyMeta parent, MessagesRegistry messages) {
        return PropertyProcessor.processProperty(propertyJSON, propertyId, parent, messages, false);
    }

    public static PropertyMeta processProperty(JSONObject propertyJSON, String propertyId, PropertyMeta parent, MessagesRegistry messages, boolean validate) {
        PropertyProcessingInfo info = new PropertyProcessingInfo(validate);
        String qualifiedId = parent != null ? parent.id() + "." + propertyId : propertyId;
        return PropertyProcessor.processProperty(propertyJSON, propertyId, qualifiedId, (PropertyType)parent, info, messages);
    }

    private static PropertyType processProperty(JSONObject propertyJSON, String propertyId, String qualifiedId, PropertyType parent, PropertyProcessingInfo info, MessagesRegistry messages) {
        String type = PropertyUtil.INSTANCE.type(propertyJSON);
        if (type == null) {
            PropertyUnknownType property = new PropertyUnknownType(propertyId, qualifiedId, parent, messages);
            info.processError();
            return property;
        }
        if ("object".equals(type)) {
            PropertyObjectType property = new PropertyObjectType(propertyId, qualifiedId, parent, messages);
            JSONObject objectPropertiesEntry = PropertyUtil.INSTANCE.propertyEntry(propertyJSON, "properties");
            if (objectPropertiesEntry == null) {
                info.processError();
                return property;
            }
            if (objectPropertiesEntry.keySet().size() == 0) {
                if (info.validate) {
                    Library.logError(28, "Property entry '" + propertyId + " @PropertyProcessor.processProperty");
                }
                info.processError();
                return property;
            }
            for (Object childPropertyId : objectPropertiesEntry.keySet()) {
                if (info.validate && !PropertyUtil.INSTANCE.validatePropertySimpleId(ObjectConverter.toString(childPropertyId))) {
                    info.processError();
                    return property;
                }
                String childQualifiedId = qualifiedId + "." + ObjectConverter.toString(childPropertyId);
                JSONObject childPropertyEntry = PropertyUtil.INSTANCE.propertyEntry(objectPropertiesEntry, ObjectConverter.toString(childPropertyId));
                if (childPropertyEntry == null) {
                    PropertyUnknownType unknownChildProperty = new PropertyUnknownType(ObjectConverter.toString(childPropertyId), childQualifiedId, property, messages);
                    property._childProperties.put((Object)ObjectConverter.toString(childPropertyId), (Object)unknownChildProperty);
                    info.processError();
                    if (!info.validate) continue;
                    return property;
                }
                PropertyType childProperty = PropertyProcessor.processProperty(childPropertyEntry, ObjectConverter.toString(childPropertyId), childQualifiedId, property, info, messages);
                property._childProperties.put((Object)ObjectConverter.toString(childPropertyId), (Object)childProperty);
                if (!info.validate || !info.hasInvalidProperties) continue;
                return property;
            }
            property.initType(propertyJSON, info);
            return property;
        }
        if ("array".equals(type)) {
            PropertyType itemsProperty;
            PropertyArrayType property = new PropertyArrayType(propertyId, qualifiedId, parent, messages);
            String itemsQualifiedId = qualifiedId + ".items";
            JSONObject itemsObj = PropertyUtil.INSTANCE.propertyEntry(propertyJSON, "items");
            if (itemsObj == null) {
                PropertyUnknownType unknownItemsProperty;
                property._items = unknownItemsProperty = new PropertyUnknownType("items", itemsQualifiedId, property, messages);
                info.processError();
                return property;
            }
            property._items = itemsProperty = PropertyProcessor.processProperty(itemsObj, "items", itemsQualifiedId, property, info, messages);
            if (info.validate && info.hasInvalidProperties) {
                return property;
            }
            property.initType(propertyJSON, info);
            return property;
        }
        if ("boolean".equals(type)) {
            PropertyBooleanType property = new PropertyBooleanType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("color".equals(type)) {
            PropertyColorType property = new PropertyColorType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("enum".equals(type)) {
            PropertyEnumType property = new PropertyEnumType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("font".equals(type)) {
            PropertyFontType property = new PropertyFontType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("numeric".equals(type)) {
            PropertyNumericType property = new PropertyNumericType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("palette".equals(type)) {
            PropertyPaletteType property = new PropertyPaletteType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("length".equals(type)) {
            PropertyLengthType property = new PropertyLengthType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("padding".equals(type)) {
            PropertyPaddingType property = new PropertyPaddingType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("dasharray".equals(type)) {
            PropertyDashArrayType property = new PropertyDashArrayType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("string".equals(type)) {
            PropertyStringType property = new PropertyStringType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("jsonobject".equals(type)) {
            PropertyJSONObjectType property = new PropertyJSONObjectType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("geojson".equals(type)) {
            PropertyGeoJsonType property = new PropertyGeoJsonType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        if ("shadow".equals(type)) {
            PropertyShadowType property = new PropertyShadowType(propertyId, qualifiedId, parent, messages);
            property.initType(propertyJSON, info);
            return property;
        }
        PropertyUnknownType property = new PropertyUnknownType(propertyId, qualifiedId, parent, messages);
        if (info.validate) {
            Library.logError(29, "Property entry '" + propertyId + "' with unknown type: " + type + " @PropertyProcessor.processProperty");
        }
        info.processError();
        return property;
    }

    public static boolean validate(JSONObject props, boolean validate) {
        PropertyProcessingInfo info = PropertyProcessor.processProperties(props, MessagesRegistry.EmptyRegistry(), validate);
        return !info.hasInvalidProperties;
    }

    public static boolean validate(ArrayEx<JSONObject> propsArray, boolean validate) {
        ArrayEx infos = new ArrayEx();
        for (int i = 0; i < propsArray.size(); ++i) {
            JSONObject props = (JSONObject)propsArray.get(i);
            PropertyProcessingInfo info = PropertyProcessor.processProperties(props, MessagesRegistry.EmptyRegistry(), validate);
            if (info.hasInvalidProperties) {
                return false;
            }
            infos.add((Object)info);
        }
        if (infos.size() > 1) {
            OMap flattennedPropTypeMap = new OMap();
            PropertyProcessingInfo info = (PropertyProcessingInfo)infos.get(0);
            PropertyProcessor.flattenPropertyType(info, (OMap<String, PropertyMeta>)flattennedPropTypeMap);
            for (int i = 1; i < infos.size(); ++i) {
                OMap map = new OMap();
                info = (PropertyProcessingInfo)infos.get(i);
                PropertyProcessor.flattenPropertyType(info, (OMap<String, PropertyMeta>)map);
                for (String id : map.keySet()) {
                    PropertyMeta newProp = (PropertyMeta)map.get((Object)id);
                    PropertyMeta existingProp = (PropertyMeta)flattennedPropTypeMap.get((Object)id);
                    if (existingProp == null || newProp.typeId() == existingProp.typeId()) {
                        flattennedPropTypeMap.put((Object)id, (Object)newProp);
                        continue;
                    }
                    Library.logError(30, "Property entry '" + id + " @PropertyProcessor.validate");
                    return false;
                }
            }
        }
        return true;
    }

    private static void flattenPropertyType(PropertyProcessingInfo info, OMap<String, PropertyMeta> flattennedPropTypeMap) {
        for (PropertyMeta propertyMeta : info.properties) {
            PropertyProcessor.flattenPropertyType(propertyMeta, flattennedPropTypeMap);
        }
    }

    private static void flattenPropertyType(PropertyMeta propertyType, OMap<String, PropertyMeta> flattennedPropTypeMap) {
        flattennedPropTypeMap.put((Object)propertyType.id(), (Object)propertyType);
        if (propertyType.typeId() == 21) {
            PropertyObjectType objPropType = (PropertyObjectType)propertyType;
            for (String key : objPropType.childProperties().keySet()) {
                PropertyType childProperty = (PropertyType)objPropType.childProperties().get((Object)key);
                PropertyProcessor.flattenPropertyType(childProperty, flattennedPropTypeMap);
            }
        }
    }
}

