/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.property;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.internal.nativeImpl.PropertyNativeUtils;
import com.ibm.rave.library.property.PropertyOption;
import com.ibm.rave.library.property.PropertyProcessingInfo;
import com.ibm.rave.library.property.PropertyType;
import com.ibm.rave.library.property.PropertyUtil;
import com.ibm.rave.library.property.StringPropertyOption;
import java.util.List;

public class PropertyStringType
extends PropertyType<String> {
    private int _minLen = -1;
    private int _maxLen = -1;
    private boolean _localize;
    private String _regExp;

    protected PropertyStringType(String propertyId, String qualifiedId, PropertyType parent, MessagesRegistry messages) {
        super(propertyId, qualifiedId, parent, messages);
    }

    public int minLength() {
        return this._minLen;
    }

    public int maxLength() {
        return this._maxLen;
    }

    private List<String> optionsIDs() {
        ArrayEx ids = new ArrayEx();
        if (this._options != null) {
            for (PropertyOption option : this._options) {
                ids.add(option.value());
            }
        }
        return ids;
    }

    public String regularExpression() {
        return this._regExp;
    }

    @Override
    public String type() {
        return "string";
    }

    @Override
    public int typeId() {
        return 10;
    }

    public boolean localize() {
        return this._localize;
    }

    @Override
    protected void initType(JSONObject propertyJSON, PropertyProcessingInfo info) {
        super.initType(propertyJSON, info);
        if (!info.validate || !info.hasInvalidProperties) {
            Object obj;
            Object minObj = propertyJSON.get((Object)"minLength");
            Object maxObj = propertyJSON.get((Object)"maxLength");
            if (info.validate && !PropertyUtil.INSTANCE.validateMinMaxProperties(minObj, maxObj, false, false)) {
                info.processError();
                return;
            }
            if (minObj != null) {
                this._minLen = ObjectConverter.toInt((Object)minObj);
            }
            if (maxObj != null) {
                this._maxLen = ObjectConverter.toInt((Object)maxObj);
            }
            if ((obj = propertyJSON.get((Object)"localize")) != null) {
                if (info.validate && !PropertyUtil.INSTANCE.validateBasicType(obj, 12)) {
                    info.processError();
                    return;
                }
                this._localize = ObjectConverter.toBoolean((Object)obj);
            }
            if ((obj = propertyJSON.get((Object)"regExp")) != null) {
                if (info.validate && !PropertyUtil.INSTANCE.validateBasicType(obj, 10)) {
                    info.processError();
                    return;
                }
                this._regExp = ObjectConverter.toString((Object)obj);
            }
            if ((obj = propertyJSON.get((Object)"options")) != null) {
                if (PropertyUtil.INSTANCE.validateBasicType(obj, 20)) {
                    JSONArray optionsArray = (JSONArray)obj;
                    if (info.validate && !PropertyUtil.INSTANCE.validateStringOptions(optionsArray, this)) {
                        info.processError();
                        return;
                    }
                    int len = optionsArray.size();
                    this._options = new ArrayEx();
                    for (int i = 0; i < len; ++i) {
                        JSONObject o = (JSONObject)optionsArray.get(i);
                        this._options.add(new StringPropertyOption(ObjectConverter.toString((Object)o.get((Object)"value")), ObjectConverter.toString((Object)o.get((Object)"id")), this._messages));
                    }
                } else {
                    info.processError();
                    if (info.validate) {
                        return;
                    }
                }
            }
            if (this.defaultValue() != null && info.validate && !this.validateValue(this.defaultValue())) {
                info.processError();
                return;
            }
        }
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public boolean validateValue(Object obj) {
        Integer minNum;
        Integer maxNum = this._maxLen != -1 ? Integer.valueOf(this._maxLen) : null;
        Integer n = minNum = this._minLen != -1 ? Integer.valueOf(this._minLen) : null;
        if (!PropertyUtil.INSTANCE.validateBasicType(obj, 10) || !PropertyUtil.INSTANCE.validateMinMaxPropertyValue(minNum, maxNum, false, ObjectConverter.toString((Object)obj).length())) {
            return false;
        }
        if (this._regExp != null && this._regExp.length() > 0 && !PropertyNativeUtils.stringMatchesRexExp(ObjectConverter.toString((Object)obj), this._regExp)) {
            Library.logError(37, "Property Validator");
            return false;
        }
        return this._options.size() <= 0 || PropertyUtil.INSTANCE.validateObjectExistInList(this.optionsIDs(), obj);
    }

    @Override
    public PropertyMeta copy(PropertyMeta<Object> parent) {
        PropertyStringType pst = new PropertyStringType(this.simpleId(), this.id(), (PropertyType)parent, this._messages);
        this.pTypeCopy(pst);
        pst._minLen = this._minLen;
        pst._maxLen = this._maxLen;
        pst._localize = this._localize;
        pst._regExp = this._regExp;
        return pst;
    }
}

