/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.property;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.property.PropertyOption;
import com.ibm.rave.library.property.PropertyProcessingInfo;
import com.ibm.rave.library.property.PropertyUtil;
import java.util.List;

public abstract class PropertyType<E>
extends PropertyMeta<E> {
    private boolean _required = false;
    private String _name;
    private String _description;
    private String _icon;
    private Object _defaultValue;
    private ArrayEx<String> _tags;
    private String _resetView = "redraw";
    @SwiftWeak(value=false)
    PropertyType<Object> _parent;
    private final String _qualifiedId;
    private final String _simpleId;
    protected List<PropertyOption<E>> _options = new ArrayEx();
    protected MessagesRegistry _messages;

    protected PropertyType(String propertyId, String qualifiedId, PropertyType<Object> parent, MessagesRegistry messages) {
        this._messages = messages;
        this._simpleId = propertyId;
        this._qualifiedId = qualifiedId;
        this._parent = parent;
        this._tags = new ArrayEx();
    }

    protected void initType(JSONObject propertyJSON, PropertyProcessingInfo info) {
        Object obj = propertyJSON.get((Object)"name");
        if (obj != null) {
            if (info.validate && !PropertyUtil.INSTANCE.validateBasicType(obj, 10)) {
                info.processError();
                return;
            }
            this._name = ObjectConverter.toString((Object)obj);
        }
        if ((obj = propertyJSON.get((Object)"description")) != null) {
            if (info.validate && !PropertyUtil.INSTANCE.validateBasicType(obj, 10)) {
                info.processError();
                return;
            }
            this._description = ObjectConverter.toString((Object)obj);
        }
        if ((obj = propertyJSON.get((Object)"icon")) != null) {
            if (info.validate && !PropertyUtil.INSTANCE.validateBasicType(obj, 10)) {
                info.processError();
                return;
            }
            this._icon = ObjectConverter.toString((Object)obj);
        }
        if (this.typeId() == 21) {
            this._defaultValue = new JSONObject();
            return;
        }
        if (this._parent != null && this._parent.typeId() == 20) {
            return;
        }
        obj = propertyJSON.get((Object)"default");
        if (obj != null) {
            this._defaultValue = obj;
        }
        if ((obj = propertyJSON.get((Object)"required")) != null) {
            if (info.validate && !PropertyUtil.INSTANCE.validateBasicType(obj, 12)) {
                info.processError();
                return;
            }
            this._required = ObjectConverter.toBoolean((Object)obj);
        }
        if (info.validate && this._required && this._defaultValue == null) {
            Library.logError(39, "Property Validator");
            info.processError();
            return;
        }
        obj = propertyJSON.get((Object)"resetView");
        if (obj != null) {
            this._resetView = ObjectConverter.toString((Object)obj);
        }
        if ((obj = propertyJSON.get((Object)"tags")) != null && PropertyUtil.INSTANCE.validateBasicType(obj, 20)) {
            JSONArray tagsArray = (JSONArray)obj;
            for (int i = 0; i < tagsArray.size(); ++i) {
                this._tags.add((Object)ObjectConverter.toString((Object)tagsArray.get(i)));
            }
        }
    }

    @Override
    public boolean required() {
        return this._required;
    }

    @Override
    public String simpleId() {
        return this._simpleId;
    }

    @Override
    public String id() {
        return this._qualifiedId;
    }

    @Override
    public String name() {
        return this._messages._nls(this._name, this._name);
    }

    @Override
    public String description() {
        return this._messages._nls(this._description, this._description);
    }

    @Override
    public String icon() {
        return this._icon;
    }

    @Override
    public Object defaultValue() {
        return this._defaultValue;
    }

    @Override
    public final void setDefaultValue(Object defaultValue) {
        this._defaultValue = defaultValue;
    }

    public PropertyType<Object> parent() {
        return this._parent;
    }

    protected Object canonicalValue(Object value) {
        return value;
    }

    @Override
    public List<PropertyOption<E>> options() {
        return this._options;
    }

    @Override
    public ArrayEx<String> tags() {
        return this._tags;
    }

    @Override
    public String resetView() {
        return this._resetView;
    }

    protected void pTypeCopy(PropertyType pType) {
        pType._required = this._required;
        pType._name = this._name;
        pType._description = this._description;
        pType._icon = this._icon;
        pType._defaultValue = this._defaultValue;
        pType._resetView = this._resetView;
        pType._options = new ArrayEx();
        for (PropertyOption<E> option : this._options) {
            pType._options.add(option);
        }
        pType._tags = new ArrayEx();
        for (String tag : this._tags) {
            pType._tags.add((Object)tag);
        }
    }
}

